/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.port;

import java.net.SocketAddress;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.DerivedAttribute;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedStatistic;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.StatisticType;
import org.apache.qpid.server.model.StatisticUnit;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.model.port.AmqpPortImpl;
import org.apache.qpid.server.model.port.ClientAuthCapablePort;

@ManagedObject(category=false, type="AMQP")
public interface AmqpPort<X extends AmqpPort<X>>
extends ClientAuthCapablePort<X> {
    public static final String DEFAULT_AMQP_TCP_NO_DELAY = "true";
    public static final String DEFAULT_AMQP_NEED_CLIENT_AUTH = "false";
    public static final String DEFAULT_AMQP_WANT_CLIENT_AUTH = "false";
    public static final String MAX_OPEN_CONNECTIONS = "maxOpenConnections";
    public static final String THREAD_POOL_SIZE = "threadPoolSize";
    public static final String NUMBER_OF_SELECTORS = "numberOfSelectors";
    public static final String DEFAULT_AMQP_PROTOCOLS = "qpid.port.default_amqp_protocols";
    public static final String PORT_AMQP_THREAD_POOL_SIZE = "qpid.port.amqp.threadPool.size";
    public static final String PORT_AMQP_THREAD_POOL_KEEP_ALIVE_TIMEOUT = "qpid.port.amqp.threadPool.keep_alive_timeout";
    public static final String PORT_AMQP_NUMBER_OF_SELECTORS = "qpid.port.amqp.threadPool.numberOfSelectors";
    public static final String PORT_AMQP_ACCEPT_BACKLOG = "qpid.port.amqp.acceptBacklog";
    public static final String PORT_AMQP_OUTBOUND_MESSAGE_BUFFER_SIZE = "qpid.port.amqp.outboundMessageBufferSize";
    @ManagedContextDefault(name="qpid.port.default_amqp_protocols")
    public static final String INSTALLED_PROTOCOLS = AmqpPortImpl.getInstalledProtocolsAsString();
    public static final String PORT_MAX_OPEN_CONNECTIONS = "qpid.port.max_open_connections";
    @ManagedContextDefault(name="qpid.port.max_open_connections")
    public static final int DEFAULT_MAX_OPEN_CONNECTIONS = -1;
    @ManagedContextDefault(name="qpid.port.amqp.threadPool.size")
    public static final long DEFAULT_PORT_AMQP_THREAD_POOL_SIZE = 8L;
    @ManagedContextDefault(name="qpid.port.amqp.threadPool.keep_alive_timeout")
    public static final long DEFAULT_PORT_AMQP_THREAD_POOL_KEEP_ALIVE_TIMEOUT = 60L;
    @ManagedContextDefault(name="qpid.port.amqp.threadPool.numberOfSelectors")
    public static final long DEFAULT_PORT_AMQP_NUMBER_OF_SELECTORS = Math.max(1L, 1L);
    @ManagedContextDefault(name="qpid.port.amqp.acceptBacklog")
    public static final int DEFAULT_PORT_AMQP_ACCEPT_BACKLOG = 1024;
    public static final String OPEN_CONNECTIONS_WARN_PERCENT = "qpid.port.open_connections_warn_percent";
    @ManagedContextDefault(name="qpid.port.open_connections_warn_percent")
    public static final int DEFAULT_OPEN_CONNECTIONS_WARN_PERCENT = 80;
    @ManagedContextDefault(name="qpid.port.amqp.outboundMessageBufferSize")
    public static final long DEFAULT_PORT_AMQP_OUTBOUND_MESSAGE_BUFFER_SIZE = 0x100000L;
    public static final String PROTOCOL_HANDSHAKE_TIMEOUT = "qpid.port.protocol_handshake_timeout";
    @ManagedContextDefault(name="qpid.port.protocol_handshake_timeout", description="Maximum time allowed for a new connection to send a protocol header. If the connection does not send a protocol header within this time, the connection will be aborted.")
    public static final long DEFAULT_PROTOCOL_HANDSHAKE_TIMEOUT = 2000L;

    public SSLContext getSSLContext();

    @ManagedAttribute(defaultValue="*")
    public String getBindingAddress();

    @ManagedAttribute(defaultValue="true")
    public boolean isTcpNoDelay();

    @ManagedAttribute(defaultValue="${qpid.port.amqp.threadPool.size}")
    public int getThreadPoolSize();

    @ManagedAttribute(defaultValue="${qpid.port.amqp.threadPool.numberOfSelectors}")
    public int getNumberOfSelectors();

    @Override
    @ManagedAttribute(defaultValue="false")
    public boolean getNeedClientAuth();

    @Override
    @ManagedAttribute(defaultValue="false")
    public boolean getWantClientAuth();

    @Override
    @ManagedAttribute
    public TrustStore<?> getClientCertRecorder();

    @Override
    @ManagedAttribute(mandatory=true)
    public AuthenticationProvider getAuthenticationProvider();

    @Override
    @ManagedAttribute(defaultValue="TCP", validValues={"org.apache.qpid.server.model.port.AmqpPortImpl#getAllAvailableTransportCombinations()"})
    public Set<Transport> getTransports();

    @Override
    @ManagedAttribute(defaultValue="${qpid.port.default_amqp_protocols}", validValues={"org.apache.qpid.server.model.port.AmqpPortImpl#getAllAvailableProtocolCombinations()"})
    public Set<Protocol> getProtocols();

    @ManagedAttribute(defaultValue="${qpid.port.max_open_connections}")
    public int getMaxOpenConnections();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.COUNT, label="Connections")
    public int getConnectionCount();

    @DerivedAttribute(description="Maximum time allowed for a new connection to send a protocol header. If the connection does not send a protocol header within this time, the connection will be aborted.")
    public long getProtocolHandshakeTimeout();

    public NamedAddressSpace getAddressSpace(String var1);

    public boolean canAcceptNewConnection(SocketAddress var1);

    public int incrementConnectionCount();

    public int decrementConnectionCount();

    public int getNetworkBufferSize();
}

