/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.port;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Container;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.SystemConfig;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.model.port.AbstractPort;
import org.apache.qpid.server.model.port.PortWithAuthProvider;

public abstract class AbstractPortWithAuthProvider<X extends AbstractPortWithAuthProvider<X>>
extends AbstractPort<X>
implements PortWithAuthProvider<X> {
    private final Container<?> _container;
    @ManagedAttributeField
    private AuthenticationProvider _authenticationProvider;

    public AbstractPortWithAuthProvider(Map<String, Object> attributes, Container<?> container) {
        super(attributes, container);
        this._container = container;
    }

    @Override
    public AuthenticationProvider getAuthenticationProvider() {
        SystemConfig systemConfig = this.getAncestor(SystemConfig.class);
        if (systemConfig.isManagementMode()) {
            return this._container.getManagementModeAuthenticationProvider();
        }
        return this._authenticationProvider;
    }

    @Override
    public void onValidate() {
        super.onValidate();
        AuthenticationProvider authenticationProvider = this.getAuthenticationProvider();
        Set<Transport> transports = this.getTransports();
        this.validateAuthenticationMechanisms(authenticationProvider, transports);
    }

    private void validateAuthenticationMechanisms(AuthenticationProvider<?> authenticationProvider, Set<Transport> transports) {
        ArrayList<String> availableMechanisms = new ArrayList<String>(authenticationProvider.getMechanisms());
        if (authenticationProvider.getDisabledMechanisms() != null) {
            availableMechanisms.removeAll(authenticationProvider.getDisabledMechanisms());
        }
        if (availableMechanisms.isEmpty()) {
            throw new IllegalConfigurationException("The authentication provider '" + authenticationProvider.getName() + "' on port '" + this.getName() + "' has all authentication mechanisms disabled.");
        }
        if (this.hasNonTLSTransport(transports) && authenticationProvider.getSecureOnlyMechanisms() != null) {
            availableMechanisms.removeAll(authenticationProvider.getSecureOnlyMechanisms());
            if (availableMechanisms.isEmpty()) {
                throw new IllegalConfigurationException("The port '" + this.getName() + "' allows for non TLS connections, but all authentication " + "mechanisms of the authentication provider '" + authenticationProvider.getName() + "' are disabled on non-secure connections.");
            }
        }
    }

    @Override
    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        if (changedAttributes.contains("authenticationProvider") || changedAttributes.contains("transports")) {
            PortWithAuthProvider port = (PortWithAuthProvider)proxyForValidation;
            this.validateAuthenticationMechanisms(port.getAuthenticationProvider(), port.getTransports());
        }
    }
}

