/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.port;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.messages.PortMessages;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.Container;
import org.apache.qpid.server.model.KeyStore;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.util.ParameterizedTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPort<X extends AbstractPort<X>>
extends AbstractConfiguredObject<X>
implements Port<X> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPort.class);
    private final Container<?> _container;
    private final EventLogger _eventLogger;
    @ManagedAttributeField
    private int _port;
    @ManagedAttributeField
    private KeyStore<?> _keyStore;
    @ManagedAttributeField
    private Collection<TrustStore> _trustStores;
    @ManagedAttributeField
    private Set<Transport> _transports;
    @ManagedAttributeField
    private Set<Protocol> _protocols;
    private List<String> _tlsProtocolBlackList;
    private List<String> _tlsProtocolWhiteList;
    private List<String> _tlsCipherSuiteWhiteList;
    private List<String> _tlsCipherSuiteBlackList;

    public AbstractPort(Map<String, Object> attributes, Container<?> container) {
        super(AbstractPort.parentsMap(container), attributes);
        this._container = container;
        this._eventLogger = container.getEventLogger();
        this._eventLogger.message(PortMessages.CREATE(this.getName()));
    }

    @Override
    protected void onOpen() {
        super.onOpen();
        this._tlsProtocolWhiteList = this.getContextValue(List.class, ParameterizedTypes.LIST_OF_STRINGS, "qpid.security.tls.protocolWhiteList");
        this._tlsProtocolBlackList = this.getContextValue(List.class, ParameterizedTypes.LIST_OF_STRINGS, "qpid.security.tls.protocolBlackList");
        this._tlsCipherSuiteWhiteList = this.getContextValue(List.class, ParameterizedTypes.LIST_OF_STRINGS, "qpid.security.tls.cipherSuiteWhiteList");
        this._tlsCipherSuiteBlackList = this.getContextValue(List.class, ParameterizedTypes.LIST_OF_STRINGS, "qpid.security.tls.cipherSuiteBlackList");
    }

    @Override
    public void onValidate() {
        super.onValidate();
        boolean useTLSTransport = this.isUsingTLSTransport();
        if (useTLSTransport && this.getKeyStore() == null) {
            throw new IllegalConfigurationException("Can't create a port which uses a secure transport but has no KeyStore");
        }
        if (!this.isDurable()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " must be durable");
        }
        for (Port p : this._container.getChildren(Port.class)) {
            if (p.getPort() != this.getPort() || p.getPort() == 0 || p == this) continue;
            throw new IllegalConfigurationException("Can't add port " + this.getName() + " because port number " + this.getPort() + " is already configured for port " + p.getName());
        }
    }

    protected final boolean isUsingTLSTransport() {
        return this.isUsingTLSTransport(this.getTransports());
    }

    protected final boolean isUsingTLSTransport(Collection<Transport> transports) {
        return this.hasTransportOfType(transports, true);
    }

    protected final boolean hasNonTLSTransport() {
        return this.hasNonTLSTransport(this.getTransports());
    }

    protected final boolean hasNonTLSTransport(Collection<Transport> transports) {
        return this.hasTransportOfType(transports, false);
    }

    private boolean hasTransportOfType(Collection<Transport> transports, boolean secure) {
        boolean hasTransport = false;
        if (transports != null) {
            for (Transport transport : transports) {
                if (secure != transport.isSecure()) continue;
                hasTransport = true;
                break;
            }
        }
        return hasTransport;
    }

    @Override
    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        Port updated = (Port)proxyForValidation;
        if (!this.getName().equals(updated.getName())) {
            throw new IllegalConfigurationException("Changing the port name is not allowed");
        }
        if (changedAttributes.contains("port")) {
            int newPort = updated.getPort();
            if (this.getPort() != newPort) {
                for (Port p : this._container.getChildren(Port.class)) {
                    if (p.getPort() != newPort) continue;
                    throw new IllegalConfigurationException("Port number " + newPort + " is already in use by port " + p.getName());
                }
            }
        }
        Set<Transport> transports = updated.getTransports();
        Set<Protocol> protocols = updated.getProtocols();
        boolean usesSsl = this.isUsingTLSTransport(transports);
        if (usesSsl && updated.getKeyStore() == null) {
            throw new IllegalConfigurationException("Can't create port which requires SSL but has no key store configured.");
        }
    }

    @Override
    public int getPort() {
        return this._port;
    }

    @Override
    public Set<Transport> getTransports() {
        return this._transports;
    }

    @Override
    public Set<Protocol> getProtocols() {
        return this._protocols;
    }

    @Override
    public Collection<Connection> getConnections() {
        return this.getChildren(Connection.class);
    }

    @StateTransition(currentState={State.ACTIVE, State.QUIESCED, State.ERRORED}, desiredState=State.DELETED)
    private ListenableFuture<Void> doDelete() {
        return this.doAfterAlways(this.closeAsync(), new Runnable(){

            @Override
            public void run() {
                AbstractPort.this.deleted();
                AbstractPort.this.setState(State.DELETED);
                AbstractPort.this._eventLogger.message(PortMessages.DELETE(AbstractPort.this.getType(), AbstractPort.this.getName()));
            }
        });
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.QUIESCED, State.ERRORED}, desiredState=State.ACTIVE)
    protected ListenableFuture<Void> activate() {
        try {
            this.setState(this.onActivate());
        }
        catch (RuntimeException e) {
            this.setState(State.ERRORED);
            throw new IllegalConfigurationException("Unable to active port '" + this.getName() + "'of type " + this.getType() + " on " + this.getPort(), e);
        }
        return Futures.immediateFuture(null);
    }

    @StateTransition(currentState={State.UNINITIALIZED}, desiredState=State.QUIESCED)
    private ListenableFuture<Void> startQuiesced() {
        this.setState(State.QUIESCED);
        return Futures.immediateFuture(null);
    }

    protected State onActivate() {
        return State.ACTIVE;
    }

    @Override
    public List<String> getTlsProtocolWhiteList() {
        return this._tlsProtocolWhiteList;
    }

    @Override
    public List<String> getTlsProtocolBlackList() {
        return this._tlsProtocolBlackList;
    }

    @Override
    public List<String> getTlsCipherSuiteWhiteList() {
        return this._tlsCipherSuiteWhiteList;
    }

    @Override
    public List<String> getTlsCipherSuiteBlackList() {
        return this._tlsCipherSuiteBlackList;
    }

    @Override
    public KeyStore getKeyStore() {
        return this._keyStore;
    }

    @Override
    public Collection<TrustStore> getTrustStores() {
        return this._trustStores;
    }

    @Override
    public String toString() {
        return this.getCategoryClass().getSimpleName() + "[id=" + this.getId() + ", name=" + this.getName() + ", type=" + this.getType() + ", port=" + this.getPort() + "]";
    }
}

