/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.port;

import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Container;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.model.port.AbstractPortWithAuthProvider;
import org.apache.qpid.server.model.port.ClientAuthCapablePort;
import org.apache.qpid.server.security.ManagedPeerCertificateTrustStore;

public abstract class AbstractClientAuthCapablePortWithAuthProvider<X extends AbstractClientAuthCapablePortWithAuthProvider<X>>
extends AbstractPortWithAuthProvider<X>
implements ClientAuthCapablePort<X> {
    public static final String DEFAULT_AMQP_NEED_CLIENT_AUTH = "false";
    public static final String DEFAULT_AMQP_WANT_CLIENT_AUTH = "false";
    @ManagedAttributeField
    private boolean _needClientAuth;
    @ManagedAttributeField
    private boolean _wantClientAuth;
    @ManagedAttributeField
    private TrustStore<?> _clientCertRecorder;

    public AbstractClientAuthCapablePortWithAuthProvider(Map<String, Object> attributes, Container<?> broker) {
        super(attributes, broker);
    }

    @Override
    public boolean getNeedClientAuth() {
        return this._needClientAuth;
    }

    @Override
    public TrustStore<?> getClientCertRecorder() {
        return this._clientCertRecorder;
    }

    @Override
    public boolean getWantClientAuth() {
        return this._wantClientAuth;
    }

    @Override
    public void onValidate() {
        boolean useClientAuth;
        super.onValidate();
        boolean bl = useClientAuth = this.getNeedClientAuth() || this.getWantClientAuth();
        if (useClientAuth && (this.getTrustStores() == null || this.getTrustStores().isEmpty())) {
            throw new IllegalConfigurationException("Can't create port which requests SSL client certificates but has no trust stores configured.");
        }
        boolean useTLSTransport = this.isUsingTLSTransport();
        if (useClientAuth && !useTLSTransport) {
            throw new IllegalConfigurationException("Can't create port which requests SSL client certificates but doesn't use SSL transport.");
        }
        if (useClientAuth && this.getClientCertRecorder() != null && !(this.getClientCertRecorder() instanceof ManagedPeerCertificateTrustStore)) {
            throw new IllegalConfigurationException("Only trust stores of type ManagedCertificateStore may be used as the client certificate recorder");
        }
    }

    @Override
    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        ClientAuthCapablePort updated = (ClientAuthCapablePort)proxyForValidation;
        boolean requiresCertificate = updated.getNeedClientAuth() || updated.getWantClientAuth();
        boolean usesSsl = this.isUsingTLSTransport(updated.getTransports());
        if (usesSsl) {
            if ((updated.getTrustStores() == null || updated.getTrustStores().isEmpty()) && requiresCertificate) {
                throw new IllegalConfigurationException("Can't create port which requests SSL client certificates but has no trust store configured.");
            }
        } else if (requiresCertificate) {
            throw new IllegalConfigurationException("Can't create port which requests SSL client certificates but doesn't use SSL transport.");
        }
        if (requiresCertificate && updated.getClientCertRecorder() != null && !(updated.getClientCertRecorder() instanceof ManagedPeerCertificateTrustStore)) {
            throw new IllegalConfigurationException("Only trust stores of type ManagedCertificateStore may be used as the client certificate recorder");
        }
    }
}

