/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.adapter;

import com.google.common.base.Supplier;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.messages.ChannelMessages;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Consumer;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.Publisher;
import org.apache.qpid.server.model.Session;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.protocol.ConsumerListener;
import org.apache.qpid.server.transport.AbstractAMQPConnection;
import org.apache.qpid.server.transport.TransactionTimeoutTicker;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.transport.network.Ticker;

public final class SessionAdapter
extends AbstractConfiguredObject<SessionAdapter>
implements Session<SessionAdapter> {
    private static final String OPEN_TRANSACTION_TIMEOUT_ERROR = "Open transaction timed out";
    private static final String IDLE_TRANSACTION_TIMEOUT_ERROR = "Idle transaction timed out";
    private final AMQSessionModel _session;
    private final Action _deleteModelTask;
    private final AbstractAMQPConnection<?> _amqpConnection;

    public SessionAdapter(AbstractAMQPConnection<?> amqpConnection, final AMQSessionModel session) {
        super(SessionAdapter.parentsMap(amqpConnection), SessionAdapter.createAttributes(session));
        this._amqpConnection = amqpConnection;
        this._session = session;
        this._session.addConsumerListener(new ConsumerListener(){

            @Override
            public void consumerAdded(Consumer<?> consumer) {
                SessionAdapter.this.childAdded(consumer);
            }

            @Override
            public void consumerRemoved(Consumer<?> consumer) {
                SessionAdapter.this.childRemoved(consumer);
            }
        });
        session.setModelObject(this);
        this._deleteModelTask = new Action(){

            @Override
            public void performAction(Object object) {
                session.removeDeleteTask(this);
                SessionAdapter.this.deleteAsync();
            }
        };
        session.addDeleteTask(this._deleteModelTask);
        this.setState(State.ACTIVE);
    }

    private static Map<String, Object> createAttributes(AMQSessionModel session) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("id", UUID.randomUUID());
        attributes.put("name", String.valueOf(session.getChannelId()));
        attributes.put("durable", false);
        attributes.put("lifetimePolicy", (Object)LifetimePolicy.DELETE_ON_SESSION_END);
        return attributes;
    }

    @Override
    protected void postResolveChildren() {
        super.postResolveChildren();
        this.registerTransactionTimeoutTickers(this._amqpConnection, this._session);
    }

    @Override
    public int getChannelId() {
        return this._session.getChannelId();
    }

    @Override
    public boolean isProducerFlowBlocked() {
        return this._session.getBlocking();
    }

    @Override
    public Collection<Consumer> getConsumers() {
        return this._session.getConsumers();
    }

    @Override
    public Collection<Publisher> getPublishers() {
        return Collections.emptySet();
    }

    @Override
    public <C extends ConfiguredObject> Collection<C> getChildren(Class<C> clazz) {
        if (clazz == Consumer.class) {
            return this.getConsumers();
        }
        if (clazz == Publisher.class) {
            return this.getPublishers();
        }
        return Collections.emptySet();
    }

    @Override
    public long getConsumerCount() {
        return this._session.getConsumerCount();
    }

    @Override
    public long getLocalTransactionBegins() {
        return this._session.getTxnStart();
    }

    @Override
    public int getLocalTransactionOpen() {
        long open = this._session.getTxnStart() - (this._session.getTxnCommits() + this._session.getTxnRejects());
        return open > 0L ? 1 : 0;
    }

    @Override
    public long getLocalTransactionRollbacks() {
        return this._session.getTxnRejects();
    }

    @Override
    public long getUnacknowledgedMessages() {
        return this._session.getUnacknowledgedMessageCount();
    }

    @Override
    public Date getTransactionStartTime() {
        return new Date(this._session.getTransactionStartTime());
    }

    @Override
    public Date getTransactionUpdateTime() {
        return new Date(this._session.getTransactionUpdateTime());
    }

    @StateTransition(currentState={State.ACTIVE}, desiredState=State.DELETED)
    private ListenableFuture<Void> doDelete() {
        this.deleted();
        this.setState(State.DELETED);
        this._session.removeDeleteTask(this._deleteModelTask);
        return Futures.immediateFuture(null);
    }

    private void registerTransactionTimeoutTickers(AbstractAMQPConnection<?> amqpConnection, final AMQSessionModel session) {
        NamedAddressSpace addressSpace = amqpConnection.getAddressSpace();
        if (addressSpace instanceof VirtualHost) {
            final EventLogger eventLogger = amqpConnection.getEventLogger();
            VirtualHost virtualhost = (VirtualHost)addressSpace;
            final ArrayList<TransactionTimeoutTicker> tickers = new ArrayList<TransactionTimeoutTicker>(4);
            Supplier<Long> transactionStartTimeSupplier = new Supplier<Long>(){

                public Long get() {
                    return SessionAdapter.this._session.getTransactionStartTime();
                }
            };
            Supplier<Long> transactionUpdateTimeSupplier = new Supplier<Long>(){

                public Long get() {
                    return SessionAdapter.this._session.getTransactionUpdateTime();
                }
            };
            long notificationRepeatPeriod = this.getContextValue(Long.class, "qpid.session.transactionTimeoutNotificationRepeatPeriod");
            if (virtualhost.getStoreTransactionOpenTimeoutWarn() > 0L) {
                tickers.add(new TransactionTimeoutTicker(virtualhost.getStoreTransactionOpenTimeoutWarn(), notificationRepeatPeriod, transactionStartTimeSupplier, new Action<Long>(){

                    @Override
                    public void performAction(Long age) {
                        eventLogger.message(SessionAdapter.this._session.getLogSubject(), ChannelMessages.OPEN_TXN(age));
                    }
                }));
            }
            if (virtualhost.getStoreTransactionOpenTimeoutClose() > 0L) {
                tickers.add(new TransactionTimeoutTicker(virtualhost.getStoreTransactionOpenTimeoutClose(), notificationRepeatPeriod, transactionStartTimeSupplier, new Action<Long>(){

                    @Override
                    public void performAction(Long age) {
                        SessionAdapter.this._session.doTimeoutAction(SessionAdapter.OPEN_TRANSACTION_TIMEOUT_ERROR);
                    }
                }));
            }
            if (virtualhost.getStoreTransactionIdleTimeoutWarn() > 0L) {
                tickers.add(new TransactionTimeoutTicker(virtualhost.getStoreTransactionIdleTimeoutWarn(), notificationRepeatPeriod, transactionUpdateTimeSupplier, new Action<Long>(){

                    @Override
                    public void performAction(Long age) {
                        eventLogger.message(SessionAdapter.this._session.getLogSubject(), ChannelMessages.IDLE_TXN(age));
                    }
                }));
            }
            if (virtualhost.getStoreTransactionIdleTimeoutClose() > 0L) {
                tickers.add(new TransactionTimeoutTicker(virtualhost.getStoreTransactionIdleTimeoutClose(), notificationRepeatPeriod, transactionUpdateTimeSupplier, new Action<Long>(){

                    @Override
                    public void performAction(Long age) {
                        SessionAdapter.this._session.doTimeoutAction(SessionAdapter.IDLE_TRANSACTION_TIMEOUT_ERROR);
                    }
                }));
            }
            for (Ticker ticker : tickers) {
                session.addTicker(ticker);
            }
            Action deleteTickerTask = new Action(){

                @Override
                public void performAction(Object o) {
                    session.removeDeleteTask(this);
                    for (Ticker ticker : tickers) {
                        session.removeTicker(ticker);
                    }
                }
            };
            session.addDeleteTask(deleteTickerTask);
        }
    }
}

