/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.security.AccessControlContext;
import java.security.Principal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.DerivedAttribute;
import org.apache.qpid.server.model.Initialization;
import org.apache.qpid.server.model.ManageableMessage;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedOperation;
import org.apache.qpid.server.model.ManagedStatistic;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.Param;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.StatisticType;
import org.apache.qpid.server.model.StatisticUnit;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.preferences.UserPreferencesCreator;
import org.apache.qpid.server.transport.AMQPConnection;
import org.apache.qpid.server.virtualhost.HouseKeepingTask;
import org.apache.qpid.server.virtualhost.NodeAutoCreationPolicy;

@ManagedObject(defaultType="ProvidedStore", description="<p>A virtualhost is a namespace in which messaging is performed. Virtualhosts are independent; the messaging goes on a within a virtualhost is independent of any messaging that goes on in another virtualhost. For instance, a queue named <i>foo</i> defined in one virtualhost is completely independent of a queue named <i>foo</i> in another virtualhost.</p><p>A virtualhost is backed by storage which is used to store the messages.</p>")
public interface VirtualHost<X extends VirtualHost<X>>
extends ConfiguredObject<X>,
EventLoggerProvider,
NamedAddressSpace,
UserPreferencesCreator {
    public static final String CLASS_DESCRIPTION = "<p>A virtualhost is a namespace in which messaging is performed. Virtualhosts are independent; the messaging goes on a within a virtualhost is independent of any messaging that goes on in another virtualhost. For instance, a queue named <i>foo</i> defined in one virtualhost is completely independent of a queue named <i>foo</i> in another virtualhost.</p><p>A virtualhost is backed by storage which is used to store the messages.</p>";
    public static final String QUEUE_DEAD_LETTER_QUEUE_ENABLED = "queue.deadLetterQueueEnabled";
    public static final String HOUSEKEEPING_CHECK_PERIOD = "housekeepingCheckPeriod";
    public static final String STORE_TRANSACTION_IDLE_TIMEOUT_CLOSE = "storeTransactionIdleTimeoutClose";
    public static final String STORE_TRANSACTION_IDLE_TIMEOUT_WARN = "storeTransactionIdleTimeoutWarn";
    public static final String STORE_TRANSACTION_OPEN_TIMEOUT_CLOSE = "storeTransactionOpenTimeoutClose";
    public static final String STORE_TRANSACTION_OPEN_TIMEOUT_WARN = "storeTransactionOpenTimeoutWarn";
    public static final String HOUSE_KEEPING_THREAD_COUNT = "houseKeepingThreadCount";
    public static final String MODEL_VERSION = "modelVersion";
    public static final String ENABLED_CONNECTION_VALIDATORS = "enabledConnectionValidators";
    public static final String DISABLED_CONNECTION_VALIDATORS = "disabledConnectionValidators";
    public static final String GLOBAL_ADDRESS_DOMAINS = "globalAddressDomains";
    public static final String VIRTUALHOST_WORK_DIR_VAR = "virtualhost.work_dir";
    public static final String VIRTUALHOST_WORK_DIR_VAR_EXPRESSION = "${qpid.work_dir}${file.separator}${ancestor:virtualhost:name}";
    public static final String NUMBER_OF_SELECTORS = "numberOfSelectors";
    public static final String CONNECTION_THREAD_POOL_SIZE = "connectionThreadPoolSize";
    public static final String CONNECTION_THREAD_POOL_KEEP_ALIVE_TIMEOUT = "connectionThreadPoolKeepAliveTimeout";
    public static final String PREFERENCE_STORE_ATTRIBUTES = "preferenceStoreAttributes";
    public static final String NODE_AUTO_CREATION_POLICIES = "nodeAutoCreationPolicies";
    @ManagedContextDefault(name="virtualhost.work_dir")
    public static final String VIRTUALHOST_WORK_DIR = "${qpid.work_dir}${file.separator}${ancestor:virtualhost:name}";
    @ManagedContextDefault(name="queue.deadLetterQueueEnabled")
    public static final boolean DEFAULT_DEAD_LETTER_QUEUE_ENABLED = false;
    public static final String DEFAULT_DLE_NAME_SUFFIX = "_DLE";
    @ManagedContextDefault(name="virtualhost.housekeepingCheckPeriod")
    public static final long DEFAULT_HOUSEKEEPING_CHECK_PERIOD = 30000L;
    @ManagedContextDefault(name="connectionThreadPoolKeepAliveTimeout")
    public static final long DEFAULT_CONNECTION_THREAD_POOL_KEEP_ALIVE_TIMEOUT = 60L;
    @ManagedContextDefault(name="virtualhost.storeTransactionIdleTimeoutClose")
    public static final long DEFAULT_STORE_TRANSACTION_IDLE_TIMEOUT_CLOSE = 0L;
    @ManagedContextDefault(name="virtualhost.storeTransactionIdleTimeoutWarn")
    public static final long DEFAULT_STORE_TRANSACTION_IDLE_TIMEOUT_WARN = 180000L;
    @ManagedContextDefault(name="virtualhost.storeTransactionOpenTimeoutClose")
    public static final long DEFAULT_STORE_TRANSACTION_OPEN_TIMEOUT_CLOSE = 0L;
    @ManagedContextDefault(name="virtualhost.storeTransactionOpenTimeoutWarn")
    public static final long DEFAULT_STORE_TRANSACTION_OPEN_TIMEOUT_WARN = 300000L;
    @ManagedContextDefault(name="virtualhost.housekeepingThreadCount")
    public static final int DEFAULT_HOUSEKEEPING_THREAD_COUNT = 4;
    public static final String VIRTUALHOST_CONNECTION_THREAD_POOL_SIZE = "virtualhost.connectionThreadPool.size";
    @ManagedContextDefault(name="virtualhost.connectionThreadPool.size")
    public static final long DEFAULT_VIRTUALHOST_CONNECTION_THREAD_POOL_SIZE = Math.max(Runtime.getRuntime().availableProcessors() * 2, 64);
    public static final String VIRTUALHOST_CONNECTION_THREAD_POOL_NUMBER_OF_SELECTORS = "virtualhost.connectionThreadPool.numberOfSelectors";
    @ManagedContextDefault(name="virtualhost.connectionThreadPool.numberOfSelectors")
    public static final long DEFAULT_VIRTUALHOST_CONNECTION_THREAD_POOL_NUMBER_OF_SELECTORS = Math.max(DEFAULT_VIRTUALHOST_CONNECTION_THREAD_POOL_SIZE / 8L, 1L);
    @ManagedContextDefault(name="virtualhost.enabledConnectionValidators")
    public static final String DEFAULT_ENABLED_VALIDATORS = "[]";
    @ManagedContextDefault(name="virtualhost.disabledConnectionValidators")
    public static final String DEFAULT_DISABLED_VALIDATORS = "[]";

    @ManagedAttribute(defaultValue="${queue.deadLetterQueueEnabled}", initialization=Initialization.materialize)
    public boolean isQueue_deadLetterQueueEnabled();

    @ManagedAttribute(defaultValue="${virtualhost.housekeepingCheckPeriod}")
    public long getHousekeepingCheckPeriod();

    @ManagedAttribute(defaultValue="${virtualhost.storeTransactionIdleTimeoutClose}", description="The maximum length of time, in milliseconds, that an open store transaction may remain idle. If a transaction exceeds this threshold, the resource that created the transaction will be closed automatically.")
    public long getStoreTransactionIdleTimeoutClose();

    @ManagedAttribute(defaultValue="${virtualhost.storeTransactionIdleTimeoutWarn}", description="The maximum length of time, in milliseconds, that an open store transaction may remain idle. If a transaction exceeds this threshold, warnings will be written to the logs.")
    public long getStoreTransactionIdleTimeoutWarn();

    @ManagedAttribute(defaultValue="${virtualhost.storeTransactionOpenTimeoutClose}", description="The maximum length of time, in milliseconds, that a store transaction may remain open. If a transaction exceeds this threshold, the resource that created the transaction will be closed automatically.")
    public long getStoreTransactionOpenTimeoutClose();

    @ManagedAttribute(defaultValue="${virtualhost.storeTransactionOpenTimeoutWarn}", description="The maximum length of time, in milliseconds, that a store transaction may remain open. If a transaction exceeds this threshold, warnings will be written to the logs.")
    public long getStoreTransactionOpenTimeoutWarn();

    @ManagedAttribute(defaultValue="${virtualhost.housekeepingThreadCount}")
    public int getHousekeepingThreadCount();

    @ManagedAttribute(defaultValue="[]", description="a list of policies used for auto-creating nodes (such as Queues or Exchanges) when an address is published to or subscribed from and no node matching the address currently exists. Each policy describes a pattern to match against the address, the circumstances when auto-creation should occur (on publish, on consume, or both), the type of node to be created, and the properties of the node.")
    public List<NodeAutoCreationPolicy> getNodeAutoCreationPolicies();

    @ManagedAttribute(defaultValue="${virtualhost.connectionThreadPool.size}")
    public int getConnectionThreadPoolSize();

    @ManagedAttribute(defaultValue="${virtualhost.connectionThreadPool.numberOfSelectors}")
    public int getNumberOfSelectors();

    @DerivedAttribute(persist=true)
    public String getModelVersion();

    public void executeTask(String var1, Runnable var2, AccessControlContext var3);

    @ManagedAttribute(defaultValue="${virtualhost.enabledConnectionValidators}")
    public List<String> getEnabledConnectionValidators();

    @ManagedAttribute(defaultValue="${virtualhost.disabledConnectionValidators}")
    public List<String> getDisabledConnectionValidators();

    @Override
    @ManagedAttribute(defaultValue="[]")
    public List<String> getGlobalAddressDomains();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.COUNT, label="Queues")
    public long getQueueCount();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.COUNT, label="Exchanges")
    public long getExchangeCount();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.COUNT, label="Connections")
    public long getConnectionCount();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.BYTES, label="Inbound")
    public long getBytesIn();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.BYTES, label="Outbound")
    public long getBytesOut();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.MESSAGES, label="Inbound")
    public long getMessagesIn();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.MESSAGES, label="Outbound")
    public long getMessagesOut();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.BYTES, label="Total Number of Bytes Evacuated from Memory Due to Flow to Disk")
    public long getBytesEvacuatedFromMemory();

    public Broker<?> getBroker();

    @Override
    @ManagedOperation(nonModifying=true, changesConfiguredObjectState=false)
    public Collection<? extends Connection<?>> getConnections();

    @ManagedOperation(nonModifying=true, changesConfiguredObjectState=false)
    public Connection<?> getConnection(@Param(name="name") String var1);

    @ManagedOperation(secure=true, description="Publishes a message to a specified address. Returns the number of queues onto which it has been placed,  or zero, if the address routes to no queues.", changesConfiguredObjectState=false)
    public int publishMessage(@Param(name="message") ManageableMessage var1);

    @ManagedOperation(nonModifying=true, description="Extract configuration", paramRequiringSecure="includeSecureAttributes", changesConfiguredObjectState=false)
    public Map<String, Object> extractConfig(@Param(name="includeSecureAttributes", description="include attributes that may contain passwords or other confidential information", defaultValue="false") boolean var1);

    @ManagedOperation(nonModifying=true, description="Extract message store content", secure=true, changesConfiguredObjectState=false)
    public Content exportMessageStore();

    @ManagedOperation(description="Import message store content", secure=true, changesConfiguredObjectState=false)
    public void importMessageStore(@Param(name="source", description="Extract file") String var1);

    public void start();

    public void stop();

    @Override
    public Principal getPrincipal();

    @Override
    public void registerConnection(AMQPConnection<?> var1);

    @Override
    public void deregisterConnection(AMQPConnection<?> var1);

    public Queue<?> getAttainedQueue(UUID var1);

    public <T extends ConfiguredObject<?>> T getAttainedChildFromAddress(Class<T> var1, String var2);

    @Override
    public MessageDestination getDefaultDestination();

    public DurableConfigurationStore getDurableConfigurationStore();

    public void scheduleHouseKeepingTask(long var1, HouseKeepingTask var3);

    public ScheduledFuture<?> scheduleTask(long var1, Runnable var3);

    public String getLocalAddress(String var1);

    public void setFirstOpening(boolean var1);

    public void executeTransaction(TransactionalOperation var1);

    @Override
    public MessageStore getMessageStore();

    @Override
    public String getType();

    public void setTargetSize(long var1);

    public long getTargetSize();

    public long getTotalQueueDepthBytes();

    public static interface TransactionalOperation {
        public void withinTransaction(Transaction var1);

        public List<Long> getModifiedMessageIds();
    }

    public static interface Transaction {
        public void dequeue(QueueEntry var1);

        public void copy(QueueEntry var1, Queue<?> var2);

        public void move(QueueEntry var1, Queue<?> var2);
    }
}

