/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.util.List;
import javax.net.ssl.TrustManager;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.VirtualHostNode;

@ManagedObject(defaultType="FileTrustStore")
public interface TrustStore<X extends TrustStore<X>>
extends ConfiguredObject<X> {
    @ManagedAttribute(defaultValue="false", description="If true the Trust Store will expose its certificates as a special artificial message source.")
    public boolean isExposedAsMessageSource();

    @ManagedAttribute(defaultValue="[]", description="If 'exposedAsMessageSource' is true, the trust store will expose its certificates only to VirtualHostNodes in this list or if this list is empty to all VirtualHostNodes who are not in the 'excludedVirtualHostNodeMessageSources' list.")
    public List<VirtualHostNode<?>> getIncludedVirtualHostNodeMessageSources();

    @ManagedAttribute(defaultValue="[]", description="If 'exposedAsMessageSource' is true and 'includedVirtualHostNodeMessageSources' is empty, the trust store will expose its certificates only to VirtualHostNodes who are not in this list.")
    public List<VirtualHostNode<?>> getExcludedVirtualHostNodeMessageSources();

    public TrustManager[] getTrustManagers() throws GeneralSecurityException;

    public Certificate[] getCertificates() throws GeneralSecurityException;
}

