/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ModelRoot;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.preferences.PreferenceStoreAttributes;
import org.apache.qpid.server.store.preferences.PreferencesRoot;

@ManagedObject(creatable=false)
public interface SystemConfig<X extends SystemConfig<X>>
extends ConfiguredObject<X>,
ModelRoot,
PreferencesRoot {
    public static final String MANAGEMENT_MODE = "managementMode";
    public static final String MANAGEMENT_MODE_QUIESCE_VIRTUAL_HOSTS = "managementModeQuiesceVirtualHosts";
    public static final String MANAGEMENT_MODE_HTTP_PORT_OVERRIDE = "managementModeHttpPortOverride";
    public static final String MANAGEMENT_MODE_PASSWORD = "managementModePassword";
    public static final String INITIAL_CONFIGURATION_LOCATION = "initialConfigurationLocation";
    public static final String STARTUP_LOGGED_TO_SYSTEM_OUT = "startupLoggedToSystemOut";
    @ManagedContextDefault(name="qpid.broker.defaultPreferenceStoreAttributes")
    public static final String DEFAULT_PREFERENCE_STORE_ATTRIBUTES = "{\"type\": \"JSON\", \"attributes\":{\"path\": \"${json:qpid.work_dir}${json:file.separator}preferences.json\"}}";
    @ManagedContextDefault(name="qpid.default_posix_file_permissions")
    public static final String DEFAULT_POSIX_FILE_PERMISSIONS = "rw-r-----";

    @ManagedAttribute(immutable=true, defaultValue="Broker")
    public String getDefaultContainerType();

    @ManagedAttribute(defaultValue="false")
    public boolean isManagementMode();

    @ManagedAttribute(defaultValue="0")
    public int getManagementModeHttpPortOverride();

    @ManagedAttribute(defaultValue="false")
    public boolean isManagementModeQuiesceVirtualHosts();

    @ManagedAttribute(secure=true)
    public String getManagementModePassword();

    @ManagedAttribute
    public String getInitialConfigurationLocation();

    @ManagedAttribute(defaultValue="true")
    public boolean isStartupLoggedToSystemOut();

    @ManagedAttribute(description="Configuration for the preference store, e.g. type, path, etc.", defaultValue="${qpid.broker.defaultPreferenceStoreAttributes}")
    public PreferenceStoreAttributes getPreferenceStoreAttributes();

    public EventLogger getEventLogger();

    public <C extends ConfiguredObject<C>> C getChild(Class<C> var1);

    public DurableConfigurationStore getConfigurationStore();

    public Runnable getOnContainerResolveTask();

    public void setOnContainerResolveTask(Runnable var1);

    public Runnable getOnContainerCloseTask();

    public void setOnContainerCloseTask(Runnable var1);
}

