/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.util.Collection;
import java.util.Date;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Consumer;
import org.apache.qpid.server.model.DerivedAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedStatistic;
import org.apache.qpid.server.model.Publisher;
import org.apache.qpid.server.model.StatisticType;
import org.apache.qpid.server.model.StatisticUnit;

@ManagedObject
public interface Session<X extends Session<X>>
extends ConfiguredObject<X> {
    public static final String CHANNEL_ID = "channelId";
    public static final String PRODUCER_FLOW_BLOCKED = "producerFlowBlocked";
    public static final String TRANSACTION_TIMEOUT_NOTIFICATION_REPEAT_PERIOD = "qpid.session.transactionTimeoutNotificationRepeatPeriod";
    @ManagedContextDefault(name="qpid.session.transactionTimeoutNotificationRepeatPeriod", description="Frequency, in milliseconds, with which transaction timeout warnings will be repeated.")
    public static final long TRANSACTION_TIMEOUT_NOTIFICATION_REPEAT_PERIOD_DEFAULT = 10000L;
    public static final String PRODUCER_AUTH_CACHE_SIZE = "producer.authCacheSize";
    @ManagedContextDefault(name="producer.authCacheSize", description="Maximum number of distinct destinations for which a cached auth value may be held")
    public static final int PRODUCER_AUTH_CACHE_SIZE_DEFAULT = 20;
    public static final String PRODUCER_AUTH_CACHE_TIMEOUT = "producer.authCacheTimeout";
    @ManagedContextDefault(name="producer.authCacheTimeout", description="Maximum time, in milliseconds, for which a cached auth value may be retained")
    public static final long PRODUCER_AUTH_CACHE_TIMEOUT_DEFAULT = 300000L;

    @DerivedAttribute
    public int getChannelId();

    @DerivedAttribute
    public boolean isProducerFlowBlocked();

    public Collection<Consumer> getConsumers();

    public Collection<Publisher> getPublishers();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.COUNT, label="Consumers")
    public long getConsumerCount();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.COUNT, label="Transactions")
    public long getLocalTransactionBegins();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.COUNT, label="Open Transactions")
    public int getLocalTransactionOpen();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.COUNT, label="Rolled-back Transactions")
    public long getLocalTransactionRollbacks();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.MESSAGES, label="Prefetched")
    public long getUnacknowledgedMessages();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.ABSOLUTE_TIME, label="Last Transaction Start")
    public Date getTransactionStartTime();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.ABSOLUTE_TIME, label="Last Transaction Update")
    public Date getTransactionUpdateTime();
}

