/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.exchange.ExchangeReferrer;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.MessageInfo;
import org.apache.qpid.server.message.MessageSource;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.Binding;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Consumer;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.DerivedAttribute;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.ExclusivityPolicy;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedOperation;
import org.apache.qpid.server.model.ManagedStatistic;
import org.apache.qpid.server.model.Param;
import org.apache.qpid.server.model.QueueNotificationListener;
import org.apache.qpid.server.model.StatisticType;
import org.apache.qpid.server.model.StatisticUnit;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.protocol.CapacityChecker;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.queue.NotificationCheck;
import org.apache.qpid.server.queue.QueueConsumer;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.QueueEntryVisitor;
import org.apache.qpid.server.store.MessageDurability;
import org.apache.qpid.server.store.MessageEnqueueRecord;
import org.apache.qpid.server.util.Deletable;

@ManagedObject(defaultType="standard", description="<p>Queues are named entities within a VirtualHost that hold/buffer messages for later delivery to consumer applications. Consumers subscribe to a queue in order to receive messages for it.</p><p>The Broker supports different queue types, each with different delivery semantics. It also allows for messages on a queue to be treated as a group.</p>")
public interface Queue<X extends Queue<X>>
extends ConfiguredObject<X>,
Comparable<X>,
ExchangeReferrer,
BaseQueue,
MessageSource,
CapacityChecker,
MessageDestination,
Deletable<X> {
    public static final String CLASS_DESCRIPTION = "<p>Queues are named entities within a VirtualHost that hold/buffer messages for later delivery to consumer applications. Consumers subscribe to a queue in order to receive messages for it.</p><p>The Broker supports different queue types, each with different delivery semantics. It also allows for messages on a queue to be treated as a group.</p>";
    public static final String ALERT_REPEAT_GAP = "alertRepeatGap";
    public static final String ALERT_THRESHOLD_MESSAGE_AGE = "alertThresholdMessageAge";
    public static final String ALERT_THRESHOLD_MESSAGE_SIZE = "alertThresholdMessageSize";
    public static final String ALERT_THRESHOLD_QUEUE_DEPTH_BYTES = "alertThresholdQueueDepthBytes";
    public static final String ALERT_THRESHOLD_QUEUE_DEPTH_MESSAGES = "alertThresholdQueueDepthMessages";
    public static final String ALTERNATE_EXCHANGE = "alternateExchange";
    public static final String EXCLUSIVE = "exclusive";
    public static final String MESSAGE_DURABILITY = "messageDurability";
    public static final String MESSAGE_GROUP_KEY = "messageGroupKey";
    public static final String MESSAGE_GROUP_SHARED_GROUPS = "messageGroupSharedGroups";
    public static final String MESSAGE_GROUP_DEFAULT_GROUP = "messageGroupDefaultGroup";
    public static final String MAXIMUM_DELIVERY_ATTEMPTS = "maximumDeliveryAttempts";
    public static final String NO_LOCAL = "noLocal";
    public static final String OWNER = "owner";
    public static final String QUEUE_FLOW_CONTROL_SIZE_BYTES = "queueFlowControlSizeBytes";
    public static final String QUEUE_FLOW_RESUME_SIZE_BYTES = "queueFlowResumeSizeBytes";
    public static final String QUEUE_FLOW_STOPPED = "queueFlowStopped";
    public static final String MAXIMUM_MESSAGE_TTL = "maximumMessageTtl";
    public static final String MINIMUM_MESSAGE_TTL = "minimumMessageTtl";
    public static final String DEFAULT_FILTERS = "defaultFilters";
    public static final String ENSURE_NONDESTRUCTIVE_CONSUMERS = "ensureNondestructiveConsumers";
    public static final String HOLD_ON_PUBLISH_ENABLED = "holdOnPublishEnabled";
    public static final String QUEUE_MINIMUM_ESTIMATED_MEMORY_FOOTPRINT = "queue.minimumEstimatedMemoryFootprint";
    @ManagedContextDefault(name="queue.minimumEstimatedMemoryFootprint")
    public static final long DEFAULT_MINIMUM_ESTIMATED_MEMORY_FOOTPRINT = 102400L;
    public static final String QUEUE_ESTIMATED_MESSAGE_MEMORY_OVERHEAD = "queue.estimatedMessageMemoryOverhead";
    @ManagedContextDefault(name="queue.estimatedMessageMemoryOverhead")
    public static final long DEFAULT_ESTIMATED_MESSAGE_MEMORY_OVERHEAD = 1024L;
    public static final String MAX_ASYNCHRONOUS_DELIVERIES = "queue.maxAsynchronousDeliveries";
    @ManagedContextDefault(name="queue.maxAsynchronousDeliveries")
    public static final int DEFAULT_MAX_ASYNCHRONOUS_DELIVERIES = 80;
    public static final String MIME_TYPE_TO_FILE_EXTENSION = "qpid.mimeTypeToFileExtension";
    @ManagedContextDefault(name="qpid.mimeTypeToFileExtension", description="A mapping of MIME types to file extensions.")
    public static final String DEFAULT_MIME_TYPE_TO_FILE_EXTENSION = "{\"application/json\":\".json\",\"application/pdf\":\".pdf\",\"application/xml\":\".xml\",\"image/jpeg\":\".jpg\",\"image/tiff\":\".tiff\",\"text/plain\":\".txt\"}";
    @ManagedContextDefault(name="queue.defaultExclusivityPolicy", description="the ExclusivityPolicy to apply to queues where none is explicitly set")
    public static final String DEFAULT_EXCLUSIVITY = "NONE";
    @ManagedContextDefault(name="queue.defaultEnsureNonDestructiveConsumers", description="the value to use for the ensureNondestructiveCnsumers attribute of a queue where none is explicitly set")
    public static final String DEFAULT_ENSURE_NON_DESTRUCTIVE_CONSUMERS = "false";
    @ManagedContextDefault(name="qpid.broker_default-shared-message-group")
    public static final String DEFAULT_SHARED_MESSAGE_GROUP = "qpid.no-group";
    @ManagedContextDefault(name="queue.maximumDistinctGroups")
    public static final int DEFAULT_MAXIMUM_DISTINCT_GROUPS = 255;
    @ManagedContextDefault(name="queue.maximumDeliveryAttempts")
    public static final int DEFAULT_MAXIMUM_DELIVERY_ATTEMPTS = 0;
    @ManagedContextDefault(name="queue.queueFlowControlSizeBytes")
    public static final long DEFAULT_FLOW_CONTROL_SIZE_BYTES = 0L;
    @ManagedContextDefault(name="queue.queueFlowResumeSizeBytes")
    public static final long DEFAULT_FLOW_CONTROL_RESUME_SIZE_BYTES = 0L;
    @ManagedContextDefault(name="queue.alertThresholdMessageAge")
    public static final long DEFAULT_ALERT_THRESHOLD_MESSAGE_AGE = 0L;
    @ManagedContextDefault(name="queue.alertThresholdMessageSize")
    public static final long DEFAULT_ALERT_THRESHOLD_MESSAGE_SIZE = 0L;
    @ManagedContextDefault(name="queue.alertThresholdQueueDepthBytes")
    public static final long DEFAULT_ALERT_THRESHOLD_QUEUE_DEPTH = 0L;
    @ManagedContextDefault(name="queue.alertThresholdQueueDepthMessages")
    public static final long DEFAULT_ALERT_THRESHOLD_MESSAGE_COUNT = 0L;
    @ManagedContextDefault(name="queue.alertRepeatGap")
    public static final long DEFAULT_ALERT_REPEAT_GAP = 30000L;
    @ManagedContextDefault(name="queue.defaultMessageDurability", description="the value to use for the messageDurability attribute of a queue where none is explicitly set")
    public static final String DEFAULT_MESSAGE_DURABILTY = "DEFAULT";
    @ManagedContextDefault(name="queue.holdOnPublishEnabled")
    public static final boolean DEFAULT_HOLD_ON_PUBLISH_ENABLED = false;

    @ManagedAttribute
    public Exchange getAlternateExchange();

    @ManagedAttribute(defaultValue="${queue.defaultExclusivityPolicy}")
    public ExclusivityPolicy getExclusive();

    @ManagedAttribute(defaultValue="${queue.defaultEnsureNonDestructiveConsumers}")
    public boolean isEnsureNondestructiveConsumers();

    @DerivedAttribute(persist=true)
    public String getOwner();

    @ManagedAttribute
    public boolean isNoLocal();

    @ManagedAttribute
    public String getMessageGroupKey();

    @ManagedAttribute(defaultValue="${qpid.broker_default-shared-message-group}")
    public String getMessageGroupDefaultGroup();

    @ManagedAttribute(defaultValue="${queue.maximumDistinctGroups}")
    public int getMaximumDistinctGroups();

    @ManagedAttribute
    public boolean isMessageGroupSharedGroups();

    @ManagedAttribute(defaultValue="${queue.maximumDeliveryAttempts}")
    public int getMaximumDeliveryAttempts();

    @ManagedAttribute(defaultValue="${queue.queueFlowControlSizeBytes}")
    public long getQueueFlowControlSizeBytes();

    @ManagedAttribute(defaultValue="${queue.queueFlowResumeSizeBytes}")
    public long getQueueFlowResumeSizeBytes();

    @DerivedAttribute
    public boolean isQueueFlowStopped();

    @ManagedAttribute(defaultValue="${queue.alertThresholdMessageAge}")
    public long getAlertThresholdMessageAge();

    @ManagedAttribute(defaultValue="${queue.alertThresholdMessageSize}")
    public long getAlertThresholdMessageSize();

    @ManagedAttribute(defaultValue="${queue.alertThresholdQueueDepthBytes}")
    public long getAlertThresholdQueueDepthBytes();

    @ManagedAttribute(defaultValue="${queue.alertThresholdQueueDepthMessages}")
    public long getAlertThresholdQueueDepthMessages();

    @ManagedAttribute(defaultValue="${queue.alertRepeatGap}")
    public long getAlertRepeatGap();

    @Override
    @ManagedAttribute(defaultValue="${queue.defaultMessageDurability}")
    public MessageDurability getMessageDurability();

    @ManagedAttribute
    public long getMinimumMessageTtl();

    @ManagedAttribute
    public long getMaximumMessageTtl();

    @ManagedAttribute
    public Map<String, Map<String, List<String>>> getDefaultFilters();

    @ManagedAttribute(defaultValue="${queue.holdOnPublishEnabled}", description="If true then entries in the queue will be held (not made available for delivery or browsing) until the time (specified in milliseconds since the epoch) given in the message header (AMQP 0-8,0-9,0-9-1,0-10) or message annotation (AMQP 1.0) \"x-qpid-not-valid-before\".  Note that the actual time the entry is made visible may depend on how frequently the virtual host housekeeping thread runs.")
    public boolean isHoldOnPublishEnabled();

    public Collection<? extends Binding<?>> getBindings();

    public Collection<? extends Consumer<?>> getConsumers();

    public void visit(QueueEntryVisitor var1);

    public ListenableFuture<Integer> deleteAndReturnCountAsync();

    public int deleteAndReturnCount();

    public void setNotificationListener(QueueNotificationListener var1);

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.COUNT, label="Bindings")
    public int getBindingCount();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.COUNT, label="Consumers")
    public int getConsumerCount();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.COUNT, label="Consumers with credit")
    public int getConsumerCountWithCredit();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.BYTES, label="Delivered (Persistent)")
    public long getPersistentDequeuedBytes();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.MESSAGES, label="Delivered (Persistent)")
    public long getPersistentDequeuedMessages();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.BYTES, label="Enqueued (Persistent)")
    public long getPersistentEnqueuedBytes();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.MESSAGES, label="Enqueued (Persistent)")
    public long getPersistentEnqueuedMessages();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.BYTES, label="Queue Depth")
    public long getQueueDepthBytes();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.MESSAGES, label="Queue Depth")
    public int getQueueDepthMessages();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.BYTES, label="Delivered")
    public long getTotalDequeuedBytes();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.MESSAGES, label="Delivered")
    public long getTotalDequeuedMessages();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.BYTES, label="Enqueued")
    public long getTotalEnqueuedBytes();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.MESSAGES, label="Enqueued")
    public long getTotalEnqueuedMessages();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.MESSAGES, label="Prefetched")
    public long getUnacknowledgedBytes();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.MESSAGES, label="Prefetched")
    public long getUnacknowledgedMessages();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.ABSOLUTE_TIME, label="Oldest Message")
    public long getOldestMessageAge();

    @ManagedOperation(description="move messages from this queue to another", changesConfiguredObjectState=false)
    public List<Long> moveMessages(@Param(name="destination", description="The queue to which the messages should be moved") Queue<?> var1, @Param(name="messageIds", description="If provided, only messages in the queue whose (internal) message-id is supplied will be considered for moving") List<Long> var2, @Param(name="selector", description="A (JMS) selector - if provided, only messages which match the selector will be considered for moving") String var3, @Param(name="limit", description="Maximum number of messages to move", defaultValue="-1") int var4);

    @ManagedOperation(description="copies messages from this queue to another", changesConfiguredObjectState=false)
    public List<Long> copyMessages(@Param(name="destination", description="The queue to which the messages should be copied") Queue<?> var1, @Param(name="messageIds", description="If provided, only messages in the queue whose (internal) message-id is supplied will be considered for copying") List<Long> var2, @Param(name="selector", description="A (JMS) selector - if provided, only messages which match the selector will be considered for copying") String var3, @Param(name="limit", description="Maximum number of messages to copy", defaultValue="-1") int var4);

    @ManagedOperation(description="removes messages from this queue", changesConfiguredObjectState=false)
    public List<Long> deleteMessages(@Param(name="messageIds", description="If provided, only messages in the queue whose (internal) message-id is supplied will be considered for deletion") List<Long> var1, @Param(name="selector", description="A (JMS) selector - if provided, only messages which match the selector will be considered for deletion") String var2, @Param(name="limit", description="Maximum number of messages to delete", defaultValue="-1") int var3);

    @ManagedOperation(description="removes all messages from this queue", changesConfiguredObjectState=false)
    public long clearQueue();

    @ManagedOperation(nonModifying=true, secure=true, changesConfiguredObjectState=false, description="Gets the message content")
    public Content getMessageContent(@Param(name="messageId") long var1, @Param(name="limit", defaultValue="-1", description="Number of bytes to return") long var3, @Param(name="returnJson", defaultValue="false", description="If true, converts message content into JSON format. If false, returned bytes may be in an encoded form") boolean var5, @Param(name="decompressBeforeLimiting", defaultValue="false", description="If true, the operation will attempt to decompress the message(should it be compressed) before applying any limit. Ifdecompression fails the operation will fail.") boolean var6);

    @ManagedOperation(description="get information about a range of messages", nonModifying=true, paramRequiringSecure="includeHeaders", changesConfiguredObjectState=false)
    public List<MessageInfo> getMessageInfo(@Param(name="first", defaultValue="-1") int var1, @Param(name="last", defaultValue="-1") int var2, @Param(name="includeHeaders", defaultValue="false") boolean var3);

    @ManagedOperation(description="get information about the message with the given Id", nonModifying=true, paramRequiringSecure="includeHeaders", changesConfiguredObjectState=false)
    public MessageInfo getMessageInfoById(@Param(name="messageId") long var1, @Param(name="includeHeaders", defaultValue="true") boolean var3);

    public boolean isExclusive();

    public void addBinding(Binding<?> var1);

    public void removeBinding(Binding<?> var1);

    public LogSubject getLogSubject();

    public VirtualHost<?> getVirtualHost();

    public boolean isUnused();

    public boolean isEmpty();

    public long getOldestMessageArrivalTime();

    public void requeue(QueueEntry var1);

    public void dequeue(QueueEntry var1);

    public void decrementUnackedMsgCount(QueueEntry var1);

    public void incrementUnackedMsgCount(QueueEntry var1);

    public boolean resend(QueueEntry var1, QueueConsumer<?> var2);

    public List<? extends QueueEntry> getMessagesOnTheQueue();

    public List<Long> getMessagesOnTheQueue(int var1);

    public List<Long> getMessagesOnTheQueue(int var1, int var2);

    public QueueEntry getMessageOnTheQueue(long var1);

    public List<? extends QueueEntry> getMessagesRangeOnTheQueue(long var1, long var3);

    public void checkMessageStatus();

    public Set<NotificationCheck> getNotificationChecks();

    public void deliverAsync();

    public Collection<String> getAvailableAttributes();

    public void completeRecovery();

    public void recover(ServerMessage<?> var1, MessageEnqueueRecord var2);

    public void setTargetSize(long var1);

    public long getPotentialMemoryFootprint();

    public boolean isHeld(QueueEntry var1, long var2);
}

