/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.DerivedAttribute;
import org.apache.qpid.server.model.KeyStore;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.ManagedContextDependency;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.model.TrustStore;

@ManagedContextDependency(value={"qpid.security.tls.protocolWhiteList", "qpid.security.tls.cipherSuiteBlackList"})
@ManagedObject(description="<p>The Broker supports configuration of Ports to specify the particular AMQP messaging and HTTP management connectivity it offers for use.</p><p>Each Port is configured with the particular Protocols and Transports it supports, as well as the Authentication Provider to be used to authenticate connections. Where SSL is in use, the Port configuration also defines which Keystore to use and (where supported) which TrustStore(s) and whether Client Certificates should be requested/required.</p>")
public interface Port<X extends Port<X>>
extends ConfiguredObject<X> {
    public static final String CLASS_DESCRIPTION = "<p>The Broker supports configuration of Ports to specify the particular AMQP messaging and HTTP management connectivity it offers for use.</p><p>Each Port is configured with the particular Protocols and Transports it supports, as well as the Authentication Provider to be used to authenticate connections. Where SSL is in use, the Port configuration also defines which Keystore to use and (where supported) which TrustStore(s) and whether Client Certificates should be requested/required.</p>";
    public static final String BINDING_ADDRESS = "bindingAddress";
    public static final String PORT = "port";
    public static final String PROTOCOLS = "protocols";
    public static final String TRANSPORTS = "transports";
    public static final String TCP_NO_DELAY = "tcpNoDelay";
    public static final String NEED_CLIENT_AUTH = "needClientAuth";
    public static final String WANT_CLIENT_AUTH = "wantClientAuth";
    public static final String AUTHENTICATION_PROVIDER = "authenticationProvider";
    public static final String KEY_STORE = "keyStore";
    public static final String TRUST_STORES = "trustStores";
    public static final String CONNECTION_MAXIMUM_AUTHENTICATION_DELAY = "connection.maximumAuthenticationDelay";
    @ManagedContextDefault(name="connection.maximumAuthenticationDelay")
    public static final long DEFAULT_MAX_CONNECTION_AUTHENTICATION_DELAY = 10000L;

    @ManagedAttribute(mandatory=true)
    public int getPort();

    @ManagedAttribute
    public Set<Protocol> getProtocols();

    @ManagedAttribute(defaultValue="TCP")
    public Set<Transport> getTransports();

    @ManagedAttribute
    public KeyStore getKeyStore();

    @ManagedAttribute
    public Collection<TrustStore> getTrustStores();

    @DerivedAttribute
    public List<String> getTlsProtocolWhiteList();

    @DerivedAttribute
    public List<String> getTlsProtocolBlackList();

    @DerivedAttribute
    public List<String> getTlsCipherSuiteWhiteList();

    @DerivedAttribute
    public List<String> getTlsCipherSuiteBlackList();

    public Collection<Connection> getConnections();

    public void start();

    public ListenableFuture<Void> startAsync();
}

