/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.Map;
import org.apache.qpid.server.exchange.ExchangeReferrer;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.model.Binding;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedStatistic;
import org.apache.qpid.server.model.Publisher;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.StatisticType;
import org.apache.qpid.server.model.StatisticUnit;

@ManagedObject(description="<p>An Exchange is a named entity within the Virtualhost which receives messages from producers and routes them to matching Queues within the Virtualhost.</p><p>The server provides a set of exchange types with each exchange type implementing a different routing algorithm.</p>")
public interface Exchange<X extends Exchange<X>>
extends ConfiguredObject<X>,
MessageDestination,
ExchangeReferrer {
    public static final String CLASS_DESCRIPTION = "<p>An Exchange is a named entity within the Virtualhost which receives messages from producers and routes them to matching Queues within the Virtualhost.</p><p>The server provides a set of exchange types with each exchange type implementing a different routing algorithm.</p>";
    public static final String ALTERNATE_EXCHANGE = "alternateExchange";

    @ManagedAttribute
    public Exchange<?> getAlternateExchange();

    @ManagedAttribute(description="(AMQP 1.0 only) Default behaviour to apply when a message is not routed to any queues", defaultValue="DISCARD")
    public UnroutableMessageBehaviour getUnroutableMessageBehaviour();

    public Collection<? extends Binding> getBindings();

    public Collection<Publisher> getPublishers();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.COUNT, label="Bindings")
    public long getBindingCount();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.BYTES, label="Dropped")
    public long getBytesDropped();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.BYTES, label="Inbound")
    public long getBytesIn();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.MESSAGES, label="Dropped")
    public long getMessagesDropped();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.MESSAGES, label="Inbound")
    public long getMessagesIn();

    public Binding createBinding(String var1, Queue var2, Map<String, Object> var3, Map<String, Object> var4);

    public boolean isAutoDelete();

    public boolean addBinding(String var1, Queue<?> var2, Map<String, Object> var3);

    public boolean deleteBinding(String var1, Queue<?> var2);

    public boolean hasBinding(String var1, Queue<?> var2);

    public boolean replaceBinding(String var1, Queue<?> var2, Map<String, Object> var3);

    public boolean isBound(String var1, Map<String, Object> var2, Queue<?> var3);

    public boolean isBound(String var1, Queue<?> var2);

    public boolean isBound(String var1);

    public boolean hasBindings();

    public boolean isBound(Queue<?> var1);

    public boolean isBound(Map<String, Object> var1);

    public boolean isBound(String var1, Map<String, Object> var2);

    public boolean isBound(Map<String, Object> var1, Queue<?> var2);

    public void removeReference(ExchangeReferrer var1);

    public void addReference(ExchangeReferrer var1);

    public boolean hasReferrers();

    public ListenableFuture<Void> removeBindingAsync(Binding<?> var1);

    public EventLogger getEventLogger();

    public void addBinding(Binding<?> var1);

    public static enum UnroutableMessageBehaviour {
        REJECT,
        DISCARD;

    }
}

