/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import org.apache.qpid.server.consumer.ConsumerImpl;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedStatistic;
import org.apache.qpid.server.model.StatisticType;
import org.apache.qpid.server.model.StatisticUnit;

@ManagedObject
public interface Consumer<X extends Consumer<X>>
extends ConfiguredObject<X>,
ConsumerImpl {
    public static final String DISTRIBUTION_MODE = "distributionMode";
    public static final String EXCLUSIVE = "exclusive";
    public static final String NO_LOCAL = "noLocal";
    public static final String SELECTOR = "selector";
    public static final String SETTLEMENT_MODE = "settlementMode";
    public static final String PRIORITY = "priority";
    public static final String SUSPEND_NOTIFICATION_PERIOD = "consumer.suspendNotificationPeriod";
    @ManagedContextDefault(name="consumer.suspendNotificationPeriod")
    public static final long SUSPEND_NOTIFICATION_PERIOD_DEFAULT = 10000L;

    @ManagedAttribute
    public String getDistributionMode();

    @ManagedAttribute
    public String getSettlementMode();

    @ManagedAttribute
    public boolean isExclusive();

    @ManagedAttribute
    public boolean isNoLocal();

    @ManagedAttribute
    public String getSelector();

    @ManagedAttribute(defaultValue="2147483647", description="Number representing the priority of the consumer versus other consumers.  Priority 2147483647 is the highest priority.")
    public int getPriority();

    @Override
    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.BYTES, label="Outbound")
    public long getBytesOut();

    @Override
    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.MESSAGES, label="Outbound")
    public long getMessagesOut();

    @Override
    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.BYTES, label="Prefetch")
    public long getUnacknowledgedBytes();

    @Override
    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.MESSAGES, label="Prefetch")
    public long getUnacknowledgedMessages();
}

