/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.util.Collection;
import java.util.Date;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.DerivedAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedStatistic;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.Session;
import org.apache.qpid.server.model.StatisticType;
import org.apache.qpid.server.model.StatisticUnit;
import org.apache.qpid.server.model.Transport;

@ManagedObject(creatable=false)
public interface Connection<X extends Connection<X>>
extends ConfiguredObject<X> {
    public static final String STATE = "state";
    public static final String CLIENT_ID = "clientId";
    public static final String CLIENT_VERSION = "clientVersion";
    public static final String INCOMING = "incoming";
    public static final String LOCAL_ADDRESS = "localAddress";
    public static final String PRINCIPAL = "principal";
    public static final String PROPERTIES = "properties";
    public static final String REMOTE_ADDRESS = "remoteAddress";
    public static final String REMOTE_PROCESS_NAME = "remoteProcessName";
    public static final String REMOTE_PROCESS_PID = "remoteProcessPid";
    public static final String SESSION_COUNT_LIMIT = "sessionCountLimit";
    public static final String TRANSPORT = "transport";
    public static final String PORT = "port";
    public static final String MAX_UNCOMMITTED_IN_MEMORY_SIZE = "connection.maxUncommittedInMemorySize";
    @ManagedContextDefault(name="connection.maxUncommittedInMemorySize")
    public static final long DEFAULT_MAX_UNCOMMITTED_IN_MEMORY_SIZE = 0xA00000L;
    public static final String MAX_MESSAGE_SIZE = "qpid.max_message_size";
    @ManagedContextDefault(name="qpid.max_message_size")
    public static final int DEFAULT_MAX_MESSAGE_SIZE = 0x6400000;

    @DerivedAttribute
    public String getClientId();

    @DerivedAttribute
    public String getClientVersion();

    @DerivedAttribute
    public String getClientProduct();

    @DerivedAttribute
    public boolean isIncoming();

    @DerivedAttribute
    public String getLocalAddress();

    @DerivedAttribute
    public String getPrincipal();

    @DerivedAttribute
    public String getRemoteAddress();

    @DerivedAttribute
    public String getRemoteProcessName();

    @DerivedAttribute
    public String getRemoteProcessPid();

    @DerivedAttribute
    public long getSessionCountLimit();

    @DerivedAttribute
    public Transport getTransport();

    @DerivedAttribute
    public String getTransportInfo();

    @DerivedAttribute
    public Protocol getProtocol();

    @DerivedAttribute
    public NamedAddressSpace getAddressSpace();

    @DerivedAttribute
    public Port<?> getPort();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.BYTES, label="Inbound")
    public long getBytesIn();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.BYTES, label="Outbound")
    public long getBytesOut();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.MESSAGES, label="Inbound")
    public long getMessagesIn();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.MESSAGES, label="Outbound")
    public long getMessagesOut();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.ABSOLUTE_TIME, label="Last I/O time")
    public Date getLastIoTime();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.COUNT, label="Sessions")
    public int getSessionCount();

    public Collection<Session> getSessions();
}

