/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import org.apache.qpid.server.model.AttributeValueConverter;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectInjectedAttribute;
import org.apache.qpid.server.model.ConfiguredObjectInjectedAttributeOrStatistic;
import org.apache.qpid.server.model.ConfiguredSettableAttribute;
import org.apache.qpid.server.model.Initialization;
import org.apache.qpid.server.model.InjectedAttributeStatisticOrOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfiguredSettableInjectedAttribute<C extends ConfiguredObject, T>
extends ConfiguredObjectInjectedAttributeOrStatistic<C, T>
implements ConfiguredSettableAttribute<C, T>,
ConfiguredObjectInjectedAttribute<C, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfiguredSettableInjectedAttribute.class);
    private final AttributeValueConverter<T> _converter;
    private final Method _validValuesMethod;
    private final Pattern _secureValuePattern;
    private final String _defaultValue;
    private final boolean _secure;
    private final boolean _persisted;
    private final boolean _immutable;
    private final boolean _oversized;
    private final String _oversizedAltText;
    private final String _description;
    private final String[] _validValues;
    private final String _validValuePattern;
    private Initialization _initialization;

    public ConfiguredSettableInjectedAttribute(String name, Class<T> type, Type genericType, String defaultValue, boolean secure, boolean persisted, boolean immutable, String secureValueFilter, boolean oversized, String oversizedAltText, String description, String[] validValues, String validValuePattern, InjectedAttributeStatisticOrOperation.TypeValidator typeValidator, Initialization initialization) {
        super(name, type, genericType, typeValidator);
        this._converter = AttributeValueConverter.getConverter(type, genericType);
        this._defaultValue = defaultValue;
        this._secure = secure;
        this._persisted = persisted;
        this._immutable = immutable;
        this._oversized = oversized;
        this._oversizedAltText = oversizedAltText;
        this._description = description;
        this._validValues = validValues;
        this._validValuePattern = validValuePattern;
        this._initialization = initialization;
        Method validValuesMethod = null;
        if (this._validValues != null && this._validValues.length == 1) {
            String validValue = this._validValues[0];
            validValuesMethod = this.getValidValuesMethod(validValue);
        }
        this._validValuesMethod = validValuesMethod;
        this._secureValuePattern = secureValueFilter == null || "".equals(secureValueFilter) ? null : Pattern.compile(secureValueFilter);
    }

    @Override
    public final AttributeValueConverter<T> getConverter() {
        return this._converter;
    }

    private Method getValidValuesMethod(String validValue) {
        if (validValue.matches("([\\w][\\w\\d_]+\\.)+[\\w][\\w\\d_\\$]*#[\\w\\d_]+\\s*\\(\\s*\\)")) {
            try {
                Type parameterizedType;
                String className = validValue.split("#")[0].trim();
                String methodName = validValue.split("#")[1].split("\\(")[0].trim();
                Class<?> validValueCalculatingClass = Class.forName(className);
                Method method = validValueCalculatingClass.getMethod(methodName, new Class[0]);
                if (Modifier.isStatic(method.getModifiers()) && Modifier.isPublic(method.getModifiers()) && Collection.class.isAssignableFrom(method.getReturnType()) && method.getGenericReturnType() instanceof ParameterizedType && (parameterizedType = ((ParameterizedType)method.getGenericReturnType()).getActualTypeArguments()[0]) == String.class) {
                    return method;
                }
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                LOGGER.warn("The validValues of the " + this.getName() + " has value '" + validValue + "' which looks like it should be a method," + " but no such method could be used.", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public boolean isAutomated() {
        return false;
    }

    @Override
    public boolean isDerived() {
        return false;
    }

    @Override
    public String defaultValue() {
        return this._defaultValue;
    }

    @Override
    public Initialization getInitialization() {
        return this._initialization;
    }

    @Override
    public boolean isSecure() {
        return this._secure;
    }

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public boolean isImmutable() {
        return this._immutable;
    }

    @Override
    public boolean isPersisted() {
        return this._persisted;
    }

    @Override
    public boolean isOversized() {
        return this._oversized;
    }

    @Override
    public boolean updateAttributeDespiteUnchangedValue() {
        return false;
    }

    @Override
    public String getOversizedAltText() {
        return this._oversizedAltText;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public Pattern getSecureValueFilter() {
        return this._secureValuePattern;
    }

    @Override
    public boolean isSecureValue(Object value) {
        Pattern filter;
        return this.isSecure() && ((filter = this.getSecureValueFilter()) == null || filter.matcher(String.valueOf(value)).matches());
    }

    @Override
    public Collection<String> validValues() {
        if (this._validValuesMethod != null) {
            try {
                return (Collection)this._validValuesMethod.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOGGER.warn("Could not execute the validValues generation method " + this._validValuesMethod.getName(), (Throwable)e);
                return Collections.emptySet();
            }
        }
        if ((this._validValues == null || this._validValues.length == 0) && this.getType().isEnum()) {
            Enum[] constants = (Enum[])this.getType().getEnumConstants();
            ArrayList<String> validValues = new ArrayList<String>(constants.length);
            for (Enum constant : constants) {
                validValues.add(constant.name());
            }
            return validValues;
        }
        return this._validValues == null ? Collections.emptySet() : Arrays.asList(this._validValues);
    }

    @Override
    public boolean hasValidValues() {
        return this.validValues() != null && this.validValues().size() > 0;
    }

    @Override
    public final T getValue(C configuredObject) {
        Object value = configuredObject.getActualAttributes().get(this.getName());
        if (value == null) {
            value = this.defaultValue();
        }
        return this.convert(value, configuredObject);
    }

    @Override
    public final T convert(Object value, C object) {
        AttributeValueConverter<T> converter = this.getConverter();
        try {
            return converter.convert(value, (ConfiguredObject)object);
        }
        catch (IllegalArgumentException iae) {
            Type returnType = this.getGenericType();
            String simpleName = returnType instanceof Class ? ((Class)returnType).getSimpleName() : returnType.toString();
            throw new IllegalArgumentException("Cannot convert '" + value + "' into a " + simpleName + " for attribute " + this.getName() + " (" + iae.getMessage() + ")", iae);
        }
    }

    @Override
    public String validValuePattern() {
        return this._validValuePattern;
    }
}

