/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ManagedAttributeValue;
import org.apache.qpid.server.model.preferences.GenericPrincipal;
import org.apache.qpid.server.security.QpidPrincipal;
import org.apache.qpid.server.util.ServerScopedRuntimeException;

public class ConfiguredObjectJacksonModule
extends SimpleModule {
    private static final ConfiguredObjectJacksonModule INSTANCE = new ConfiguredObjectJacksonModule();
    private static final Set<String> OBJECT_METHOD_NAMES = Collections.synchronizedSet(new HashSet());

    private ConfiguredObjectJacksonModule() {
        super("ConfiguredObjectSerializer", new Version(1, 0, 0, null, "org.apache.qpid", "broker-core"));
        this.addConfiguredObjectSerializer();
        this.addManageableAttributeTypeSerializer();
        this.addCertificateSerializer();
        this.addPrincipalSerializer();
    }

    private void addPrincipalSerializer() {
        JsonSerializer<Principal> serializer = new JsonSerializer<Principal>(){

            public void serialize(Principal value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
                if (value == null) {
                    jgen.writeNull();
                } else if (value instanceof QpidPrincipal) {
                    jgen.writeString(new GenericPrincipal((QpidPrincipal)value).toExternalForm());
                } else if (value instanceof GenericPrincipal) {
                    jgen.writeString(((GenericPrincipal)value).toExternalForm());
                } else {
                    jgen.writeString(value.getName());
                }
            }
        };
        this.addSerializer(Principal.class, (JsonSerializer)serializer);
    }

    private void addCertificateSerializer() {
        JsonSerializer<Certificate> serializer = new JsonSerializer<Certificate>(){

            public void serialize(Certificate value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                try {
                    jgen.writeBinary(value.getEncoded());
                }
                catch (CertificateEncodingException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        };
        this.addSerializer(Certificate.class, (JsonSerializer)serializer);
    }

    private void addManageableAttributeTypeSerializer() {
        JsonSerializer<ManagedAttributeValue> serializer = new JsonSerializer<ManagedAttributeValue>(){

            public void serialize(ManagedAttributeValue value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                LinkedHashMap<String, Object> valueAsMap = new LinkedHashMap<String, Object>();
                for (Method method : value.getClass().getMethods()) {
                    String methodName = method.getName();
                    if (method.getParameterTypes().length != 0 || OBJECT_METHOD_NAMES.contains(methodName) || !methodName.startsWith("is") && !methodName.startsWith("has") && !methodName.startsWith("get")) continue;
                    String propertyName = methodName.startsWith("is") ? methodName.substring(2) : methodName.substring(3);
                    propertyName = Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1);
                    try {
                        Object attrValue = method.invoke((Object)value, new Object[0]);
                        if (attrValue == null) continue;
                        valueAsMap.put(propertyName, attrValue);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new ServerScopedRuntimeException(e);
                    }
                }
                jgen.writeObject(valueAsMap);
            }
        };
        this.addSerializer(ManagedAttributeValue.class, (JsonSerializer)serializer);
    }

    private void addConfiguredObjectSerializer() {
        JsonSerializer<ConfiguredObject> serializer = new JsonSerializer<ConfiguredObject>(){

            public void serialize(ConfiguredObject value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                jgen.writeString(value.getId().toString());
            }
        };
        this.addSerializer(ConfiguredObject.class, (JsonSerializer)serializer);
    }

    public static ObjectMapper newObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)INSTANCE);
        return objectMapper;
    }

    static {
        for (Method method : Object.class.getMethods()) {
            OBJECT_METHOD_NAMES.add(method.getName());
        }
    }
}

