/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.util.Comparator;
import org.apache.qpid.server.security.AccessControl;

public interface CommonAccessControlProvider<X>
extends Comparable<X> {
    public static final String PRIORITY = "priority";
    public static final Comparator<? super CommonAccessControlProvider> ACCESS_CONTROL_PROVIDER_COMPARATOR = new Comparator<CommonAccessControlProvider>(){

        @Override
        public int compare(CommonAccessControlProvider o1, CommonAccessControlProvider o2) {
            if (o1.getPriority() < o2.getPriority()) {
                return -1;
            }
            if (o1.getPriority() > o2.getPriority()) {
                return 1;
            }
            return o1.getName().compareTo(o2.getName());
        }
    };

    public String getName();

    public int getPriority();

    public AccessControl getAccessControl();
}

