/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.model.AccessControlProvider;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Binding;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.BrokerLogInclusionRule;
import org.apache.qpid.server.model.BrokerLogger;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectFactory;
import org.apache.qpid.server.model.ConfiguredObjectFactoryImpl;
import org.apache.qpid.server.model.ConfiguredObjectTypeRegistry;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.Consumer;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.Group;
import org.apache.qpid.server.model.GroupMember;
import org.apache.qpid.server.model.GroupProvider;
import org.apache.qpid.server.model.KeyStore;
import org.apache.qpid.server.model.Model;
import org.apache.qpid.server.model.Plugin;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.Publisher;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.RemoteReplicationNode;
import org.apache.qpid.server.model.Session;
import org.apache.qpid.server.model.SystemConfig;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.model.User;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.VirtualHostAccessControlProvider;
import org.apache.qpid.server.model.VirtualHostAlias;
import org.apache.qpid.server.model.VirtualHostLogInclusionRule;
import org.apache.qpid.server.model.VirtualHostLogger;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.plugin.ConfiguredObjectAttributeInjector;
import org.apache.qpid.server.plugin.ConfiguredObjectRegistration;
import org.apache.qpid.server.plugin.QpidServiceLoader;

public final class BrokerModel
extends Model {
    public static final int MODEL_MAJOR_VERSION = 6;
    public static final int MODEL_MINOR_VERSION = 1;
    public static final String MODEL_VERSION = "6.1";
    private static final Model MODEL_INSTANCE = new BrokerModel();
    private final Map<Class<? extends ConfiguredObject>, Collection<Class<? extends ConfiguredObject>>> _parents = new HashMap<Class<? extends ConfiguredObject>, Collection<Class<? extends ConfiguredObject>>>();
    private final Map<Class<? extends ConfiguredObject>, Collection<Class<? extends ConfiguredObject>>> _children = new HashMap<Class<? extends ConfiguredObject>, Collection<Class<? extends ConfiguredObject>>>();
    private final Set<Class<? extends ConfiguredObject>> _supportedTypes = new HashSet<Class<? extends ConfiguredObject>>();
    private final ConfiguredObjectTypeRegistry _typeRegistry;
    private Class<? extends ConfiguredObject> _rootCategory;
    private final ConfiguredObjectFactory _objectFactory;

    private BrokerModel() {
        this.setRootCategory(SystemConfig.class);
        this.addRelationship(SystemConfig.class, Broker.class);
        this.addRelationship(Broker.class, BrokerLogger.class);
        this.addRelationship(Broker.class, VirtualHostNode.class);
        this.addRelationship(Broker.class, TrustStore.class);
        this.addRelationship(Broker.class, KeyStore.class);
        this.addRelationship(Broker.class, Port.class);
        this.addRelationship(Broker.class, AccessControlProvider.class);
        this.addRelationship(Broker.class, AuthenticationProvider.class);
        this.addRelationship(Broker.class, GroupProvider.class);
        this.addRelationship(Broker.class, Plugin.class);
        this.addRelationship(BrokerLogger.class, BrokerLogInclusionRule.class);
        this.addRelationship(VirtualHostNode.class, VirtualHost.class);
        this.addRelationship(VirtualHostNode.class, RemoteReplicationNode.class);
        this.addRelationship(VirtualHost.class, VirtualHostLogger.class);
        this.addRelationship(VirtualHost.class, VirtualHostAccessControlProvider.class);
        this.addRelationship(VirtualHost.class, Exchange.class);
        this.addRelationship(VirtualHost.class, Queue.class);
        this.addRelationship(VirtualHostLogger.class, VirtualHostLogInclusionRule.class);
        this.addRelationship(Port.class, VirtualHostAlias.class);
        this.addRelationship(Port.class, Connection.class);
        this.addRelationship(AuthenticationProvider.class, User.class);
        this.addRelationship(GroupProvider.class, Group.class);
        this.addRelationship(Group.class, GroupMember.class);
        this.addRelationship(Connection.class, Session.class);
        this.addRelationship(Queue.class, Binding.class);
        this.addRelationship(Queue.class, Consumer.class);
        this.addRelationship(Exchange.class, Binding.class);
        this.addRelationship(Exchange.class, Publisher.class);
        this.addRelationship(Session.class, Consumer.class);
        this.addRelationship(Session.class, Publisher.class);
        this._objectFactory = new ConfiguredObjectFactoryImpl(this);
        this._typeRegistry = new ConfiguredObjectTypeRegistry(new QpidServiceLoader().instancesOf(ConfiguredObjectRegistration.class), new QpidServiceLoader().instancesOf(ConfiguredObjectAttributeInjector.class), this.getSupportedCategories(), this._objectFactory);
    }

    @Override
    public final ConfiguredObjectTypeRegistry getTypeRegistry() {
        return this._typeRegistry;
    }

    public static Model getInstance() {
        return MODEL_INSTANCE;
    }

    @Override
    public Class<? extends ConfiguredObject> getRootCategory() {
        return this._rootCategory;
    }

    @Override
    public Collection<Class<? extends ConfiguredObject>> getParentTypes(Class<? extends ConfiguredObject> child) {
        Collection<Class<? extends ConfiguredObject>> parentTypes = this._parents.get(child);
        return parentTypes == null ? Collections.emptyList() : Collections.unmodifiableCollection(parentTypes);
    }

    @Override
    public int getMajorVersion() {
        return 6;
    }

    @Override
    public int getMinorVersion() {
        return 1;
    }

    @Override
    public ConfiguredObjectFactory getObjectFactory() {
        return this._objectFactory;
    }

    @Override
    public Collection<Class<? extends ConfiguredObject>> getChildTypes(Class<? extends ConfiguredObject> parent) {
        Collection<Class<? extends ConfiguredObject>> childTypes = this._children.get(parent);
        return childTypes == null ? Collections.emptyList() : Collections.unmodifiableCollection(childTypes);
    }

    @Override
    public Collection<Class<? extends ConfiguredObject>> getSupportedCategories() {
        return Collections.unmodifiableSet(this._supportedTypes);
    }

    public void setRootCategory(Class<? extends ConfiguredObject> rootCategory) {
        this._rootCategory = rootCategory;
    }

    private void addRelationship(Class<? extends ConfiguredObject> parent, Class<? extends ConfiguredObject> child) {
        Collection<Class<? extends ConfiguredObject>> parents = this._parents.get(child);
        if (parents == null) {
            parents = new ArrayList<Class<? extends ConfiguredObject>>();
            this._parents.put(child, parents);
        }
        parents.add(parent);
        Collection<Class<? extends ConfiguredObject>> children = this._children.get(parent);
        if (children == null) {
            children = new ArrayList<Class<? extends ConfiguredObject>>();
            this._children.put(parent, children);
        }
        children.add(child);
        this._supportedTypes.add(parent);
        this._supportedTypes.add(child);
    }
}

