/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.configuration.updater.Task;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.BrokerImpl;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.SystemConfig;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.util.FixedKeyMapCreator;

final class BrokerImplWithAccessChecking
extends BrokerImpl {
    private static final FixedKeyMapCreator EXTRACT_CONFIG_MAP_CREATOR = new FixedKeyMapCreator("includeSecureAttributes");
    private static final FixedKeyMapCreator GET_THREAD_STACK_TRACES_MAP_CREATOR = new FixedKeyMapCreator("appendToLog");
    private static final FixedKeyMapCreator FIND_THREAD_STACK_TRACES_MAP_CREATOR = new FixedKeyMapCreator("threadNameFindExpression");
    private static final FixedKeyMapCreator PURGE_USER_MAP_CREATOR = new FixedKeyMapCreator("origin", "username");

    BrokerImplWithAccessChecking(Map<String, Object> attributes, SystemConfig systemconfig) {
        super(attributes, systemconfig);
    }

    @Override
    public void initiateShutdown() {
        this.authorise(Operation.METHOD("initiateShutdown"));
        super.initiateShutdown();
    }

    @Override
    public Map<String, Object> extractConfig(boolean includeSecureAttributes) {
        this.authorise(Operation.METHOD("extractConfig"), EXTRACT_CONFIG_MAP_CREATOR.createMap(includeSecureAttributes));
        return super.extractConfig(includeSecureAttributes);
    }

    @Override
    public void performGC() {
        this.authorise(Operation.METHOD("performGC"));
        super.performGC();
    }

    @Override
    public Content getThreadStackTraces(boolean appendToLog) {
        this.authorise(Operation.METHOD("getThreadStackTraces"), GET_THREAD_STACK_TRACES_MAP_CREATOR.createMap(appendToLog));
        return super.getThreadStackTraces(appendToLog);
    }

    @Override
    public Content findThreadStackTraces(String threadNameFindExpression) {
        this.authorise(Operation.METHOD("findThreadStackTraces"), FIND_THREAD_STACK_TRACES_MAP_CREATOR.createMap(threadNameFindExpression));
        return super.findThreadStackTraces(threadNameFindExpression);
    }

    @Override
    public Principal getUser() {
        this.authorise(Operation.METHOD("getUser"));
        return super.getUser();
    }

    @Override
    public Set<Principal> getGroups() {
        this.authorise(Operation.METHOD("getGroups"));
        return super.getGroups();
    }

    @Override
    public void purgeUser(final AuthenticationProvider<?> origin, final String username) {
        this.authorise(Operation.METHOD("purgeUser"), PURGE_USER_MAP_CREATOR.createMap(origin, username));
        this.doSync(this.doOnConfigThread(new Task<ListenableFuture<Void>, RuntimeException>(){
            private String _args;

            @Override
            public ListenableFuture<Void> execute() {
                BrokerImplWithAccessChecking.super.purgeUser(origin, username);
                return Futures.immediateFuture(null);
            }

            @Override
            public String getObject() {
                return BrokerImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "purgeUser";
            }

            @Override
            public String getArguments() {
                if (this._args == null) {
                    this._args = "origin=" + origin + "," + "username=" + username;
                }
                return this._args;
            }
        }));
    }

    @Override
    public void resetStatistics() {
        this.authorise(Operation.METHOD("resetStatistics"));
        super.resetStatistics();
    }
}

