/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.login.AccountNotFoundException;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.configuration.CommonProperties;
import org.apache.qpid.server.BrokerPrincipal;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.configuration.updater.TaskExecutor;
import org.apache.qpid.server.configuration.updater.TaskExecutorImpl;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.messages.BrokerMessages;
import org.apache.qpid.server.logging.messages.VirtualHostMessages;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.AbstractContainer;
import org.apache.qpid.server.model.AccessControlProvider;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.BrokerLogger;
import org.apache.qpid.server.model.CommonAccessControlProvider;
import org.apache.qpid.server.model.ConfigurationChangeListener;
import org.apache.qpid.server.model.ConfigurationExtractor;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Group;
import org.apache.qpid.server.model.GroupMember;
import org.apache.qpid.server.model.GroupProvider;
import org.apache.qpid.server.model.KeyStore;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.PasswordCredentialManagingAuthenticationProvider;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.model.SystemConfig;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.model.preferences.UserPreferences;
import org.apache.qpid.server.model.preferences.UserPreferencesImpl;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.plugin.SystemAddressSpaceCreator;
import org.apache.qpid.server.plugin.SystemNodeCreator;
import org.apache.qpid.server.security.AccessControl;
import org.apache.qpid.server.security.CompoundAccessControl;
import org.apache.qpid.server.security.Result;
import org.apache.qpid.server.security.SubjectFixedResultAccessControl;
import org.apache.qpid.server.security.auth.AuthenticatedPrincipal;
import org.apache.qpid.server.security.auth.UsernamePrincipal;
import org.apache.qpid.server.security.auth.manager.SimpleAuthenticationManager;
import org.apache.qpid.server.security.group.GroupPrincipal;
import org.apache.qpid.server.stats.StatisticsCounter;
import org.apache.qpid.server.stats.StatisticsGatherer;
import org.apache.qpid.server.store.FileBasedSettings;
import org.apache.qpid.server.store.preferences.PreferenceRecord;
import org.apache.qpid.server.store.preferences.PreferenceStore;
import org.apache.qpid.server.store.preferences.PreferenceStoreUpdaterImpl;
import org.apache.qpid.server.store.preferences.PreferencesRecoverer;
import org.apache.qpid.server.store.preferences.PreferencesRoot;
import org.apache.qpid.server.util.HousekeepingExecutor;
import org.apache.qpid.util.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(category=false, type="Broker")
public class BrokerImpl
extends AbstractContainer<BrokerImpl>
implements Broker<BrokerImpl> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BrokerImpl.class);
    private static final Pattern MODEL_VERSION_PATTERN = Pattern.compile("^\\d+\\.\\d+$");
    private static final int HOUSEKEEPING_SHUTDOWN_TIMEOUT = 5;
    public static final String MANAGEMENT_MODE_AUTHENTICATION = "MANAGEMENT_MODE_AUTHENTICATION";
    private final AccessControl _systemUserAllowed = new SubjectFixedResultAccessControl(new SubjectFixedResultAccessControl.ResultCalculator(){

        @Override
        public Result getResult(Subject subject) {
            return BrokerImpl.this.isSystemSubject(subject) ? Result.ALLOWED : Result.DEFER;
        }
    }, Result.DEFER);
    private final BrokerPrincipal _principal;
    private String[] POSITIVE_NUMERIC_ATTRIBUTES = new String[]{"connection.sessionCountLimit", "connection.heartBeatDelay", "statisticsReportingPeriod"};
    private AuthenticationProvider<?> _managementModeAuthenticationProvider;
    private Timer _reportingTimer;
    private final StatisticsCounter _messagesDelivered;
    private final StatisticsCounter _dataDelivered;
    private final StatisticsCounter _messagesReceived;
    private final StatisticsCounter _dataReceived;
    @ManagedAttributeField
    private int _connection_sessionCountLimit;
    @ManagedAttributeField
    private int _connection_heartBeatDelay;
    @ManagedAttributeField
    private boolean _connection_closeWhenNoRoute;
    @ManagedAttributeField
    private int _statisticsReportingPeriod;
    @ManagedAttributeField
    private boolean _statisticsReportingResetEnabled;
    @ManagedAttributeField
    private boolean _messageCompressionEnabled;
    private PreferenceStore _preferenceStore;
    private final boolean _virtualHostPropertiesNodeEnabled;
    private Collection<BrokerLogger> _brokerLoggersToClose;
    private int _networkBufferSize = 262144;
    private final AddressSpaceRegistry _addressSpaceRegistry = new AddressSpaceRegistry();
    private ConfigurationChangeListener _accessControlProviderListener = new AccessControlProviderListener();
    private final AccessControl _accessControl;
    private TaskExecutor _preferenceTaskExecutor;
    private String _documentationUrl;
    private long _flowToDiskThreshold;

    @ManagedObjectFactoryConstructor
    public BrokerImpl(Map<String, Object> attributes, SystemConfig parent) {
        super(BrokerImpl.parentsMap(parent), attributes, parent);
        this._principal = new BrokerPrincipal(this);
        if (parent.isManagementMode()) {
            HashMap<String, Object> authManagerAttrs = new HashMap<String, Object>();
            authManagerAttrs.put("name", MANAGEMENT_MODE_AUTHENTICATION);
            authManagerAttrs.put("id", UUID.randomUUID());
            SimpleAuthenticationManager authManager = new SimpleAuthenticationManager(authManagerAttrs, this);
            authManager.addUser("mm_admin", this._parent.getManagementModePassword());
            this._managementModeAuthenticationProvider = authManager;
            this._accessControl = AccessControl.ALWAYS_ALLOWED;
        } else {
            this._accessControl = new CompoundAccessControl(Collections.emptyList(), Result.ALLOWED);
        }
        QpidServiceLoader qpidServiceLoader = new QpidServiceLoader();
        Set<String> systemNodeCreatorTypes = qpidServiceLoader.getInstancesByType(SystemNodeCreator.class).keySet();
        this._virtualHostPropertiesNodeEnabled = systemNodeCreatorTypes.contains("VIRTUALHOSTPROPERTIES");
        this._messagesDelivered = new StatisticsCounter("messages-delivered");
        this._dataDelivered = new StatisticsCounter("bytes-delivered");
        this._messagesReceived = new StatisticsCounter("messages-received");
        this._dataReceived = new StatisticsCounter("bytes-received");
    }

    private void registerSystemAddressSpaces() {
        QpidServiceLoader qpidServiceLoader = new QpidServiceLoader();
        Iterable<SystemAddressSpaceCreator> factories = qpidServiceLoader.instancesOf(SystemAddressSpaceCreator.class);
        for (SystemAddressSpaceCreator creator : factories) {
            creator.register(this._addressSpaceRegistry);
        }
    }

    @Override
    protected void postResolve() {
        super.postResolve();
        Integer networkBufferSize = this.getContextValue(Integer.class, "qpid.broker.networkBufferSize");
        if (networkBufferSize == null || networkBufferSize < 65536) {
            throw new IllegalConfigurationException("qpid.broker.networkBufferSize is set to unacceptable value '" + networkBufferSize + "'. Must be larger than " + 65536 + ".");
        }
        this._networkBufferSize = networkBufferSize;
        int poolSize = this.getContextValue(Integer.class, "broker.directByteBufferPoolSize");
        QpidByteBuffer.initialisePool((int)this._networkBufferSize, (int)poolSize);
    }

    @Override
    protected void postResolveChildren() {
        super.postResolveChildren();
        SystemConfig parent = this.getParent(SystemConfig.class);
        Runnable task = parent.getOnContainerResolveTask();
        if (task != null) {
            task.run();
        }
        this.addChangeListener(this._accessControlProviderListener);
        for (AccessControlProvider aclProvider : this.getChildren(AccessControlProvider.class)) {
            aclProvider.addChangeListener(this._accessControlProviderListener);
        }
        this._eventLogger.message(BrokerMessages.CONFIG(parent instanceof FileBasedSettings ? ((FileBasedSettings)((Object)parent)).getStorePath() : "N/A"));
    }

    @Override
    public void onValidate() {
        super.onValidate();
        String modelVersion = (String)this.getActualAttributes().get("modelVersion");
        if (modelVersion == null) {
            this.deleted();
            throw new IllegalConfigurationException("Broker modelVersion must be specified");
        }
        if (!MODEL_VERSION_PATTERN.matcher(modelVersion).matches()) {
            this.deleted();
            throw new IllegalConfigurationException("Broker modelVersion is specified in incorrect format: " + modelVersion);
        }
        int versionSeparatorPosition = modelVersion.indexOf(".");
        String majorVersionPart = modelVersion.substring(0, versionSeparatorPosition);
        int majorModelVersion = Integer.parseInt(majorVersionPart);
        int minorModelVersion = Integer.parseInt(modelVersion.substring(versionSeparatorPosition + 1));
        if (majorModelVersion != 6 || minorModelVersion > 1) {
            this.deleted();
            throw new IllegalConfigurationException("The model version '" + modelVersion + "' in configuration is incompatible with the broker model version '" + "6.1" + "'");
        }
        if (!this.isDurable()) {
            this.deleted();
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " must be durable");
        }
    }

    @Override
    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        Broker updated = (Broker)proxyForValidation;
        if (changedAttributes.contains("modelVersion") && !"6.1".equals(updated.getModelVersion())) {
            throw new IllegalConfigurationException("Cannot change the model version");
        }
        for (String attributeName : this.POSITIVE_NUMERIC_ATTRIBUTES) {
            Number value;
            if (!changedAttributes.contains(attributeName) || (value = (Number)updated.getAttribute(attributeName)) == null || value.longValue() >= 0L) continue;
            throw new IllegalConfigurationException("Only positive integer value can be specified for the attribute " + attributeName);
        }
    }

    @Override
    protected void validateChildDelete(ConfiguredObject<?> child) {
        super.validateChildDelete(child);
        if (child instanceof AccessControlProvider && this.getChildren(AccessControlProvider.class).size() == 1) {
            String categoryName = child.getCategoryClass().getSimpleName();
            throw new IllegalConfigurationException("The " + categoryName + " named '" + child.getName() + "' cannot be deleted as at least one " + categoryName + " must be present");
        }
    }

    @StateTransition(currentState={State.UNINITIALIZED}, desiredState=State.ACTIVE)
    private ListenableFuture<Void> activate() {
        if (this._parent.isManagementMode()) {
            return this.doAfter(this._managementModeAuthenticationProvider.openAsync(), new Runnable(){

                @Override
                public void run() {
                    BrokerImpl.this.performActivation();
                }
            });
        }
        this.performActivation();
        return Futures.immediateFuture(null);
    }

    @StateTransition(currentState={State.ACTIVE, State.ERRORED}, desiredState=State.STOPPED)
    private ListenableFuture<Void> doStop() {
        this.stopPreferenceTaskExecutor();
        this.closePreferenceStore();
        return Futures.immediateFuture(null);
    }

    private void closePreferenceStore() {
        PreferenceStore ps = this._preferenceStore;
        if (ps != null) {
            ps.close();
        }
    }

    private void stopPreferenceTaskExecutor() {
        TaskExecutor preferenceTaskExecutor = this._preferenceTaskExecutor;
        if (preferenceTaskExecutor != null) {
            preferenceTaskExecutor.stop();
        }
    }

    @Override
    public void initiateShutdown() {
        this.getEventLogger().message(BrokerMessages.OPERATION("initiateShutdown"));
        this._parent.closeAsync();
    }

    @Override
    public Map<String, Object> extractConfig(boolean includeSecureAttributes) {
        return new ConfigurationExtractor().extractConfig(this, includeSecureAttributes);
    }

    private void performActivation() {
        boolean hasBrokerAnyErroredChildren = false;
        ArrayList<ConfiguredObject> failedChildren = new ArrayList<ConfiguredObject>();
        for (Class<? extends ConfiguredObject> childClass : this.getModel().getChildTypes(this.getCategoryClass())) {
            Collection<? extends ConfiguredObject> children = this.getChildren(childClass);
            if (children == null) continue;
            for (ConfiguredObject configuredObject : children) {
                if (configuredObject.getState() != State.ERRORED) continue;
                hasBrokerAnyErroredChildren = true;
                LOGGER.warn("Broker child object '{}' of type '{}' is {}", new Object[]{configuredObject.getName(), childClass.getSimpleName(), State.ERRORED});
                failedChildren.add(configuredObject);
            }
        }
        if (!failedChildren.isEmpty()) {
            this.getEventLogger().message(BrokerMessages.FAILED_CHILDREN(((Object)failedChildren).toString()));
        }
        this._documentationUrl = this.getContextValue(String.class, "qpid.helpURL");
        boolean brokerShutdownOnErroredChild = this.getContextValue(Boolean.class, "broker.failStartupWithErroredChild");
        if (!this._parent.isManagementMode() && brokerShutdownOnErroredChild && hasBrokerAnyErroredChildren) {
            throw new IllegalStateException(String.format("Broker context variable %s is set and the broker has %s children", new Object[]{"broker.failStartupWithErroredChild", State.ERRORED}));
        }
        this.updateAccessControl();
        this.initialiseStatisticsReporting();
        this._houseKeepingTaskExecutor = new HousekeepingExecutor("broker-" + this.getName() + "-pool", this.getHousekeepingThreadCount(), this.getSystemTaskSubject("Housekeeping", this._principal));
        PreferenceStoreUpdaterImpl updater = new PreferenceStoreUpdaterImpl();
        Collection<PreferenceRecord> preferenceRecords = this._preferenceStore.openAndLoad(updater);
        this._preferenceTaskExecutor = new TaskExecutorImpl("broker-" + this.getName() + "-preferences", null);
        this._preferenceTaskExecutor.start();
        PreferencesRecoverer preferencesRecoverer = new PreferencesRecoverer(this._preferenceTaskExecutor);
        preferencesRecoverer.recoverPreferences(this, preferenceRecords, this._preferenceStore);
        if (this.isManagementMode()) {
            this._eventLogger.message(BrokerMessages.MANAGEMENT_MODE("mm_admin", this._parent.getManagementModePassword()));
        }
        this.setState(State.ACTIVE);
    }

    private void initialiseStatisticsReporting() {
        long report = ((Number)this.getAttribute("statisticsReportingPeriod")).intValue() * 1000;
        boolean reset = (Boolean)this.getAttribute("statisticsReportingResetEnabled");
        if (report > 0L) {
            this._reportingTimer = new Timer("Statistics-Reporting", true);
            StatisticsReportingTask task = new StatisticsReportingTask(reset, this._eventLogger);
            this._reportingTimer.scheduleAtFixedRate((TimerTask)task, report / 2L, report);
        }
    }

    @Override
    public int getConnection_sessionCountLimit() {
        return this._connection_sessionCountLimit;
    }

    @Override
    public int getConnection_heartBeatDelay() {
        return this._connection_heartBeatDelay;
    }

    @Override
    public boolean getConnection_closeWhenNoRoute() {
        return this._connection_closeWhenNoRoute;
    }

    @Override
    public int getStatisticsReportingPeriod() {
        return this._statisticsReportingPeriod;
    }

    @Override
    public boolean getStatisticsReportingResetEnabled() {
        return this._statisticsReportingResetEnabled;
    }

    @Override
    public boolean isMessageCompressionEnabled() {
        return this._messageCompressionEnabled;
    }

    @Override
    public Collection<VirtualHostNode<?>> getVirtualHostNodes() {
        Collection<VirtualHostNode<?>> children = this.getChildren(VirtualHostNode.class);
        return children;
    }

    @Override
    public Collection<Port<?>> getPorts() {
        Collection<Port<?>> children = this.getChildren(Port.class);
        return children;
    }

    @Override
    public Collection<AuthenticationProvider<?>> getAuthenticationProviders() {
        Collection<AuthenticationProvider<?>> children = this.getChildren(AuthenticationProvider.class);
        return children;
    }

    @Override
    public synchronized void assignTargetSizes() {
        LOGGER.debug("Assigning target sizes based on total target {}", (Object)this._flowToDiskThreshold);
        long totalSize = 0L;
        Collection<VirtualHostNode<?>> vhns = this.getVirtualHostNodes();
        HashMap vhs = new HashMap();
        for (VirtualHostNode<?> vhn : vhns) {
            VirtualHost<?> vh = vhn.getVirtualHost();
            if (vh == null) continue;
            long totalQueueDepthBytes = vh.getTotalQueueDepthBytes();
            vhs.put(vh, totalQueueDepthBytes);
            totalSize += totalQueueDepthBytes;
        }
        long proportionalShare = (long)((double)this._flowToDiskThreshold / (double)vhs.size());
        for (Map.Entry entry : vhs.entrySet()) {
            long size;
            long virtualHostTotalQueueSize = (Long)entry.getValue();
            if (totalSize == 0L) {
                size = proportionalShare;
            } else {
                double fraction = (double)virtualHostTotalQueueSize / (double)totalSize;
                double queueSizeBasedShare = (double)this._flowToDiskThreshold / 2.0 * fraction;
                size = (long)(queueSizeBasedShare + (double)proportionalShare / 2.0);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Assigning target size {} to vhost {}", (Object)size, entry.getKey());
            }
            ((VirtualHost)entry.getKey()).setTargetSize(size);
        }
    }

    @Override
    protected void onOpen() {
        super.onOpen();
        PreferencesRoot preferencesRoot = this.getParent(SystemConfig.class);
        this._preferenceStore = preferencesRoot.createPreferenceStore();
        this.getEventLogger().message(BrokerMessages.STARTUP(CommonProperties.getReleaseVersion(), CommonProperties.getBuildVersion()));
        this.getEventLogger().message(BrokerMessages.PLATFORM(System.getProperty("java.vendor"), System.getProperty("java.runtime.version", System.getProperty("java.version")), SystemUtils.getOSName(), SystemUtils.getOSVersion(), SystemUtils.getOSArch(), String.valueOf(this.getNumberOfCores())));
        long directMemory = BrokerImpl.getMaxDirectMemorySize();
        long heapMemory = Runtime.getRuntime().maxMemory();
        this.getEventLogger().message(BrokerMessages.MAX_MEMORY(heapMemory, directMemory));
        this._flowToDiskThreshold = this.getContextValue(Long.class, "broker.flowToDiskThreshold");
        if (SystemUtils.getProcessPid() != null) {
            this.getEventLogger().message(BrokerMessages.PROCESS(SystemUtils.getProcessPid()));
        }
        this.registerSystemAddressSpaces();
        this.assignTargetSizes();
    }

    @Override
    public NamedAddressSpace getSystemAddressSpace(String name) {
        return this._addressSpaceRegistry.getAddressSpace(name);
    }

    @Override
    public Collection<GroupProvider<?>> getGroupProviders() {
        Collection<GroupProvider<?>> children = this.getChildren(GroupProvider.class);
        return children;
    }

    private ListenableFuture<VirtualHostNode> createVirtualHostNodeAsync(Map<String, Object> attributes) throws AccessControlException, IllegalArgumentException {
        return this.doAfter(this.getObjectFactory().createAsync(VirtualHostNode.class, attributes, this), new AbstractConfiguredObject.CallableWithArgument<ListenableFuture<VirtualHostNode>, VirtualHostNode>(){

            @Override
            public ListenableFuture<VirtualHostNode> call(final VirtualHostNode virtualHostNode) throws Exception {
                Subject.doAs(BrokerImpl.this.getSubjectWithAddedSystemRights(), new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        virtualHostNode.start();
                        return null;
                    }
                });
                return Futures.immediateFuture((Object)virtualHostNode);
            }
        });
    }

    @Override
    public long getBytesIn() {
        return this.getDataReceiptStatistics().getTotal();
    }

    @Override
    public long getBytesOut() {
        return this.getDataDeliveryStatistics().getTotal();
    }

    @Override
    public long getMessagesIn() {
        return this.getMessageReceiptStatistics().getTotal();
    }

    @Override
    public long getMessagesOut() {
        return this.getMessageDeliveryStatistics().getTotal();
    }

    @Override
    public <C extends ConfiguredObject> ListenableFuture<C> addChildAsync(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
        if (childClass == VirtualHostNode.class) {
            return this.createVirtualHostNodeAsync(attributes);
        }
        return this.getObjectFactory().createAsync(childClass, attributes, this);
    }

    @Override
    protected ListenableFuture<Void> beforeClose() {
        this._brokerLoggersToClose = new ArrayList<BrokerLogger>(this.getChildren(BrokerLogger.class));
        return super.beforeClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onClose() {
        if (this._reportingTimer != null) {
            this._reportingTimer.cancel();
        }
        this.shutdownHouseKeeping();
        this.stopPreferenceTaskExecutor();
        this.closePreferenceStore();
        this._eventLogger.message(BrokerMessages.STOPPED());
        try {
            for (BrokerLogger logger : this._brokerLoggersToClose) {
                logger.stopLogging();
            }
        }
        finally {
            Runnable task = this._parent.getOnContainerCloseTask();
            if (task != null) {
                task.run();
            }
        }
    }

    @Override
    public UserPreferences createUserPreferences(ConfiguredObject<?> object) {
        return new UserPreferencesImpl(this._preferenceTaskExecutor, object, this._preferenceStore, Collections.emptySet());
    }

    private void updateAccessControl() {
        if (!this.isManagementMode()) {
            ArrayList<AccessControlProvider> children = new ArrayList<AccessControlProvider>(this.getChildren(AccessControlProvider.class));
            Collections.sort(children, CommonAccessControlProvider.ACCESS_CONTROL_PROVIDER_COMPARATOR);
            ArrayList accessControls = new ArrayList(children.size() + 1);
            accessControls.add(this._systemUserAllowed);
            for (AccessControlProvider prov : children) {
                if (prov.getState() == State.ERRORED) {
                    accessControls.clear();
                    accessControls.add(AccessControl.ALWAYS_DENIED);
                    break;
                }
                if (prov.getState() != State.ACTIVE) continue;
                accessControls.add(prov.getAccessControl());
            }
            ((CompoundAccessControl)this._accessControl).setAccessControls(accessControls);
        }
    }

    @Override
    public AccessControl getAccessControl() {
        return this._accessControl;
    }

    @Override
    public VirtualHost<?> findVirtualHostByName(String name) {
        for (VirtualHostNode virtualHostNode : this.getChildren(VirtualHostNode.class)) {
            VirtualHost<?> virtualHost = virtualHostNode.getVirtualHost();
            if (virtualHost == null || !virtualHost.getName().equals(name)) continue;
            return virtualHost;
        }
        return null;
    }

    @Override
    public VirtualHostNode findDefautVirtualHostNode() {
        VirtualHostNode existingDefault = null;
        ArrayList virtualHostNodes = new ArrayList(this.getVirtualHostNodes());
        for (VirtualHostNode virtualHostNode : virtualHostNodes) {
            if (!virtualHostNode.isDefaultVirtualHostNode()) continue;
            existingDefault = virtualHostNode;
            break;
        }
        return existingDefault;
    }

    @Override
    public Collection<KeyStore<?>> getKeyStores() {
        Collection<KeyStore<?>> children = this.getChildren(KeyStore.class);
        return children;
    }

    @Override
    public Collection<TrustStore<?>> getTrustStores() {
        Collection<TrustStore<?>> children = this.getChildren(TrustStore.class);
        return children;
    }

    @Override
    public boolean isManagementMode() {
        return this._parent.isManagementMode();
    }

    @Override
    public Collection<AccessControlProvider<?>> getAccessControlProviders() {
        Collection<AccessControlProvider<?>> children = this.getChildren(AccessControlProvider.class);
        return children;
    }

    @Override
    protected void onExceptionInOpen(RuntimeException e) {
        this._eventLogger.message(BrokerMessages.FATAL_ERROR(e.getMessage()));
    }

    @Override
    public void registerMessageDelivered(long messageSize) {
        this._messagesDelivered.registerEvent(1L);
        this._dataDelivered.registerEvent(messageSize);
    }

    @Override
    public void registerMessageReceived(long messageSize, long timestamp) {
        this._messagesReceived.registerEvent(1L, timestamp);
        this._dataReceived.registerEvent(messageSize, timestamp);
    }

    @Override
    public long getFlowToDiskThreshold() {
        return this._flowToDiskThreshold;
    }

    @Override
    public StatisticsCounter getMessageReceiptStatistics() {
        return this._messagesReceived;
    }

    @Override
    public StatisticsCounter getDataReceiptStatistics() {
        return this._dataReceived;
    }

    @Override
    public StatisticsCounter getMessageDeliveryStatistics() {
        return this._messagesDelivered;
    }

    @Override
    public StatisticsCounter getDataDeliveryStatistics() {
        return this._dataDelivered;
    }

    @Override
    public void resetStatistics() {
        this._messagesDelivered.reset();
        this._dataDelivered.reset();
        this._messagesReceived.reset();
        this._dataReceived.reset();
        for (VirtualHostNode virtualHostNode : this.getChildren(VirtualHostNode.class)) {
            VirtualHost<?> virtualHost = virtualHostNode.getVirtualHost();
            if (!(virtualHost instanceof StatisticsGatherer)) continue;
            ((StatisticsGatherer)((Object)virtualHost)).resetStatistics();
        }
    }

    @Override
    public boolean isVirtualHostPropertiesNodeEnabled() {
        return this._virtualHostPropertiesNodeEnabled;
    }

    @Override
    public AuthenticationProvider<?> getManagementModeAuthenticationProvider() {
        return this._managementModeAuthenticationProvider;
    }

    @Override
    public int getNetworkBufferSize() {
        return this._networkBufferSize;
    }

    @Override
    public String getDocumentationUrl() {
        return this._documentationUrl;
    }

    @Override
    public Principal getUser() {
        return AuthenticatedPrincipal.getCurrentUser();
    }

    @Override
    public Set<Principal> getGroups() {
        Subject currentSubject = Subject.getSubject(AccessController.getContext());
        if (currentSubject == null) {
            return Collections.emptySet();
        }
        Set<Principal> currentPrincipals = Collections.unmodifiableSet(currentSubject.getPrincipals(GroupPrincipal.class));
        return currentPrincipals;
    }

    @Override
    public void purgeUser(AuthenticationProvider<?> origin, String username) {
        this.doPurgeUser(origin, username);
    }

    private void doPurgeUser(AuthenticationProvider<?> origin, String username) {
        if (origin instanceof PasswordCredentialManagingAuthenticationProvider) {
            try {
                ((PasswordCredentialManagingAuthenticationProvider)origin).deleteUser(username);
            }
            catch (AccountNotFoundException accountNotFoundException) {
                // empty catch block
            }
        }
        Collection<GroupProvider> groupProviders = this.getChildren(GroupProvider.class);
        for (GroupProvider groupProvider : groupProviders) {
            Collection<Group> groups = groupProvider.getChildren(Group.class);
            for (Group group : groups) {
                Collection<GroupMember> members = group.getChildren(GroupMember.class);
                for (GroupMember member : members) {
                    if (!username.equals(member.getName())) continue;
                    member.delete();
                }
            }
        }
        Subject userSubject = new Subject(true, Collections.singleton(new AuthenticatedPrincipal(new UsernamePrincipal(username, origin))), Collections.EMPTY_SET, Collections.EMPTY_SET);
        LinkedList<ConfiguredObject> configuredObjects = new LinkedList<ConfiguredObject>();
        configuredObjects.add(this);
        while (!configuredObjects.isEmpty()) {
            final ConfiguredObject currentObject = (ConfiguredObject)configuredObjects.poll();
            Collection<Class<? extends ConfiguredObject>> childClasses = this.getModel().getChildTypes(currentObject.getClass());
            for (Class<? extends ConfiguredObject> childClass : childClasses) {
                Collection<? extends ConfiguredObject> children = currentObject.getChildren(childClass);
                for (ConfiguredObject configuredObject : children) {
                    configuredObjects.add(configuredObject);
                }
            }
            Subject.doAs(userSubject, new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    currentObject.getUserPreferences().delete(null, null, null);
                    return null;
                }
            });
        }
    }

    protected void shutdownHouseKeeping() {
        if (this._houseKeepingTaskExecutor != null) {
            this._houseKeepingTaskExecutor.shutdown();
            try {
                if (!this._houseKeepingTaskExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this._houseKeepingTaskExecutor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                LOGGER.warn("Interrupted during Housekeeping shutdown:", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    private final class AccessControlProviderListener
    implements ConfigurationChangeListener {
        private final Set<ConfiguredObject<?>> _bulkChanges = new HashSet();

        private AccessControlProviderListener() {
        }

        @Override
        public void stateChanged(ConfiguredObject<?> object, State oldState, State newState) {
        }

        @Override
        public void childAdded(ConfiguredObject<?> object, ConfiguredObject<?> child) {
            if (object.getCategoryClass() == Broker.class && child.getCategoryClass() == AccessControlProvider.class) {
                child.addChangeListener(this);
                BrokerImpl.this.updateAccessControl();
            }
        }

        @Override
        public void childRemoved(ConfiguredObject<?> object, ConfiguredObject<?> child) {
            if (object.getCategoryClass() == Broker.class && child.getCategoryClass() == AccessControlProvider.class) {
                BrokerImpl.this.updateAccessControl();
            }
        }

        @Override
        public void attributeSet(ConfiguredObject<?> object, String attributeName, Object oldAttributeValue, Object newAttributeValue) {
            if (object.getCategoryClass() == AccessControlProvider.class && !this._bulkChanges.contains(object)) {
                BrokerImpl.this.updateAccessControl();
            }
        }

        @Override
        public void bulkChangeStart(ConfiguredObject<?> object) {
            if (object.getCategoryClass() == AccessControlProvider.class) {
                this._bulkChanges.add(object);
            }
        }

        @Override
        public void bulkChangeEnd(ConfiguredObject<?> object) {
            if (object.getCategoryClass() == AccessControlProvider.class) {
                this._bulkChanges.remove(object);
                BrokerImpl.this.updateAccessControl();
            }
        }
    }

    private class AddressSpaceRegistry
    implements SystemAddressSpaceCreator.AddressSpaceRegistry {
        private final ConcurrentMap<String, NamedAddressSpace> _systemAddressSpaces = new ConcurrentHashMap<String, NamedAddressSpace>();

        private AddressSpaceRegistry() {
        }

        @Override
        public void registerAddressSpace(NamedAddressSpace addressSpace) {
            this._systemAddressSpaces.put(addressSpace.getName(), addressSpace);
        }

        @Override
        public void removeAddressSpace(NamedAddressSpace addressSpace) {
            this._systemAddressSpaces.remove(addressSpace.getName(), addressSpace);
        }

        @Override
        public void removeAddressSpace(String name) {
            this._systemAddressSpaces.remove(name);
        }

        @Override
        public NamedAddressSpace getAddressSpace(String name) {
            return name == null ? null : (NamedAddressSpace)this._systemAddressSpaces.get(name);
        }

        @Override
        public Broker<?> getBroker() {
            return BrokerImpl.this;
        }
    }

    private class StatisticsReportingTask
    extends TimerTask {
        private final int DELIVERED = 0;
        private final int RECEIVED = 1;
        private final boolean _reset;
        private final EventLogger _logger;
        private final Subject _subject;

        public StatisticsReportingTask(boolean reset, EventLogger logger) {
            this._reset = reset;
            this._logger = logger;
            this._subject = BrokerImpl.this.getSystemTaskSubject("Statistics");
        }

        @Override
        public void run() {
            Subject.doAs(this._subject, new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    StatisticsReportingTask.this.reportStatistics();
                    return null;
                }
            });
        }

        protected void reportStatistics() {
            try {
                BrokerImpl.this._eventLogger.message(BrokerMessages.STATS_DATA(0, BrokerImpl.this._dataDelivered.getPeak() / 1024.0, BrokerImpl.this._dataDelivered.getTotal()));
                BrokerImpl.this._eventLogger.message(BrokerMessages.STATS_MSGS(0, BrokerImpl.this._messagesDelivered.getPeak(), BrokerImpl.this._messagesDelivered.getTotal()));
                BrokerImpl.this._eventLogger.message(BrokerMessages.STATS_DATA(1, BrokerImpl.this._dataReceived.getPeak() / 1024.0, BrokerImpl.this._dataReceived.getTotal()));
                BrokerImpl.this._eventLogger.message(BrokerMessages.STATS_MSGS(1, BrokerImpl.this._messagesReceived.getPeak(), BrokerImpl.this._messagesReceived.getTotal()));
                for (VirtualHostNode virtualHostNode : BrokerImpl.this.getChildren(VirtualHostNode.class)) {
                    VirtualHost<?> virtualHost = virtualHostNode.getVirtualHost();
                    if (!(virtualHost instanceof StatisticsGatherer)) continue;
                    StatisticsGatherer statGatherer = (StatisticsGatherer)((Object)virtualHost);
                    String name = virtualHost.getName();
                    StatisticsCounter dataDelivered = statGatherer.getDataDeliveryStatistics();
                    StatisticsCounter messagesDelivered = statGatherer.getMessageDeliveryStatistics();
                    StatisticsCounter dataReceived = statGatherer.getDataReceiptStatistics();
                    StatisticsCounter messagesReceived = statGatherer.getMessageReceiptStatistics();
                    EventLogger logger = virtualHost.getEventLogger();
                    logger.message(VirtualHostMessages.STATS_DATA(name, 0, dataDelivered.getPeak() / 1024.0, dataDelivered.getTotal()));
                    logger.message(VirtualHostMessages.STATS_MSGS(name, 0, messagesDelivered.getPeak(), messagesDelivered.getTotal()));
                    logger.message(VirtualHostMessages.STATS_DATA(name, 1, dataReceived.getPeak() / 1024.0, dataReceived.getTotal()));
                    logger.message(VirtualHostMessages.STATS_MSGS(name, 1, messagesReceived.getPeak(), messagesReceived.getTotal()));
                }
                if (this._reset) {
                    BrokerImpl.this.resetStatistics();
                }
            }
            catch (Exception e) {
                LOGGER.warn("Unexpected exception occurred while reporting the statistics", (Throwable)e);
            }
        }
    }
}

