/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.PlatformManagedObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.logging.messages.BrokerMessages;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredDerivedInjectedAttribute;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectInjectedAttribute;
import org.apache.qpid.server.model.ConfiguredObjectInjectedOperation;
import org.apache.qpid.server.model.ConfiguredObjectInjectedStatistic;
import org.apache.qpid.server.model.InjectedAttributeStatisticOrOperation;
import org.apache.qpid.server.model.OperationParameter;
import org.apache.qpid.server.model.OperationParameterFromInjection;
import org.apache.qpid.server.model.StatisticType;
import org.apache.qpid.server.model.StatisticUnit;
import org.apache.qpid.server.plugin.ConfiguredObjectAttributeInjector;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.util.ParameterizedTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluggableService
public class BrokerAttributeInjector
implements ConfiguredObjectAttributeInjector {
    private static final Logger LOGGER = LoggerFactory.getLogger(BrokerAttributeInjector.class);
    private final InjectedAttributeStatisticOrOperation.TypeValidator _typeValidator = new InjectedAttributeStatisticOrOperation.TypeValidator(){

        @Override
        public boolean appliesToType(Class<? extends ConfiguredObject<?>> type) {
            return Broker.class.isAssignableFrom(type);
        }
    };
    private final Class<?> _hotSpotDiagnosticMXBeanClass;
    private final PlatformManagedObject _hotSpotDiagnosticMXBean;

    public BrokerAttributeInjector() {
        Class<?> hotSpotDiagnosticMXBeanClass = null;
        Object hotSpotDiagnosticMXBean = null;
        try {
            ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
            hotSpotDiagnosticMXBeanClass = Class.forName("com.sun.management.HotSpotDiagnosticMXBean", true, systemClassLoader);
            hotSpotDiagnosticMXBean = ManagementFactory.getPlatformMXBean(hotSpotDiagnosticMXBeanClass);
        }
        catch (ClassNotFoundException e) {
            LOGGER.debug("Cannot find com.sun.management.HotSpotDiagnosticMXBean MXBean: " + e);
        }
        this._hotSpotDiagnosticMXBeanClass = hotSpotDiagnosticMXBeanClass;
        this._hotSpotDiagnosticMXBean = hotSpotDiagnosticMXBean;
    }

    @Override
    public Collection<ConfiguredObjectInjectedAttribute<?, ?>> getInjectedAttributes() {
        ArrayList attributes = new ArrayList();
        List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean memoryPoolMXBean : memoryPoolMXBeans) {
            String poolName = memoryPoolMXBean.getName().replace(" ", "");
            String attributeName = "jvmMemoryMaximum" + poolName;
            try {
                Method getMemoryPoolMaximum = BrokerAttributeInjector.class.getDeclaredMethod("getMemoryPoolMaximum", Broker.class, MemoryPoolMXBean.class);
                ConfiguredDerivedInjectedAttribute injectedStatistic = new ConfiguredDerivedInjectedAttribute(attributeName, getMemoryPoolMaximum, new Object[]{memoryPoolMXBean}, false, false, "", false, "", "Maximum size of memory pool " + memoryPoolMXBean.getName(), this._typeValidator);
                attributes.add(injectedStatistic);
            }
            catch (NoSuchMethodException e) {
                LOGGER.warn("Failed to inject attribute '{}'", (Object)attributeName, (Object)e);
            }
        }
        return attributes;
    }

    @Override
    public Collection<ConfiguredObjectInjectedStatistic<?, ?>> getInjectedStatistics() {
        ConfiguredObjectInjectedStatistic injectedStatistic;
        ArrayList statistics = new ArrayList();
        List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean memoryPoolMXBean : memoryPoolMXBeans) {
            String poolName = memoryPoolMXBean.getName().replace(" ", "");
            String statisticName = "jvmMemoryUsed" + poolName;
            try {
                Method getMemoryPoolUsed = BrokerAttributeInjector.class.getDeclaredMethod("getMemoryPoolUsed", Broker.class, MemoryPoolMXBean.class);
                injectedStatistic = new ConfiguredObjectInjectedStatistic(statisticName, getMemoryPoolUsed, new Object[]{memoryPoolMXBean}, "Usage of memory in pool " + memoryPoolMXBean.getName(), this._typeValidator, StatisticUnit.BYTES, StatisticType.POINT_IN_TIME, memoryPoolMXBean.getName() + " Memory Used");
                statistics.add(injectedStatistic);
            }
            catch (NoSuchMethodException e) {
                LOGGER.warn("Failed to inject statistic '{}'", (Object)statisticName, (Object)e);
            }
        }
        for (GarbageCollectorMXBean garbageCollectorMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            String gcName = garbageCollectorMXBean.getName().replace(" ", "");
            String jvmGCCollectionTimeStatisticName = "jvmGCCollectionTime" + gcName;
            try {
                Method getGCCollectionTime = BrokerAttributeInjector.class.getDeclaredMethod("getGCCollectionTime", Broker.class, GarbageCollectorMXBean.class);
                injectedStatistic = new ConfiguredObjectInjectedStatistic(jvmGCCollectionTimeStatisticName, getGCCollectionTime, new Object[]{garbageCollectorMXBean}, "Cumulative time in ms taken to perform collections for GC " + garbageCollectorMXBean.getName(), this._typeValidator, StatisticUnit.COUNT, StatisticType.CUMULATIVE, garbageCollectorMXBean.getName() + " GC Collection Time");
                statistics.add(injectedStatistic);
            }
            catch (NoSuchMethodException e) {
                LOGGER.warn("Failed to inject statistic '{}'", (Object)jvmGCCollectionTimeStatisticName, (Object)e);
            }
            String jvmGCCollectionCountStatisticName = "jvmGCCollectionCount" + gcName;
            try {
                Method getGCCollectionCount = BrokerAttributeInjector.class.getDeclaredMethod("getGCCollectionCount", Broker.class, GarbageCollectorMXBean.class);
                ConfiguredObjectInjectedStatistic injectedStatistic2 = new ConfiguredObjectInjectedStatistic(jvmGCCollectionCountStatisticName, getGCCollectionCount, new Object[]{garbageCollectorMXBean}, "Cumulative number of collections for GC " + garbageCollectorMXBean.getName(), this._typeValidator, StatisticUnit.COUNT, StatisticType.CUMULATIVE, garbageCollectorMXBean.getName() + " GC Collection Count");
                statistics.add(injectedStatistic2);
            }
            catch (NoSuchMethodException e) {
                LOGGER.warn("Failed to inject statistic '{}'", (Object)jvmGCCollectionCountStatisticName, (Object)e);
            }
        }
        return statistics;
    }

    @Override
    public Collection<ConfiguredObjectInjectedOperation<?>> getInjectedOperations() {
        ArrayList operations = new ArrayList();
        if (this._hotSpotDiagnosticMXBean != null) {
            try {
                operations.add(this.injectSetJVMOptions());
            }
            catch (NoSuchMethodException e) {
                LOGGER.warn("Failed to inject operation setJVMOptions", (Throwable)e);
            }
            try {
                operations.add(this.injectDumpHeap());
            }
            catch (NoSuchMethodException e) {
                LOGGER.warn("Failed to inject operation dumpHeap", (Throwable)e);
            }
        }
        return operations;
    }

    private ConfiguredObjectInjectedOperation<?> injectDumpHeap() throws NoSuchMethodException {
        Method heapDumpMethod = this._hotSpotDiagnosticMXBeanClass.getDeclaredMethod("dumpHeap", String.class, Boolean.TYPE);
        Method method = BrokerAttributeInjector.class.getDeclaredMethod("dumpHeap", Broker.class, PlatformManagedObject.class, Method.class, String.class, Boolean.TYPE);
        OperationParameter[] params = new OperationParameter[]{new OperationParameterFromInjection("outputFile", String.class, (Type)((Object)String.class), "", "the system-dependent filename", new String[0]), new OperationParameterFromInjection("live", Boolean.TYPE, Boolean.TYPE, "true", "if true dump only live objects i.e. objects that are reachable from others", new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()})};
        ConfiguredObjectInjectedOperation setVMOptionOperation = new ConfiguredObjectInjectedOperation("dumpHeap", "Dumps the heap to the outputFile file in the same format as the hprof heap dump.", true, false, "", params, method, new Object[]{this._hotSpotDiagnosticMXBean, heapDumpMethod}, this._typeValidator);
        return setVMOptionOperation;
    }

    private ConfiguredObjectInjectedOperation<?> injectSetJVMOptions() throws NoSuchMethodException {
        Method setVMOptionMethod = this._hotSpotDiagnosticMXBeanClass.getDeclaredMethod("setVMOption", String.class, String.class);
        Method method = BrokerAttributeInjector.class.getDeclaredMethod("setJVMOptions", Broker.class, PlatformManagedObject.class, Method.class, Map.class);
        OperationParameter[] params = new OperationParameter[]{new OperationParameterFromInjection("options", Map.class, ParameterizedTypes.MAP_OF_STRING_STRING, "", "JVM options map", new String[0])};
        ConfiguredObjectInjectedOperation setVMOptionOperation = new ConfiguredObjectInjectedOperation("setJVMOptions", "Sets given JVM options", true, false, "", params, method, new Object[]{this._hotSpotDiagnosticMXBean, setVMOptionMethod}, this._typeValidator);
        return setVMOptionOperation;
    }

    @Override
    public String getType() {
        return "Broker";
    }

    public static long getMemoryPoolUsed(Broker<?> broker, MemoryPoolMXBean memoryPoolMXBean) {
        return memoryPoolMXBean.getUsage().getUsed();
    }

    public static long getMemoryPoolMaximum(Broker<?> broker, MemoryPoolMXBean memoryPoolMXBean) {
        return memoryPoolMXBean.getUsage().getMax();
    }

    public static long getGCCollectionTime(Broker<?> broker, GarbageCollectorMXBean garbageCollectorMXBean) {
        return garbageCollectorMXBean.getCollectionTime();
    }

    public static long getGCCollectionCount(Broker<?> broker, GarbageCollectorMXBean garbageCollectorMXBean) {
        return garbageCollectorMXBean.getCollectionCount();
    }

    public static void setJVMOptions(Broker<?> broker, PlatformManagedObject hotSpotDiagnosticMXBean, Method setVMOption, Map<String, String> options) {
        broker.getEventLogger().message(BrokerMessages.OPERATION("setJVMOptions"));
        StringBuilder exceptionMessages = new StringBuilder();
        for (Map.Entry<String, String> entry : options.entrySet()) {
            try {
                setVMOption.invoke((Object)hotSpotDiagnosticMXBean, entry.getKey(), entry.getValue());
            }
            catch (IllegalAccessException e) {
                LOGGER.warn("Cannot access setVMOption " + setVMOption);
            }
            catch (InvocationTargetException e) {
                if (exceptionMessages.length() > 0) {
                    exceptionMessages.append(";");
                }
                exceptionMessages.append(e.getTargetException().toString());
                LOGGER.warn("Cannot set option {} to {} due to {}", new Object[]{entry.getKey(), entry.getValue(), e.getTargetException().toString()});
            }
            if (exceptionMessages.length() <= 0) continue;
            throw new IllegalConfigurationException("Exception(s) occurred whilst setting JVM options : " + exceptionMessages.toString());
        }
    }

    public static void dumpHeap(Broker<?> broker, PlatformManagedObject hotSpotDiagnosticMXBean, Method dumpHeapMethod, String outputFile, boolean live) {
        broker.getEventLogger().message(BrokerMessages.OPERATION("dumpHeap"));
        try {
            dumpHeapMethod.invoke((Object)hotSpotDiagnosticMXBean, outputFile, live);
        }
        catch (IllegalAccessException e) {
            LOGGER.warn("Cannot access dumpHeap " + dumpHeapMethod);
        }
        catch (InvocationTargetException e) {
            String causeAsString = e.getTargetException().toString();
            LOGGER.warn("Cannot collect heap dump into {} (with parameter 'live' set to '{}') due to {}", new Object[]{outputFile, live, causeAsString});
            throw new IllegalConfigurationException("Unexpected exception on collecting heap dump : " + causeAsString, e.getTargetException());
        }
    }
}

