/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.security.Principal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.model.AccessControlProvider;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.BrokerImpl;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Container;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.DerivedAttribute;
import org.apache.qpid.server.model.GroupProvider;
import org.apache.qpid.server.model.KeyStore;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedOperation;
import org.apache.qpid.server.model.ManagedStatistic;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.Param;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.StatisticType;
import org.apache.qpid.server.model.StatisticUnit;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.stats.StatisticsGatherer;
import org.apache.qpid.server.store.preferences.UserPreferencesCreator;

@ManagedObject(defaultType="Broker")
public interface Broker<X extends Broker<X>>
extends ConfiguredObject<X>,
EventLoggerProvider,
StatisticsGatherer,
Container<X>,
UserPreferencesCreator {
    public static final String BROKER_TYPE = "Broker";
    public static final String BUILD_VERSION = "buildVersion";
    public static final String OPERATING_SYSTEM = "operatingSystem";
    public static final String PLATFORM = "platform";
    public static final String PROCESS_PID = "processPid";
    public static final String PRODUCT_VERSION = "productVersion";
    public static final String STATISTICS_REPORTING_PERIOD = "statisticsReportingPeriod";
    public static final String STATISTICS_REPORTING_RESET_ENABLED = "statisticsReportingResetEnabled";
    public static final String STORE_PATH = "storePath";
    public static final String MODEL_VERSION = "modelVersion";
    public static final String PREFERENCE_STORE_ATTRIBUTES = "preferenceStoreAttributes";
    public static final String CHANNEL_FLOW_CONTROL_ENFORCEMENT_TIMEOUT = "channel.flowControlEnforcementTimeout";
    public static final String CONNECTION_SESSION_COUNT_LIMIT = "connection.sessionCountLimit";
    public static final String CONNECTION_HEART_BEAT_DELAY = "connection.heartBeatDelay";
    public static final String CONNECTION_CLOSE_WHEN_NO_ROUTE = "connection.closeWhenNoRoute";
    public static final String BROKER_FLOW_TO_DISK_THRESHOLD = "broker.flowToDiskThreshold";
    public static final String BROKER_FAIL_STARTUP_WITH_ERRORED_CHILD = "broker.failStartupWithErroredChild";
    public static final String BROKER_MSG_AUTH = "qpid.broker_msg_auth";
    public static final String STORE_FILESYSTEM_MAX_USAGE_PERCENT = "store.filesystem.maxUsagePercent";
    public static final String QPID_AMQP_PORT = "qpid.amqp_port";
    public static final String QPID_HTTP_PORT = "qpid.http_port";
    public static final String QPID_DOCUMENTATION_URL = "qpid.helpURL";
    public static final String NETWORK_BUFFER_SIZE = "qpid.broker.networkBufferSize";
    public static final int MINIMUM_NETWORK_BUFFER_SIZE = 65536;
    @ManagedContextDefault(name="qpid.broker.networkBufferSize")
    public static final int DEFAULT_NETWORK_BUFFER_SIZE = 262144;
    @ManagedContextDefault(name="broker.name")
    public static final String DEFAULT_BROKER_NAME = "Broker";
    @ManagedContextDefault(name="qpid.amqp_port")
    public static final String DEFAULT_AMQP_PORT_NUMBER = "5672";
    @ManagedContextDefault(name="qpid.http_port")
    public static final String DEFAULT_HTTP_PORT_NUMBER = "8080";
    @ManagedContextDefault(name="broker.flowToDiskThreshold")
    public static final long DEFAULT_FLOW_TO_DISK_THRESHOLD = (long)(0.4 * (double)BrokerImpl.getMaxDirectMemorySize());
    @ManagedContextDefault(name="channel.flowControlEnforcementTimeout")
    public static final long DEFAULT_CHANNEL_FLOW_CONTROL_ENFORCEMENT_TIMEOUT = 5000L;
    @ManagedContextDefault(name="store.filesystem.maxUsagePercent")
    public static final int DEFAULT_FILESYSTEM_MAX_USAGE_PERCENT = 90;
    @ManagedContextDefault(name="broker.failStartupWithErroredChild")
    public static final boolean DEFAULT_BROKER_FAIL_STARTUP_WITH_ERRORED_CHILD = false;
    @ManagedContextDefault(name="qpid.broker_msg_auth")
    public static final boolean DEFAULT_BROKER_MSG_AUTH = false;
    @ManagedContextDefault(name="qpid.security.tls.protocolWhiteList")
    public static final String DEFAULT_SECURITY_TLS_PROTOCOL_WHITE_LIST = "[\"TLSv1\\\\.[0-9]+\"]";
    @ManagedContextDefault(name="qpid.security.tls.protocolBlackList")
    public static final String DEFAULT_SECURITY_TLS_PROTOCOL_BLACK_LIST = "[\"TLSv1\\\\.0\"]";
    @ManagedContextDefault(name="qpid.security.tls.cipherSuiteWhiteList")
    public static final String DEFAULT_SECURITY_TLS_CIPHER_SUITE_WHITE_LIST = "[]";
    @ManagedContextDefault(name="qpid.security.tls.cipherSuiteBlackList")
    public static final String DEFAULT_SECURITY_TLS_CIPHER_SUITE_BLACK_LIST = "[]";
    @ManagedContextDefault(name="qpid.helpURL")
    public static final String DEFAULT_DOCUMENTATION_URL = "http://qpid.apache.org/releases/qpid-java-${qpid.version}/java-broker/book/";
    @ManagedContextDefault(name="broker.housekeepingThreadCount")
    public static final int DEFAULT_HOUSEKEEPING_THREAD_COUNT = 2;
    public static final String BROKER_MESSAGE_COMPRESSION_ENABLED = "broker.messageCompressionEnabled";
    @ManagedContextDefault(name="broker.messageCompressionEnabled")
    public static final boolean DEFAULT_MESSAGE_COMPRESSION_ENABLED = true;
    public static final String MESSAGE_COMPRESSION_THRESHOLD_SIZE = "connection.messageCompressionThresholdSize";
    @ManagedContextDefault(name="connection.messageCompressionThresholdSize")
    public static final int DEFAULT_MESSAGE_COMPRESSION_THRESHOLD_SIZE = 102400;
    public static final String SEND_QUEUE_DELETE_OK_REGARDLESS_CLIENT_VER_REGEXP = "connection.sendQueueDeleteOkRegardlessClientVerRegexp";
    @ManagedContextDefault(name="connection.sendQueueDeleteOkRegardlessClientVerRegexp")
    public static final String DEFAULT_SEND_QUEUE_DELETE_OK_REGARDLESS_CLIENT_VER_REGEXP = "^0\\..*$";
    public static final String BROKER_DIRECT_BYTE_BUFFER_POOL_SIZE = "broker.directByteBufferPoolSize";
    @ManagedContextDefault(name="broker.directByteBufferPoolSize")
    public static final int DEFAULT_BROKER_DIRECT_BYTE_BUFFER_POOL_SIZE = 1024;

    @DerivedAttribute
    public String getBuildVersion();

    @DerivedAttribute
    public String getOperatingSystem();

    @DerivedAttribute
    public String getPlatform();

    @DerivedAttribute
    public String getProcessPid();

    @DerivedAttribute
    public String getProductVersion();

    @DerivedAttribute
    public int getNumberOfCores();

    @ManagedAttribute(defaultValue="256")
    public int getConnection_sessionCountLimit();

    @ManagedAttribute(defaultValue="0", description="The default frequency with which Broker and client will exchange heartbeat messages (in seconds). Clients may negotiate a different heartbeat frequency or disable it altogether. A value of 0 disables heart beating.")
    public int getConnection_heartBeatDelay();

    @ManagedAttribute(defaultValue="true")
    public boolean getConnection_closeWhenNoRoute();

    @ManagedAttribute(defaultValue="0", description="Period (in seconds) of the statistic report.")
    public int getStatisticsReportingPeriod();

    @ManagedAttribute(defaultValue="false", description="If enabled, statistics are automatically reset to zero after each statistics report is made.")
    public boolean getStatisticsReportingResetEnabled();

    @ManagedAttribute(defaultValue="${broker.housekeepingThreadCount}")
    public int getHousekeepingThreadCount();

    @ManagedAttribute(defaultValue="${broker.messageCompressionEnabled}")
    public boolean isMessageCompressionEnabled();

    @ManagedAttribute(validValues={"org.apache.qpid.server.model.BrokerImpl#getAvailableConfigurationEncrypters()"})
    public String getConfidentialConfigurationEncryptionProvider();

    @DerivedAttribute(persist=true)
    public String getModelVersion();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.BYTES, label="Inbound")
    public long getBytesIn();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.BYTES, label="Outbound")
    public long getBytesOut();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.MESSAGES, label="Inbound")
    public long getMessagesIn();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.MESSAGES, label="Outbound")
    public long getMessagesOut();

    @ManagedOperation(nonModifying=true, description="Initiates an orderly shutdown of the Broker.", changesConfiguredObjectState=false)
    public void initiateShutdown();

    @ManagedOperation(nonModifying=true, description="Extract configuration", paramRequiringSecure="includeSecureAttributes", changesConfiguredObjectState=false)
    public Map<String, Object> extractConfig(@Param(name="includeSecureAttributes", description="include attributes that may contain passwords or other confidential information", defaultValue="false") boolean var1);

    @DerivedAttribute(description="Maximum heap memory size")
    public long getMaximumHeapMemorySize();

    @DerivedAttribute(description="Maximum direct memory size which can be consumed by broker")
    public long getMaximumDirectMemorySize();

    @DerivedAttribute(description="JVM arguments specified on startup")
    public List<String> getJvmArguments();

    @DerivedAttribute(description="URL to broker documentation")
    public String getDocumentationUrl();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.COUNT, label="Live threads", description="Number of live threads")
    public int getNumberOfLiveThreads();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.BYTES, label="Used Heap Memory Size", description="Size of used heap memory")
    public long getUsedHeapMemorySize();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.BYTES, label="Used Direct Memory Size", description="Size of used direct memory")
    public long getUsedDirectMemorySize();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.BYTES, label="Direct Memory Total Capacity", description="Total capacity of direct memory allocated for the Broker process")
    public long getDirectMemoryTotalCapacity();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.COUNT, label="Number Of Object Pending Finalization", description="Number of objects pending finalization")
    public int getNumberOfObjectsPendingFinalization();

    @ManagedOperation(nonModifying=true, description="Initiates garbage collection", changesConfiguredObjectState=false)
    public void performGC();

    @ManagedOperation(nonModifying=true, description="Collects thread stack traces and dead locks. Dumps stack traces into logs if requested", changesConfiguredObjectState=false)
    public Content getThreadStackTraces(@Param(name="appendToLog", defaultValue="false", description="If true, appends stack traces into logs") boolean var1);

    @ManagedOperation(nonModifying=true, description="Collects thread stack traces for the threads with names containing matching characters for given regular expression", changesConfiguredObjectState=false)
    public Content findThreadStackTraces(@Param(name="threadNameFindExpression", description="Regular expression to find threads with names containing matching characters") String var1);

    @ManagedOperation(nonModifying=true, description="Returns the principal of the currently authenticated user", changesConfiguredObjectState=false)
    public Principal getUser();

    @ManagedOperation(nonModifying=true, description="Returns the groups to which the currently authenticated user belongs", changesConfiguredObjectState=false)
    public Set<Principal> getGroups();

    @ManagedOperation(description="Removes a user and all associated preferences from the broker's configuration", changesConfiguredObjectState=true)
    public void purgeUser(@Param(name="origin", description="The AuthenticationProvider the username is associated with") AuthenticationProvider<?> var1, @Param(name="username", description="The unqualified username that should be purged from the broker") String var2);

    @Override
    @ManagedOperation(description="Resets statistics on this object and all child objects", changesConfiguredObjectState=false, nonModifying=true)
    public void resetStatistics();

    public Collection<VirtualHostNode<?>> getVirtualHostNodes();

    public Collection<Port<?>> getPorts();

    public Collection<AuthenticationProvider<?>> getAuthenticationProviders();

    public Collection<AccessControlProvider<?>> getAccessControlProviders();

    public NamedAddressSpace getSystemAddressSpace(String var1);

    public Collection<GroupProvider<?>> getGroupProviders();

    public VirtualHost<?> findVirtualHostByName(String var1);

    public VirtualHostNode findDefautVirtualHostNode();

    public Collection<KeyStore<?>> getKeyStores();

    public Collection<TrustStore<?>> getTrustStores();

    public boolean isManagementMode();

    @Override
    public EventLogger getEventLogger();

    @Override
    public void setEventLogger(EventLogger var1);

    public boolean isVirtualHostPropertiesNodeEnabled();

    @Override
    public AuthenticationProvider<?> getManagementModeAuthenticationProvider();

    public void assignTargetSizes();

    @Override
    public int getNetworkBufferSize();

    public ScheduledFuture<?> scheduleHouseKeepingTask(long var1, TimeUnit var3, Runnable var4);

    public ScheduledFuture<?> scheduleTask(long var1, TimeUnit var3, Runnable var4);

    @DerivedAttribute(description="Threshold direct memory size (in bytes) at which the Broker will start flowing incoming messages to disk.")
    public long getFlowToDiskThreshold();
}

