/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.security.auth.Subject;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.configuration.store.ManagementModeStoreHandler;
import org.apache.qpid.server.configuration.updater.TaskExecutor;
import org.apache.qpid.server.logging.CompositeStartupMessageLogger;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.MessageLogger;
import org.apache.qpid.server.logging.SystemOutMessageLogger;
import org.apache.qpid.server.logging.messages.BrokerMessages;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Container;
import org.apache.qpid.server.model.ContainerType;
import org.apache.qpid.server.model.DynamicModel;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.model.SystemConfig;
import org.apache.qpid.server.model.SystemConfigBootstrapModel;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.store.ConfiguredObjectRecord;
import org.apache.qpid.server.store.ConfiguredObjectRecordConverter;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.handler.ConfiguredObjectRecordHandler;
import org.apache.qpid.server.store.preferences.PreferenceStore;
import org.apache.qpid.server.store.preferences.PreferenceStoreAttributes;
import org.apache.qpid.server.store.preferences.PreferenceStoreFactoryService;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSystemConfig<X extends SystemConfig<X>>
extends AbstractConfiguredObject<X>
implements SystemConfig<X>,
DynamicModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSystemConfig.class);
    private static final UUID SYSTEM_ID = new UUID(0L, 0L);
    private static final long SHUTDOWN_TIMEOUT = 30000L;
    private final Principal _systemPrincipal;
    private final EventLogger _eventLogger;
    private volatile DurableConfigurationStore _configurationStore;
    private Runnable _onContainerResolveTask;
    private Runnable _onContainerCloseTask;
    @ManagedAttributeField
    private boolean _managementMode;
    @ManagedAttributeField
    private int _managementModeHttpPortOverride;
    @ManagedAttributeField
    private boolean _managementModeQuiesceVirtualHosts;
    @ManagedAttributeField
    private String _managementModePassword;
    @ManagedAttributeField
    private String _initialConfigurationLocation;
    @ManagedAttributeField
    private boolean _startupLoggedToSystemOut;
    @ManagedAttributeField
    private PreferenceStoreAttributes _preferenceStoreAttributes;
    @ManagedAttributeField
    private String _defaultContainerType;
    private final Thread _shutdownHook = new Thread((Runnable)new ShutdownService(), "QpidBrokerShutdownHook");

    public AbstractSystemConfig(TaskExecutor taskExecutor, EventLogger eventLogger, Principal systemPrincipal, Map<String, Object> attributes) {
        super(AbstractSystemConfig.parentsMap(new ConfiguredObject[0]), AbstractSystemConfig.updateAttributes(attributes), taskExecutor, SystemConfigBootstrapModel.getInstance());
        this._eventLogger = eventLogger;
        this._systemPrincipal = systemPrincipal;
        this.getTaskExecutor().start();
    }

    private static Map<String, Object> updateAttributes(Map<String, Object> attributes) {
        attributes = new HashMap<String, Object>(attributes);
        attributes.put("name", "System");
        attributes.put("id", SYSTEM_ID);
        return attributes;
    }

    @Override
    protected void setState(State desiredState) {
        throw new IllegalArgumentException("Cannot change the state of the SystemContext object");
    }

    @Override
    public EventLogger getEventLogger() {
        return this._eventLogger;
    }

    @Override
    protected ListenableFuture<Void> beforeClose() {
        try {
            boolean removed = Runtime.getRuntime().removeShutdownHook(this._shutdownHook);
            LOGGER.debug("Removed shutdown hook : {}", (Object)removed);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return super.beforeClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onClose() {
        TaskExecutor taskExecutor = this.getTaskExecutor();
        try {
            if (taskExecutor != null) {
                taskExecutor.stop();
            }
            if (this._configurationStore != null) {
                this._configurationStore.closeConfigurationStore();
            }
        }
        finally {
            if (taskExecutor != null) {
                taskExecutor.stopImmediately();
            }
        }
    }

    @Override
    public <C extends ConfiguredObject<C>> C getChild(Class<C> childClass) {
        Collection<C> children = this.getChildren(childClass);
        if (children == null || children.isEmpty()) {
            return null;
        }
        if (children.size() != 1) {
            throw new IllegalConfigurationException("More than one broker has been registered in a single context");
        }
        return (C)((ConfiguredObject)children.iterator().next());
    }

    @Override
    protected void onOpen() {
        super.onOpen();
        Runtime.getRuntime().addShutdownHook(this._shutdownHook);
        LOGGER.debug("Added shutdown hook");
        this._configurationStore = this.createStoreObject();
        if (this.isManagementMode()) {
            this._configurationStore = new ManagementModeStoreHandler(this._configurationStore, this);
        }
        this._configurationStore.init(this);
        this._configurationStore.upgradeStoreStructure();
    }

    @StateTransition(currentState={State.UNINITIALIZED}, desiredState=State.ACTIVE)
    protected ListenableFuture<Void> activate() {
        final EventLogger eventLogger = this._eventLogger;
        final EventLogger startupLogger = this.initiateStartupLogging();
        try {
            final Container<?> container = this.initateStoreAndRecovery();
            container.setEventLogger(startupLogger);
            final SettableFuture returnVal = SettableFuture.create();
            AbstractSystemConfig.addFutureCallback(container.openAsync(), new FutureCallback(){

                public void onSuccess(Object result) {
                    State state = container.getState();
                    if (state == State.ACTIVE) {
                        startupLogger.message(BrokerMessages.READY());
                        container.setEventLogger(eventLogger);
                        returnVal.set(null);
                    } else {
                        returnVal.setException((Throwable)new ServerScopedRuntimeException("Broker failed reach ACTIVE state (state is " + (Object)((Object)state) + ")"));
                    }
                }

                public void onFailure(Throwable t) {
                    returnVal.setException(t);
                }
            }, this.getTaskExecutor());
            return returnVal;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Container<?> initateStoreAndRecovery() throws IOException {
        QpidServiceLoader loader;
        ContainerType containerType;
        ConfiguredObjectRecord[] initialRecords = this.convertToConfigurationRecords(this.getInitialConfigurationLocation());
        DurableConfigurationStore store = this.getConfigurationStore();
        final ArrayList<ConfiguredObjectRecord> records = new ArrayList<ConfiguredObjectRecord>();
        boolean isNew = store.openConfigurationStore(new ConfiguredObjectRecordHandler(){

            @Override
            public void handle(ConfiguredObjectRecord record) {
                records.add(record);
            }
        }, initialRecords);
        String containerTypeName = this.getDefaultContainerType();
        for (ConfiguredObjectRecord record : records) {
            if (record.getParents() == null || record.getParents().size() != 1 || !this.getId().equals(record.getParents().get(SystemConfig.class.getSimpleName()))) continue;
            containerTypeName = record.getType();
            break;
        }
        if ((containerType = (loader = new QpidServiceLoader()).getInstancesByType(ContainerType.class).get(containerTypeName)) == null) {
            throw new IllegalConfigurationException("Unknown container type '" + containerTypeName + "'");
        }
        this.updateModel(containerType.getModel());
        containerType.getRecoverer(this).upgradeAndRecover(records);
        Class categoryClass = containerType.getCategoryClass();
        return (Container)this.getChild(categoryClass);
    }

    @StateTransition(currentState={State.UNINITIALIZED}, desiredState=State.QUIESCED)
    protected ListenableFuture<Void> startQuiesced() {
        EventLogger startupLogger = this.initiateStartupLogging();
        try {
            Container<?> container = this.initateStoreAndRecovery();
            container.setEventLogger(startupLogger);
            return Futures.immediateFuture(null);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private EventLogger initiateStartupLogging() {
        EventLogger startupLogger;
        EventLogger eventLogger = this._eventLogger;
        if (this.isStartupLoggedToSystemOut()) {
            MessageLogger[] messageLoggers = new MessageLogger[]{new SystemOutMessageLogger(), eventLogger.getMessageLogger()};
            CompositeStartupMessageLogger startupMessageLogger = new CompositeStartupMessageLogger(messageLoggers);
            startupLogger = new EventLogger(startupMessageLogger);
        } else {
            startupLogger = eventLogger;
        }
        return startupLogger;
    }

    @Override
    protected final boolean rethrowRuntimeExceptionsOnOpen() {
        return true;
    }

    protected abstract DurableConfigurationStore createStoreObject();

    @Override
    public DurableConfigurationStore getConfigurationStore() {
        return this._configurationStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfiguredObjectRecord[] convertToConfigurationRecords(String initialConfigurationLocation) throws IOException {
        InputStreamReader reader;
        ConfiguredObjectRecordConverter converter = new ConfiguredObjectRecordConverter(this.getModel());
        try {
            URL url = new URL(initialConfigurationLocation);
            reader = new InputStreamReader(url.openStream());
        }
        catch (MalformedURLException e) {
            reader = new FileReader(initialConfigurationLocation);
        }
        try {
            Collection<ConfiguredObjectRecord> records = converter.readFromJson(null, this, reader);
            ConfiguredObjectRecord[] configuredObjectRecordArray = records.toArray(new ConfiguredObjectRecord[records.size()]);
            return configuredObjectRecordArray;
        }
        finally {
            ((Reader)reader).close();
        }
    }

    @Override
    public String getDefaultContainerType() {
        return this._defaultContainerType;
    }

    @Override
    public boolean isManagementMode() {
        return this._managementMode;
    }

    @Override
    public int getManagementModeHttpPortOverride() {
        return this._managementModeHttpPortOverride;
    }

    @Override
    public boolean isManagementModeQuiesceVirtualHosts() {
        return this._managementModeQuiesceVirtualHosts;
    }

    @Override
    public String getManagementModePassword() {
        return this._managementModePassword;
    }

    @Override
    public String getInitialConfigurationLocation() {
        return this._initialConfigurationLocation;
    }

    @Override
    public boolean isStartupLoggedToSystemOut() {
        return this._startupLoggedToSystemOut;
    }

    @Override
    public PreferenceStoreAttributes getPreferenceStoreAttributes() {
        return this._preferenceStoreAttributes;
    }

    @Override
    public PreferenceStore createPreferenceStore() {
        Map<String, Object> attributes;
        String preferenceStoreType;
        PreferenceStoreAttributes preferenceStoreAttributes = this.getPreferenceStoreAttributes();
        Map<String, PreferenceStoreFactoryService> preferenceStoreFactories = new QpidServiceLoader().getInstancesByType(PreferenceStoreFactoryService.class);
        if (preferenceStoreAttributes == null) {
            preferenceStoreType = "Noop";
            attributes = Collections.emptyMap();
        } else {
            preferenceStoreType = preferenceStoreAttributes.getType();
            attributes = preferenceStoreAttributes.getAttributes();
        }
        PreferenceStoreFactoryService preferenceStoreFactory = preferenceStoreFactories.get(preferenceStoreType);
        return preferenceStoreFactory.createInstance(this, attributes);
    }

    @Override
    protected final Principal getSystemPrincipal() {
        return this._systemPrincipal;
    }

    @Override
    public Runnable getOnContainerResolveTask() {
        return this._onContainerResolveTask;
    }

    @Override
    public void setOnContainerResolveTask(Runnable onContainerResolveTask) {
        this._onContainerResolveTask = onContainerResolveTask;
    }

    @Override
    public Runnable getOnContainerCloseTask() {
        return this._onContainerCloseTask;
    }

    @Override
    public void setOnContainerCloseTask(Runnable onContainerCloseTask) {
        this._onContainerCloseTask = onContainerCloseTask;
    }

    private class ShutdownService
    implements Runnable {
        private ShutdownService() {
        }

        @Override
        public void run() {
            Subject.doAs(AbstractSystemConfig.this.getSystemTaskSubject("Shutdown"), new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    LOGGER.debug("Shutdown hook initiating close");
                    ListenableFuture<Void> closeResult = AbstractSystemConfig.this.closeAsync();
                    try {
                        closeResult.get(30000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException | ExecutionException | TimeoutException e) {
                        LOGGER.warn("Attempting to cleanly shutdown took too long, exiting immediately", (Throwable)e);
                    }
                    return null;
                }
            });
        }
    }
}

