/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.AbstractUnresolvedObject;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectFactory;
import org.apache.qpid.server.model.ConfiguredObjectTypeRegistry;
import org.apache.qpid.server.plugin.ConfiguredObjectTypeFactory;
import org.apache.qpid.server.store.ConfiguredObjectDependency;
import org.apache.qpid.server.store.ConfiguredObjectRecord;
import org.apache.qpid.server.store.UnresolvedConfiguredObject;

public abstract class AbstractConfiguredObjectTypeFactory<X extends AbstractConfiguredObject<X>>
implements ConfiguredObjectTypeFactory<X> {
    private final Class<X> _clazz;

    public AbstractConfiguredObjectTypeFactory(Class<X> clazz) {
        this._clazz = clazz;
    }

    @Override
    public final String getType() {
        return ConfiguredObjectTypeRegistry.getType(this._clazz);
    }

    @Override
    public final Class<? super X> getCategoryClass() {
        return ConfiguredObjectTypeRegistry.getCategory(this._clazz);
    }

    @Override
    public X create(ConfiguredObjectFactory factory, Map<String, Object> attributes, ConfiguredObject<?> ... parents) {
        X instance = this.createInstance(attributes, parents);
        ((AbstractConfiguredObject)instance).create();
        return instance;
    }

    @Override
    public ListenableFuture<X> createAsync(ConfiguredObjectFactory factory, Map<String, Object> attributes, ConfiguredObject<?> ... parents) {
        final SettableFuture returnVal = SettableFuture.create();
        final X instance = this.createInstance(attributes, parents);
        ListenableFuture<Void> createFuture = ((AbstractConfiguredObject)instance).createAsync();
        AbstractConfiguredObject.addFutureCallback(createFuture, new FutureCallback<Void>(){

            public void onSuccess(Void result) {
                returnVal.set((Object)instance);
            }

            public void onFailure(Throwable t) {
                returnVal.setException(t);
            }
        }, MoreExecutors.directExecutor());
        return returnVal;
    }

    protected abstract X createInstance(Map<String, Object> var1, ConfiguredObject<?> ... var2);

    public final <C extends ConfiguredObject<?>> C getParent(Class<C> parentClass, ConfiguredObject<?> ... parents) {
        for (ConfiguredObject<?> parent : parents) {
            if (!parentClass.isInstance(parent)) continue;
            return (C)parent;
        }
        throw new IllegalArgumentException("No parent of class " + parentClass.getSimpleName() + " found.");
    }

    @Override
    public UnresolvedConfiguredObject<X> recover(ConfiguredObjectFactory factory, ConfiguredObjectRecord record, ConfiguredObject<?> ... parents) {
        return new GenericUnresolvedConfiguredObject(record, parents);
    }

    private class GenericUnresolvedConfiguredObject
    extends AbstractUnresolvedObject<X> {
        public GenericUnresolvedConfiguredObject(ConfiguredObjectRecord record, ConfiguredObject<?>[] parents) {
            super(AbstractConfiguredObjectTypeFactory.this._clazz, record, parents);
        }

        @Override
        protected <C extends ConfiguredObject<C>> void resolved(ConfiguredObjectDependency<C> dependency, C value) {
        }

        @Override
        public X resolve() {
            HashMap<String, Object> attributesWithId = new HashMap<String, Object>(this.getRecord().getAttributes());
            attributesWithId.put("id", this.getRecord().getId());
            Object instance = AbstractConfiguredObjectTypeFactory.this.createInstance(attributesWithId, this.getParents());
            ((AbstractConfiguredObject)instance).registerWithParents();
            return instance;
        }
    }
}

