/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.message.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.message.internal.InternalMessageHeader;
import org.apache.qpid.server.message.internal.InternalMessageMetaDataType;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;

public class InternalMessageMetaData
implements StorableMessageMetaData {
    private boolean _isPersistent;
    private InternalMessageHeader _header;
    private int _contentSize;
    private byte[] _headerBytes;

    public InternalMessageMetaData(boolean isPersistent, InternalMessageHeader header, int contentSize) {
        this._isPersistent = isPersistent;
        this._header = header;
        this._contentSize = contentSize;
        try (ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
             ObjectOutputStream os = new ObjectOutputStream(bytesOut);){
            os.writeInt(contentSize);
            os.writeObject(header);
            os.close();
            this._headerBytes = bytesOut.toByteArray();
        }
        catch (IOException e) {
            throw new ConnectionScopedRuntimeException("Unexpected IO Exception on in memory operation", e);
        }
    }

    @Override
    public InternalMessageMetaDataType getType() {
        return InternalMessageMetaDataType.INSTANCE;
    }

    @Override
    public int getStorableSize() {
        return this._headerBytes.length;
    }

    @Override
    public int writeToBuffer(QpidByteBuffer dest) {
        dest.put(this._headerBytes);
        return this._headerBytes.length;
    }

    @Override
    public int getContentSize() {
        return this._contentSize;
    }

    @Override
    public boolean isPersistent() {
        return this._isPersistent;
    }

    @Override
    public void dispose() {
    }

    InternalMessageHeader getHeader() {
        return this._header;
    }

    @Override
    public void clearEncodedForm() {
    }

    static InternalMessageMetaData create(boolean persistent, InternalMessageHeader header, int contentSize) {
        return new InternalMessageMetaData(persistent, header, contentSize);
    }
}

