/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.message.internal;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.message.AMQMessageHeader;

public final class InternalMessageHeader
implements AMQMessageHeader,
Serializable {
    private static final long serialVersionUID = 7219183903302678948L;
    private final LinkedHashMap<String, Object> _headers;
    private final String _correlationId;
    private final long _expiration;
    private final String _userId;
    private final String _appId;
    private final String _messageId;
    private final String _mimeType;
    private final String _encoding;
    private final byte _priority;
    private final long _timestamp;
    private final long _notValidBefore;
    private final String _type;
    private final String _replyTo;
    private long _arrivalTime;

    public InternalMessageHeader(Map<String, Object> headers, String correlationId, long expiration, String userId, String appId, String messageId, String mimeType, String encoding, byte priority, long timestamp, long notValidBefore, String type, String replyTo) {
        this._headers = headers == null ? new LinkedHashMap() : new LinkedHashMap<String, Object>(headers);
        this._correlationId = correlationId;
        this._expiration = expiration;
        this._userId = userId;
        this._appId = appId;
        this._messageId = messageId;
        this._mimeType = mimeType;
        this._encoding = encoding;
        this._priority = priority;
        this._timestamp = timestamp;
        this._notValidBefore = notValidBefore;
        this._type = type;
        this._replyTo = replyTo;
        this._arrivalTime = System.currentTimeMillis();
    }

    public InternalMessageHeader(AMQMessageHeader header) {
        this._correlationId = header.getCorrelationId();
        this._expiration = header.getExpiration();
        this._userId = header.getUserId();
        this._appId = header.getAppId();
        this._messageId = header.getMessageId();
        this._mimeType = header.getMimeType();
        this._encoding = header.getEncoding();
        this._priority = header.getPriority();
        this._timestamp = header.getTimestamp();
        this._notValidBefore = header.getNotValidBefore();
        this._type = header.getType();
        this._replyTo = header.getReplyTo();
        this._headers = new LinkedHashMap();
        for (String headerName : header.getHeaderNames()) {
            this._headers.put(headerName, header.getHeader(headerName));
        }
        this._arrivalTime = System.currentTimeMillis();
    }

    @Override
    public String getCorrelationId() {
        return this._correlationId;
    }

    @Override
    public long getExpiration() {
        return this._expiration;
    }

    @Override
    public String getUserId() {
        return this._userId;
    }

    @Override
    public String getAppId() {
        return this._appId;
    }

    @Override
    public String getMessageId() {
        return this._messageId;
    }

    @Override
    public String getMimeType() {
        return this._mimeType;
    }

    @Override
    public String getEncoding() {
        return this._encoding;
    }

    @Override
    public byte getPriority() {
        return this._priority;
    }

    @Override
    public long getTimestamp() {
        return this._timestamp;
    }

    @Override
    public long getNotValidBefore() {
        return this._notValidBefore;
    }

    @Override
    public String getType() {
        return this._type;
    }

    @Override
    public String getReplyTo() {
        return this._replyTo;
    }

    @Override
    public Object getHeader(String name) {
        return this._headers.get(name);
    }

    @Override
    public boolean containsHeaders(Set<String> names) {
        return this._headers.keySet().containsAll(names);
    }

    @Override
    public boolean containsHeader(String name) {
        return this._headers.keySet().contains(name);
    }

    @Override
    public Collection<String> getHeaderNames() {
        return Collections.unmodifiableCollection(this._headers.keySet());
    }

    long getArrivalTime() {
        return this._arrivalTime;
    }

    public Map<String, Object> getHeaderMap() {
        return Collections.unmodifiableMap(new LinkedHashMap<String, Object>(this._headers));
    }
}

