/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.message.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.message.AbstractServerMessageImpl;
import org.apache.qpid.server.message.internal.InternalMessageHeader;
import org.apache.qpid.server.message.internal.InternalMessageMetaData;
import org.apache.qpid.server.store.MessageHandle;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.util.ByteBufferInputStream;
import org.apache.qpid.util.ByteBufferUtils;

public class InternalMessage
extends AbstractServerMessageImpl<InternalMessage, InternalMessageMetaData> {
    private final Object _messageBody;
    private final int _contentSize;
    private InternalMessageHeader _header;
    private String _initialRoutingAddress;

    InternalMessage(StoredMessage<InternalMessageMetaData> handle, InternalMessageHeader header, Object messageBody) {
        super(handle, null);
        this._header = header;
        this._messageBody = messageBody;
        this._contentSize = handle.getMetaData().getContentSize();
    }

    InternalMessage(StoredMessage<InternalMessageMetaData> msg) {
        super(msg, null);
        this._contentSize = msg.getMetaData().getContentSize();
        this._header = msg.getMetaData().getHeader();
        Collection<QpidByteBuffer> bufs = msg.getContent(0, this._contentSize);
        try (ObjectInputStream is = new ObjectInputStream((InputStream)new ByteBufferInputStream(ByteBufferUtils.combine(bufs)));){
            this._messageBody = is.readObject();
        }
        catch (IOException e) {
            throw new ConnectionScopedRuntimeException("Unexpected IO Exception in operation in memory", e);
        }
        catch (ClassNotFoundException e) {
            throw new ConnectionScopedRuntimeException("Object message contained an object which could not be deserialized", e);
        }
    }

    @Override
    public String getInitialRoutingAddress() {
        return this._initialRoutingAddress;
    }

    @Override
    public InternalMessageHeader getMessageHeader() {
        return this._header;
    }

    @Override
    public long getSize() {
        return this._contentSize;
    }

    @Override
    public long getExpiration() {
        return this._header.getExpiration();
    }

    @Override
    public long getArrivalTime() {
        return this._header.getArrivalTime();
    }

    public Object getMessageBody() {
        return this._messageBody;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static InternalMessage createMessage(MessageStore store, AMQMessageHeader header, Serializable bodyObject, boolean persistent) {
        InternalMessageHeader internalHeader = header instanceof InternalMessageHeader ? (InternalMessageHeader)header : new InternalMessageHeader(header);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        try (ObjectOutputStream os = new ObjectOutputStream(bytesOut);){
            os.writeObject(bodyObject);
            os.close();
            byte[] bytes = bytesOut.toByteArray();
            InternalMessageMetaData metaData = InternalMessageMetaData.create(persistent, internalHeader, bytes.length);
            MessageHandle<InternalMessageMetaData> handle = store.addMessage(metaData);
            handle.addContent(QpidByteBuffer.wrap((byte[])bytes));
            StoredMessage<InternalMessageMetaData> storedMessage = handle.allContentAdded();
            InternalMessage internalMessage = new InternalMessage(storedMessage, internalHeader, bodyObject);
            return internalMessage;
        }
        catch (IOException e) {
            throw new ConnectionScopedRuntimeException("Unexpected IO Exception on operation in memory", e);
        }
    }

    public static InternalMessage createStringMessage(MessageStore store, AMQMessageHeader header, String messageBody) {
        return InternalMessage.createStringMessage(store, header, messageBody, false);
    }

    public static InternalMessage createStringMessage(MessageStore store, AMQMessageHeader header, String messageBody, boolean persistent) {
        return InternalMessage.createMessage(store, header, (Serializable)((Object)messageBody), persistent);
    }

    public static InternalMessage createMapMessage(MessageStore store, AMQMessageHeader header, Map<? extends Object, ? extends Object> messageBody) {
        return InternalMessage.createMessage(store, header, new LinkedHashMap<Object, Object>(messageBody), false);
    }

    public static InternalMessage createListMessage(MessageStore store, AMQMessageHeader header, List<? extends Object> messageBody) {
        return InternalMessage.createMessage(store, header, new ArrayList<Object>(messageBody), false);
    }

    public static InternalMessage createBytesMessage(MessageStore store, AMQMessageHeader header, byte[] messageBody) {
        return InternalMessage.createBytesMessage(store, header, messageBody, false);
    }

    public static InternalMessage createBytesMessage(MessageStore store, AMQMessageHeader header, byte[] messageBody, boolean persist) {
        return InternalMessage.createMessage(store, header, (Serializable)messageBody, persist);
    }

    public static InternalMessage convert(long messageNumber, boolean persistent, AMQMessageHeader header, Object messageBody) {
        InternalMessageHeader convertedHeader = new InternalMessageHeader(header);
        StoredMessage<InternalMessageMetaData> handle = InternalMessage.createReadOnlyHandle(messageNumber, persistent, convertedHeader, messageBody);
        return new InternalMessage(handle, convertedHeader, messageBody);
    }

    /*
     * Exception decompiling
     */
    private static StoredMessage<InternalMessageMetaData> createReadOnlyHandle(long messageNumber, boolean persistent, InternalMessageHeader header, Object messageBody) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setInitialRoutingAddress(String initialRoutingAddress) {
        this._initialRoutingAddress = initialRoutingAddress;
    }
}

