/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.message;

import org.apache.qpid.server.consumer.ConsumerImpl;
import org.apache.qpid.server.filter.Filterable;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.store.MessageEnqueueRecord;
import org.apache.qpid.server.store.TransactionLogResource;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.StateChangeListener;

public interface MessageInstance {
    public static final EntryState AVAILABLE_STATE = new AvailableState();
    public static final EntryState DELETED_STATE = new DeletedState();
    public static final EntryState DEQUEUED_STATE = new DequeuedState();
    public static final EntryState NON_CONSUMER_ACQUIRED_STATE = new NonConsumerAcquiredState();

    public int getDeliveryCount();

    public void incrementDeliveryCount();

    public void decrementDeliveryCount();

    public void addStateChangeListener(StateChangeListener<? super MessageInstance, EntryState> var1);

    public boolean removeStateChangeListener(StateChangeListener<? super MessageInstance, EntryState> var1);

    public boolean acquiredByConsumer();

    public boolean isAcquiredBy(ConsumerImpl var1);

    public boolean removeAcquisitionFromConsumer(ConsumerImpl var1);

    public void setRedelivered();

    public boolean isRedelivered();

    public ConsumerImpl getDeliveredConsumer();

    public void reject();

    public boolean isRejectedBy(ConsumerImpl var1);

    public boolean getDeliveredToConsumer();

    public boolean expired();

    public boolean acquire(ConsumerImpl var1);

    public boolean makeAcquisitionUnstealable(ConsumerImpl var1);

    public boolean makeAcquisitionStealable();

    public int getMaximumDeliveryCount();

    public int routeToAlternate(Action<? super MessageInstance> var1, ServerTransaction var2);

    public Filterable asFilterable();

    public ConsumerImpl getAcquiringConsumer();

    public MessageEnqueueRecord getEnqueueRecord();

    public boolean isAvailable();

    public boolean acquire();

    public boolean isAcquired();

    public void release();

    public void release(ConsumerImpl var1);

    public boolean resend();

    public void delete();

    public boolean isDeleted();

    public boolean isHeld();

    public ServerMessage getMessage();

    public InstanceProperties getInstanceProperties();

    public TransactionLogResource getOwningResource();

    public static final class UnstealableConsumerAcquiredState<C extends ConsumerImpl>
    extends ConsumerAcquiredState {
        private final StealableConsumerAcquiredState<C> _stealableState;

        public UnstealableConsumerAcquiredState(StealableConsumerAcquiredState<C> stealableState) {
            this._stealableState = stealableState;
        }

        @Override
        public C getConsumer() {
            return this._stealableState.getConsumer();
        }

        public StealableConsumerAcquiredState<C> getStealableState() {
            return this._stealableState;
        }
    }

    public static final class StealableConsumerAcquiredState<C extends ConsumerImpl>
    extends ConsumerAcquiredState {
        private final C _consumer;
        private final UnstealableConsumerAcquiredState<C> _unstealableState;

        public StealableConsumerAcquiredState(C consumer) {
            this._consumer = consumer;
            this._unstealableState = new UnstealableConsumerAcquiredState(this);
        }

        @Override
        public C getConsumer() {
            return this._consumer;
        }

        public UnstealableConsumerAcquiredState<C> getUnstealableState() {
            return this._unstealableState;
        }
    }

    public static abstract class ConsumerAcquiredState<C extends ConsumerImpl>
    extends EntryState {
        public abstract C getConsumer();

        @Override
        public final State getState() {
            return State.ACQUIRED;
        }

        public String toString() {
            return "{" + this.getState().name() + " : " + this.getConsumer() + "}";
        }
    }

    public static final class NonConsumerAcquiredState
    extends EntryState {
        @Override
        public State getState() {
            return State.ACQUIRED;
        }

        public String toString() {
            return this.getState().name();
        }
    }

    public static final class DeletedState
    extends EntryState {
        @Override
        public State getState() {
            return State.DELETED;
        }

        public String toString() {
            return this.getState().name();
        }
    }

    public static final class DequeuedState
    extends EntryState {
        @Override
        public State getState() {
            return State.DEQUEUED;
        }

        public String toString() {
            return this.getState().name();
        }
    }

    public static final class AvailableState
    extends EntryState {
        @Override
        public State getState() {
            return State.AVAILABLE;
        }

        public String toString() {
            return this.getState().name();
        }
    }

    public static abstract class EntryState {
        protected EntryState() {
        }

        public abstract State getState();

        public boolean isDispensed() {
            State currentState = this.getState();
            return currentState == State.DEQUEUED || currentState == State.DELETED;
        }
    }

    public static enum State {
        AVAILABLE,
        ACQUIRED,
        DEQUEUED,
        DELETED;

    }
}

