/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.message;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.message.MessageAlreadyReferencedException;
import org.apache.qpid.server.message.MessageDeletedException;
import org.apache.qpid.server.message.MessageReference;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.store.TransactionLogResource;
import org.apache.qpid.server.util.ServerScopedRuntimeException;

public abstract class AbstractServerMessageImpl<X extends AbstractServerMessageImpl<X, T>, T extends StorableMessageMetaData>
implements ServerMessage<T> {
    private static final AtomicIntegerFieldUpdater<AbstractServerMessageImpl> _refCountUpdater = AtomicIntegerFieldUpdater.newUpdater(AbstractServerMessageImpl.class, "_referenceCount");
    private static final AtomicReferenceFieldUpdater<AbstractServerMessageImpl, Collection> _resourcesUpdater = AtomicReferenceFieldUpdater.newUpdater(AbstractServerMessageImpl.class, Collection.class, "_resources");
    private volatile int _referenceCount = 0;
    private final StoredMessage<T> _handle;
    private final Object _connectionReference;
    private volatile Collection<UUID> _resources;

    public AbstractServerMessageImpl(StoredMessage<T> handle, Object connectionReference) {
        this._handle = handle;
        this._connectionReference = connectionReference;
    }

    @Override
    public StoredMessage<T> getStoredMessage() {
        return this._handle;
    }

    private boolean incrementReference() {
        int count;
        do {
            if ((count = _refCountUpdater.get(this)) >= 0) continue;
            return false;
        } while (!_refCountUpdater.compareAndSet(this, count, count + 1));
        return true;
    }

    private void decrementReference() {
        boolean updated;
        do {
            int count;
            int newCount;
            if ((newCount = (count = _refCountUpdater.get(this)) - 1) > 0) {
                updated = _refCountUpdater.compareAndSet(this, count, newCount);
                continue;
            }
            if (newCount == 0) {
                updated = _refCountUpdater.compareAndSet(this, count, -1);
                if (!updated || this._handle == null) continue;
                this._handle.remove();
                continue;
            }
            throw new ServerScopedRuntimeException("Reference count for message id " + this.debugIdentity() + " has gone below 0.");
        } while (!updated);
    }

    public String debugIdentity() {
        return "(HC:" + System.identityHashCode(this) + " ID:" + this.getMessageNumber() + " Ref:" + this.getReferenceCount() + ")";
    }

    private int getReferenceCount() {
        return this._referenceCount;
    }

    @Override
    public final MessageReference<X> newReference() {
        return new Reference(this);
    }

    @Override
    public final MessageReference<X> newReference(TransactionLogResource object) {
        return new Reference(this, object);
    }

    @Override
    public final boolean isReferenced(TransactionLogResource resource) {
        Collection<UUID> resources = this._resources;
        return resources != null && resources.contains(resource.getId());
    }

    @Override
    public final boolean isReferenced() {
        Collection<UUID> resources = this._resources;
        return resources != null && !resources.isEmpty();
    }

    @Override
    public final boolean isPersistent() {
        return this._handle.getMetaData().isPersistent();
    }

    @Override
    public final long getMessageNumber() {
        return this.getStoredMessage().getMessageNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Collection<QpidByteBuffer> getContent(int offset, int length) {
        StoredMessage<T> storedMessage = this.getStoredMessage();
        boolean wasInMemory = storedMessage.isInMemory();
        try {
            Collection<QpidByteBuffer> collection = storedMessage.getContent(offset, length);
            return collection;
        }
        finally {
            if (!wasInMemory) {
                storedMessage.flowToDisk();
            }
        }
    }

    @Override
    public final Object getConnectionReference() {
        return this._connectionReference;
    }

    public String toString() {
        return "Message[" + this.debugIdentity() + "]";
    }

    private static class Reference<X extends AbstractServerMessageImpl<X, T>, T extends StorableMessageMetaData>
    implements MessageReference<X> {
        private static final AtomicIntegerFieldUpdater<Reference> _releasedUpdater = AtomicIntegerFieldUpdater.newUpdater(Reference.class, "_released");
        private AbstractServerMessageImpl<X, T> _message;
        private final UUID _resourceId;
        private volatile int _released;

        private Reference(AbstractServerMessageImpl<X, T> message) throws MessageDeletedException {
            this(message, null);
        }

        private Reference(AbstractServerMessageImpl<X, T> message, TransactionLogResource resource) throws MessageDeletedException {
            this._message = message;
            if (resource != null) {
                Collection<UUID> newValue;
                Collection currentValue;
                this._resourceId = resource.getId();
                do {
                    if ((currentValue = ((AbstractServerMessageImpl)this._message)._resources) == null) {
                        newValue = Collections.singleton(this._resourceId);
                        continue;
                    }
                    if (currentValue.contains(this._resourceId)) {
                        throw new MessageAlreadyReferencedException(this._message.getMessageNumber(), resource);
                    }
                    newValue = new ArrayList(currentValue.size() + 1);
                    newValue.addAll(currentValue);
                    newValue.add(this._resourceId);
                } while (!_resourcesUpdater.compareAndSet(this._message, currentValue, newValue));
            } else {
                this._resourceId = null;
            }
            if (!((AbstractServerMessageImpl)this._message).incrementReference()) {
                throw new MessageDeletedException(message.getMessageNumber());
            }
        }

        @Override
        public X getMessage() {
            return (X)this._message;
        }

        @Override
        public synchronized void release() {
            if (_releasedUpdater.compareAndSet(this, 0, 1)) {
                if (this._resourceId != null) {
                    List<UUID> newValue;
                    Collection currentValue;
                    do {
                        if ((currentValue = ((AbstractServerMessageImpl)this._message)._resources).size() == 1) {
                            newValue = null;
                            continue;
                        }
                        UUID[] array = new UUID[currentValue.size() - 1];
                        int pos = 0;
                        for (UUID uuid : currentValue) {
                            if (this._resourceId.equals(uuid)) continue;
                            array[pos++] = uuid;
                        }
                        newValue = Arrays.asList(array);
                    } while (!_resourcesUpdater.compareAndSet(this._message, currentValue, newValue));
                }
                ((AbstractServerMessageImpl)this._message).decrementReference();
            }
        }

        @Override
        public void close() {
            this.release();
        }
    }
}

