/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.messages;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.qpid.server.configuration.BrokerProperties;
import org.apache.qpid.server.logging.LogMessage;
import org.slf4j.LoggerFactory;

public class TrustStoreMessages {
    private static ResourceBundle _messages;
    private static Locale _currentLocale;
    public static final String TRUSTSTORE_LOG_HIERARCHY = "qpid.message.truststore";
    public static final String OPEN_LOG_HIERARCHY = "qpid.message.truststore.open";
    public static final String CREATE_LOG_HIERARCHY = "qpid.message.truststore.create";
    public static final String DELETE_LOG_HIERARCHY = "qpid.message.truststore.delete";
    public static final String CLOSE_LOG_HIERARCHY = "qpid.message.truststore.close";

    public static LogMessage OPEN() {
        String rawMessage;
        final String message = rawMessage = _messages.getString("OPEN");
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return TrustStoreMessages.OPEN_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage CREATE(String param1) {
        String rawMessage = _messages.getString("CREATE");
        Object[] messageArguments = new Object[]{param1};
        MessageFormat formatter = new MessageFormat(rawMessage, _currentLocale);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return TrustStoreMessages.CREATE_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage DELETE(String param1) {
        String rawMessage = _messages.getString("DELETE");
        Object[] messageArguments = new Object[]{param1};
        MessageFormat formatter = new MessageFormat(rawMessage, _currentLocale);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return TrustStoreMessages.DELETE_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage CLOSE() {
        String rawMessage;
        final String message = rawMessage = _messages.getString("CLOSE");
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return TrustStoreMessages.CLOSE_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    private TrustStoreMessages() {
    }

    static {
        _currentLocale = BrokerProperties.getLocale();
        LoggerFactory.getLogger((String)TRUSTSTORE_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)OPEN_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)CREATE_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)DELETE_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)CLOSE_LOG_HIERARCHY);
        _messages = ResourceBundle.getBundle("org.apache.qpid.server.logging.messages.TrustStore_logmessages", _currentLocale);
    }
}

