/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.filter;

import org.apache.qpid.common.AMQPFilterTypes;
import org.apache.qpid.filter.BooleanExpression;
import org.apache.qpid.filter.JMSMessagePropertyExpression;
import org.apache.qpid.filter.SelectorParsingException;
import org.apache.qpid.filter.selector.ParseException;
import org.apache.qpid.filter.selector.SelectorParser;
import org.apache.qpid.filter.selector.TokenMgrError;
import org.apache.qpid.server.filter.Filterable;
import org.apache.qpid.server.filter.MessageFilter;
import org.apache.qpid.server.plugin.PluggableService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluggableService
public class JMSSelectorFilter
implements MessageFilter {
    private static final Logger _logger = LoggerFactory.getLogger(JMSSelectorFilter.class);
    private String _selector;
    private BooleanExpression _matcher;

    public JMSSelectorFilter(String selector) throws ParseException, TokenMgrError, SelectorParsingException {
        this._selector = selector;
        SelectorParser selectorParser = new SelectorParser();
        selectorParser.setPropertyExpressionFactory(JMSMessagePropertyExpression.FACTORY);
        this._matcher = selectorParser.parse(selector);
    }

    @Override
    public String getName() {
        return AMQPFilterTypes.JMS_SELECTOR.toString();
    }

    @Override
    public boolean matches(Filterable message) {
        boolean match = this._matcher.matches((Object)message);
        if (_logger.isDebugEnabled()) {
            _logger.debug(message + " match(" + match + ") selector(" + System.identityHashCode(this._selector) + "):" + this._selector);
        }
        return match;
    }

    @Override
    public boolean startAtTail() {
        return false;
    }

    public String getSelector() {
        return this._selector;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JMSSelectorFilter that = (JMSSelectorFilter)o;
        return this.getSelector().equals(that.getSelector());
    }

    public int hashCode() {
        return this.getSelector().hashCode();
    }

    public String toString() {
        return "JMSSelectorFilter[selector='" + this._selector + '\'' + ']';
    }
}

