/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.filter;

import org.apache.qpid.filter.FilterableMessage;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.ServerMessage;

public interface Filterable
extends FilterableMessage {
    public AMQMessageHeader getMessageHeader();

    public boolean isPersistent();

    public boolean isRedelivered();

    public Object getConnectionReference();

    public long getMessageNumber();

    public long getArrivalTime();

    public static class Factory {
        public static Filterable newInstance(final ServerMessage message, final InstanceProperties properties) {
            return new Filterable(){

                @Override
                public AMQMessageHeader getMessageHeader() {
                    return message.getMessageHeader();
                }

                @Override
                public boolean isPersistent() {
                    return Boolean.TRUE.equals(properties.getProperty(InstanceProperties.Property.PERSISTENT));
                }

                @Override
                public boolean isRedelivered() {
                    return Boolean.TRUE.equals(properties.getProperty(InstanceProperties.Property.REDELIVERED));
                }

                @Override
                public Object getConnectionReference() {
                    return message.getConnectionReference();
                }

                @Override
                public long getMessageNumber() {
                    return message.getMessageNumber();
                }

                @Override
                public long getArrivalTime() {
                    return message.getArrivalTime();
                }

                public String getReplyTo() {
                    return message.getMessageHeader().getReplyTo();
                }

                public String getType() {
                    return message.getMessageHeader().getType();
                }

                public byte getPriority() {
                    return message.getMessageHeader().getPriority();
                }

                public String getMessageId() {
                    return message.getMessageHeader().getMessageId();
                }

                public long getTimestamp() {
                    return message.getMessageHeader().getTimestamp();
                }

                public String getCorrelationId() {
                    return message.getMessageHeader().getCorrelationId();
                }

                public long getExpiration() {
                    return message.getMessageHeader().getExpiration();
                }

                public Object getHeader(String name) {
                    return message.getMessageHeader().getHeader(name);
                }

                public String toString() {
                    StringBuilder builder = new StringBuilder();
                    builder.append(this.getClass().getName());
                    builder.append(" [messageNumber=");
                    builder.append(this.getMessageNumber());
                    if (this.getMessageId() != null) {
                        builder.append(", id=");
                        builder.append(this.getMessageId());
                    }
                    builder.append("]");
                    return builder.toString();
                }
            };
        }
    }
}

