/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.filter;

import java.util.List;
import org.apache.qpid.common.AMQPFilterTypes;
import org.apache.qpid.server.filter.ArrivalTimeFilter;
import org.apache.qpid.server.filter.MessageFilter;
import org.apache.qpid.server.plugin.MessageFilterFactory;
import org.apache.qpid.server.plugin.PluggableService;

@PluggableService
public final class ArrivalTimeFilterFactory
implements MessageFilterFactory {
    @Override
    public MessageFilter newInstance(List<String> arguments) {
        if (arguments == null || arguments.size() != 1) {
            throw new IllegalArgumentException("Cannot create a filter from these arguments: " + arguments);
        }
        String arg = arguments.get(0);
        long startingFrom = Long.parseLong(arg);
        return new ArrivalTimeFilter(System.currentTimeMillis() + startingFrom, startingFrom == 0L);
    }

    @Override
    public String getType() {
        return AMQPFilterTypes.REPLAY_PERIOD.toString();
    }
}

