/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange.topic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.qpid.server.exchange.topic.TopicMatcherResult;
import org.apache.qpid.server.filter.FilterManager;
import org.apache.qpid.server.filter.Filterable;
import org.apache.qpid.server.model.Binding;
import org.apache.qpid.server.model.Queue;

public final class TopicExchangeResult
implements TopicMatcherResult {
    private final List<Binding<?>> _bindings = new CopyOnWriteArrayList();
    private final Map<Queue<?>, Integer> _unfilteredQueues = new ConcurrentHashMap();
    private final ConcurrentMap<Queue<?>, Map<FilterManager, Integer>> _filteredQueues = new ConcurrentHashMap();
    private volatile ArrayList<Queue<?>> _unfilteredQueueList = new ArrayList(0);

    public void addUnfilteredQueue(Queue<?> queue) {
        Integer instances = this._unfilteredQueues.get(queue);
        if (instances == null) {
            this._unfilteredQueues.put(queue, 1);
            ArrayList newList = new ArrayList(this._unfilteredQueueList);
            newList.add(queue);
            this._unfilteredQueueList = newList;
        } else {
            this._unfilteredQueues.put(queue, instances + 1);
        }
    }

    public void removeUnfilteredQueue(Queue<?> queue) {
        Integer instances = this._unfilteredQueues.get(queue);
        if (instances == 1) {
            this._unfilteredQueues.remove(queue);
            ArrayList newList = new ArrayList(this._unfilteredQueueList);
            newList.remove(queue);
            this._unfilteredQueueList = newList;
        } else {
            this._unfilteredQueues.put(queue, instances - 1);
        }
    }

    public Collection<Queue<?>> getUnfilteredQueues() {
        return this._unfilteredQueues.keySet();
    }

    public void addBinding(Binding<?> binding) {
        this._bindings.add(binding);
    }

    public void removeBinding(Binding<?> binding) {
        this._bindings.remove(binding);
    }

    public List<Binding<?>> getBindings() {
        return new ArrayList(this._bindings);
    }

    public void addFilteredQueue(Queue<?> queue, FilterManager filter) {
        Integer instances;
        ConcurrentHashMap<FilterManager, Integer> filters = (ConcurrentHashMap<FilterManager, Integer>)this._filteredQueues.get(queue);
        if (filters == null) {
            filters = new ConcurrentHashMap<FilterManager, Integer>();
            this._filteredQueues.put(queue, filters);
        }
        if ((instances = (Integer)filters.get(filter)) == null) {
            filters.put(filter, 1);
        } else {
            filters.put(filter, instances + 1);
        }
    }

    public void removeFilteredQueue(Queue<?> queue, FilterManager filter) {
        Integer instances;
        Map filters = (Map)this._filteredQueues.get(queue);
        if (filters != null && (instances = (Integer)filters.get(filter)) != null) {
            if (instances == 1) {
                filters.remove(filter);
                if (filters.isEmpty()) {
                    this._filteredQueues.remove(queue);
                }
            } else {
                filters.put(filter, instances - 1);
            }
        }
    }

    public void replaceQueueFilter(Queue<?> queue, FilterManager oldFilter, FilterManager newFilter) {
        Map filters = (Map)this._filteredQueues.get(queue);
        ConcurrentHashMap<FilterManager, Integer> newFilters = new ConcurrentHashMap<FilterManager, Integer>(filters);
        Integer oldFilterInstances = (Integer)filters.get(oldFilter);
        if (oldFilterInstances == 1) {
            newFilters.remove(oldFilter);
        } else {
            newFilters.put(oldFilter, oldFilterInstances - 1);
        }
        Integer newFilterInstances = (Integer)filters.get(newFilter);
        if (newFilterInstances == null) {
            newFilters.put(newFilter, 1);
        } else {
            newFilters.put(newFilter, newFilterInstances + 1);
        }
        this._filteredQueues.put(queue, newFilters);
    }

    public Collection<Queue<?>> processMessage(Filterable msg, Collection<Queue<?>> queues) {
        if (queues == null) {
            if (this._filteredQueues.isEmpty()) {
                return this._unfilteredQueueList;
            }
            queues = new HashSet();
        } else if (!(queues instanceof Set)) {
            queues = new HashSet(queues);
        }
        queues.addAll(this._unfilteredQueues.keySet());
        if (!this._filteredQueues.isEmpty()) {
            for (Map.Entry entry : this._filteredQueues.entrySet()) {
                if (queues.contains(entry.getKey())) continue;
                for (FilterManager filter : ((Map)entry.getValue()).keySet()) {
                    if (!filter.allAllow(msg)) continue;
                    queues.add((Queue<?>)entry.getKey());
                }
            }
        }
        return queues;
    }
}

