/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.qpid.server.exchange.AbstractExchange;
import org.apache.qpid.server.exchange.topic.TopicExchangeResult;
import org.apache.qpid.server.exchange.topic.TopicMatcherResult;
import org.apache.qpid.server.exchange.topic.TopicNormalizer;
import org.apache.qpid.server.exchange.topic.TopicParser;
import org.apache.qpid.server.filter.AMQInvalidArgumentException;
import org.apache.qpid.server.filter.FilterSupport;
import org.apache.qpid.server.filter.Filterable;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.Binding;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(category=false, type="topic")
public class TopicExchange
extends AbstractExchange<TopicExchange> {
    private static final Logger _logger = LoggerFactory.getLogger(TopicExchange.class);
    private final TopicParser _parser = new TopicParser();
    private final Map<String, TopicExchangeResult> _topicExchangeResults = new ConcurrentHashMap<String, TopicExchangeResult>();
    private final Map<Binding<?>, Map<String, Object>> _bindings = new HashMap();

    @ManagedObjectFactoryConstructor
    public TopicExchange(Map<String, Object> attributes, VirtualHost<?> vhost) {
        super(attributes, vhost);
    }

    @Override
    protected synchronized void onBindingUpdated(Binding<?> binding, Map<String, Object> oldArguments) {
        block8: {
            String bindingKey = binding.getBindingKey();
            Queue<?> queue = binding.getQueue();
            Map<String, Object> args = binding.getArguments();
            assert (queue != null);
            assert (bindingKey != null);
            _logger.debug("Updating binding of queue {} with routing key {}", (Object)queue.getName(), (Object)bindingKey);
            String routingKey = TopicNormalizer.normalize(bindingKey);
            try {
                if (!this._bindings.containsKey(binding)) break block8;
                Map<String, Object> oldArgs = this._bindings.get(binding);
                this._bindings.put(binding, args);
                TopicExchangeResult result = this._topicExchangeResults.get(routingKey);
                if (FilterSupport.argumentsContainFilter(args)) {
                    if (FilterSupport.argumentsContainFilter(oldArgs)) {
                        result.replaceQueueFilter(queue, FilterSupport.createMessageFilter(oldArgs, queue), FilterSupport.createMessageFilter(args, queue));
                    } else {
                        result.addFilteredQueue(queue, FilterSupport.createMessageFilter(args, queue));
                        result.removeUnfilteredQueue(queue);
                    }
                    break block8;
                }
                if (FilterSupport.argumentsContainFilter(oldArgs)) {
                    result.addUnfilteredQueue(queue);
                    result.removeFilteredQueue(queue, FilterSupport.createMessageFilter(oldArgs, queue));
                    break block8;
                }
                return;
            }
            catch (AMQInvalidArgumentException e) {
                throw new ConnectionScopedRuntimeException(e);
            }
        }
    }

    protected synchronized void registerQueue(Binding<?> binding) throws AMQInvalidArgumentException {
        String bindingKey = binding.getBindingKey();
        Queue<?> queue = binding.getQueue();
        Map<String, Object> args = binding.getArguments();
        assert (queue != null);
        assert (bindingKey != null);
        _logger.debug("Registering queue {} with routing key {}", (Object)queue.getName(), (Object)bindingKey);
        String routingKey = TopicNormalizer.normalize(bindingKey);
        if (this._bindings.containsKey(binding)) {
            Map<String, Object> oldArgs = this._bindings.get(binding);
            TopicExchangeResult result = this._topicExchangeResults.get(routingKey);
            if (FilterSupport.argumentsContainFilter(args)) {
                if (FilterSupport.argumentsContainFilter(oldArgs)) {
                    result.replaceQueueFilter(queue, FilterSupport.createMessageFilter(oldArgs, queue), FilterSupport.createMessageFilter(args, queue));
                } else {
                    result.addFilteredQueue(queue, FilterSupport.createMessageFilter(args, queue));
                    result.removeUnfilteredQueue(queue);
                }
            } else if (FilterSupport.argumentsContainFilter(oldArgs)) {
                result.addUnfilteredQueue(queue);
                result.removeFilteredQueue(queue, FilterSupport.createMessageFilter(oldArgs, queue));
            } else {
                return;
            }
            result.addBinding(binding);
        } else {
            TopicExchangeResult result = this._topicExchangeResults.get(routingKey);
            if (result == null) {
                result = new TopicExchangeResult();
                if (FilterSupport.argumentsContainFilter(args)) {
                    result.addFilteredQueue(queue, FilterSupport.createMessageFilter(args, queue));
                } else {
                    result.addUnfilteredQueue(queue);
                }
                this._parser.addBinding(routingKey, result);
                this._topicExchangeResults.put(routingKey, result);
            } else if (FilterSupport.argumentsContainFilter(args)) {
                result.addFilteredQueue(queue, FilterSupport.createMessageFilter(args, queue));
            } else {
                result.addUnfilteredQueue(queue);
            }
            result.addBinding(binding);
            this._bindings.put(binding, args);
        }
    }

    public ArrayList<BaseQueue> doRoute(ServerMessage payload, String routingAddress, InstanceProperties instanceProperties) {
        ArrayList<BaseQueue> queues;
        String routingKey = routingAddress == null ? "" : routingAddress;
        Collection<Queue<?>> matchedQueues = this.getMatchedQueues(Filterable.Factory.newInstance(payload, instanceProperties), routingKey);
        if (matchedQueues.getClass() == ArrayList.class) {
            queues = (ArrayList<BaseQueue>)matchedQueues;
        } else {
            queues = new ArrayList<BaseQueue>();
            queues.addAll(matchedQueues);
        }
        if (queues == null || queues.isEmpty()) {
            _logger.info("Message routing key: " + routingAddress + " No routes.");
        }
        return queues;
    }

    private synchronized boolean deregisterQueue(Binding<?> binding) {
        if (this._bindings.containsKey(binding)) {
            Map<String, Object> bindingArgs = this._bindings.remove(binding);
            _logger.debug("deregisterQueue args: {}", bindingArgs);
            String bindingKey = TopicNormalizer.normalize(binding.getBindingKey());
            TopicExchangeResult result = this._topicExchangeResults.get(bindingKey);
            result.removeBinding(binding);
            if (FilterSupport.argumentsContainFilter(bindingArgs)) {
                try {
                    result.removeFilteredQueue(binding.getQueue(), FilterSupport.createMessageFilter(bindingArgs, binding.getQueue()));
                }
                catch (AMQInvalidArgumentException e) {
                    return false;
                }
            } else {
                result.removeUnfilteredQueue(binding.getQueue());
            }
            return true;
        }
        return false;
    }

    private Collection<Queue<?>> getMatchedQueues(Filterable message, String routingKey) {
        Collection<TopicMatcherResult> results = this._parser.parse(routingKey);
        switch (results.size()) {
            case 0: {
                return Collections.EMPTY_SET;
            }
            case 1: {
                TopicMatcherResult[] resultQueues = new TopicMatcherResult[1];
                results.toArray(resultQueues);
                return ((TopicExchangeResult)resultQueues[0]).processMessage(message, null);
            }
        }
        Collection<Queue<?>> queues = new HashSet();
        for (TopicMatcherResult result : results) {
            TopicExchangeResult res = (TopicExchangeResult)result;
            for (Binding<?> b : res.getBindings()) {
                b.incrementMatches();
            }
            queues = res.processMessage(message, queues);
        }
        return queues;
    }

    @Override
    protected void onBind(Binding<?> binding) {
        try {
            this.registerQueue(binding);
        }
        catch (AMQInvalidArgumentException e) {
            throw new ConnectionScopedRuntimeException(e);
        }
    }

    @Override
    protected void onUnbind(Binding<?> binding) {
        this.deregisterQueue(binding);
    }
}

