/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.qpid.server.exchange.AbstractExchange;
import org.apache.qpid.server.exchange.HeadersBinding;
import org.apache.qpid.server.filter.Filterable;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.Binding;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.queue.BaseQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(category=false, type="headers")
public class HeadersExchange
extends AbstractExchange<HeadersExchange> {
    private static final Logger _logger = LoggerFactory.getLogger(HeadersExchange.class);
    private final ConcurrentMap<String, CopyOnWriteArraySet<Binding<?>>> _bindingsByKey = new ConcurrentHashMap();
    private final CopyOnWriteArrayList<HeadersBinding> _bindingHeaderMatchers = new CopyOnWriteArrayList();

    @ManagedObjectFactoryConstructor
    public HeadersExchange(Map<String, Object> attributes, VirtualHost<?> vhost) {
        super(attributes, vhost);
    }

    public ArrayList<BaseQueue> doRoute(ServerMessage payload, String routingKey, InstanceProperties instanceProperties) {
        _logger.debug("Exchange {}: routing message with headers {}", (Object)this.getName(), (Object)payload.getMessageHeader());
        LinkedHashSet queues = new LinkedHashSet();
        for (HeadersBinding hb : this._bindingHeaderMatchers) {
            if (!hb.matches(Filterable.Factory.newInstance(payload, instanceProperties))) continue;
            Binding<?> b = hb.getBinding();
            b.incrementMatches();
            if (_logger.isDebugEnabled()) {
                _logger.debug("Exchange " + this.getName() + ": delivering message with headers " + payload.getMessageHeader() + " to " + b.getQueue().getName());
            }
            queues.add(b.getQueue());
        }
        return new ArrayList<BaseQueue>(queues);
    }

    @Override
    protected void onBind(Binding<?> binding) {
        CopyOnWriteArraySet newBindings;
        String bindingKey = binding.getBindingKey();
        Queue<?> queue = binding.getQueue();
        assert (queue != null);
        assert (bindingKey != null);
        CopyOnWriteArraySet bindings = (CopyOnWriteArraySet)this._bindingsByKey.get(bindingKey);
        if (bindings == null && (newBindings = this._bindingsByKey.putIfAbsent(bindingKey, bindings = new CopyOnWriteArraySet())) != null) {
            bindings = newBindings;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("Exchange " + this.getName() + ": Binding " + queue.getName() + " with binding key '" + bindingKey + "' and args: " + binding.getArguments());
        }
        this._bindingHeaderMatchers.add(new HeadersBinding(binding));
        bindings.add(binding);
    }

    @Override
    protected void onBindingUpdated(Binding<?> binding, Map<String, Object> oldArguments) {
        HeadersBinding headersBinding = new HeadersBinding(binding);
        ListIterator<HeadersBinding> iter = this._bindingHeaderMatchers.listIterator();
        while (iter.hasNext()) {
            if (!iter.next().equals(headersBinding)) continue;
            iter.set(headersBinding);
        }
    }

    @Override
    protected void onUnbind(Binding<?> binding) {
        assert (binding != null);
        CopyOnWriteArraySet bindings = (CopyOnWriteArraySet)this._bindingsByKey.get(binding.getBindingKey());
        if (bindings != null) {
            bindings.remove(binding);
        }
        boolean removedBinding = this._bindingHeaderMatchers.remove(new HeadersBinding(binding));
        _logger.debug("Removing Binding: {}", (Object)removedBinding);
    }
}

