/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.filter.AMQInvalidArgumentException;
import org.apache.qpid.server.filter.FilterManager;
import org.apache.qpid.server.filter.FilterSupport;
import org.apache.qpid.server.filter.Filterable;
import org.apache.qpid.server.filter.MessageFilter;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.model.Binding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HeadersBinding {
    private static final Logger _logger = LoggerFactory.getLogger(HeadersBinding.class);
    private final Map<String, Object> _mappings;
    private final Binding<?> _binding;
    private final Set<String> required = new HashSet<String>();
    private final Map<String, Object> matches = new HashMap<String, Object>();
    private boolean matchAny;
    private FilterManager _filter;

    public HeadersBinding(Binding<?> binding) {
        this._binding = binding;
        if (this._binding != null) {
            Map<String, Object> arguments = this._binding.getArguments();
            this._mappings = arguments == null ? Collections.emptyMap() : arguments;
            this.initMappings();
        } else {
            this._mappings = null;
        }
    }

    private void initMappings() {
        if (FilterSupport.argumentsContainFilter(this._mappings)) {
            try {
                this._filter = FilterSupport.createMessageFilter(this._mappings, this._binding.getQueue());
            }
            catch (AMQInvalidArgumentException e) {
                _logger.warn("Invalid filter in binding queue '" + this._binding.getQueue().getName() + "' to exchange '" + this._binding.getExchange().getName() + "' with arguments: " + this._binding.getArguments());
                this._filter = new FilterManager();
                this._filter.add("x-exclude-all", new ExcludeAllFilter());
            }
        }
        for (Map.Entry<String, Object> entry : this._mappings.entrySet()) {
            String propertyName = entry.getKey();
            Object value = entry.getValue();
            if (HeadersBinding.isSpecial(propertyName)) {
                this.processSpecial(propertyName, value);
                continue;
            }
            if (value == null || value.equals("")) {
                this.required.add(propertyName);
                continue;
            }
            this.matches.put(propertyName, value);
        }
    }

    public Binding<?> getBinding() {
        return this._binding;
    }

    public boolean matches(AMQMessageHeader headers) {
        if (headers == null) {
            return this.required.isEmpty() && this.matches.isEmpty();
        }
        return this.matchAny ? this.or(headers) : this.and(headers);
    }

    public boolean matches(Filterable message) {
        return this.matches(message.getMessageHeader()) && (this._filter == null || this._filter.allAllow(message));
    }

    private boolean and(AMQMessageHeader headers) {
        if (headers.containsHeaders(this.required)) {
            for (Map.Entry<String, Object> e : this.matches.entrySet()) {
                if (e.getValue().equals(headers.getHeader(e.getKey()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean or(AMQMessageHeader headers) {
        if (this.required.isEmpty()) {
            return this.matches.isEmpty() || this.passesMatchesOr(headers);
        }
        if (!this.passesRequiredOr(headers)) {
            return !this.matches.isEmpty() && this.passesMatchesOr(headers);
        }
        return true;
    }

    private boolean passesMatchesOr(AMQMessageHeader headers) {
        for (Map.Entry<String, Object> entry : this.matches.entrySet()) {
            if (!headers.containsHeader(entry.getKey()) || (entry.getValue() != null || headers.getHeader(entry.getKey()) != null) && !entry.getValue().equals(headers.getHeader(entry.getKey()))) continue;
            return true;
        }
        return false;
    }

    private boolean passesRequiredOr(AMQMessageHeader headers) {
        for (String name : this.required) {
            if (!headers.containsHeader(name)) continue;
            return true;
        }
        return false;
    }

    private void processSpecial(String key, Object value) {
        if ("X-match".equalsIgnoreCase(key)) {
            this.matchAny = this.isAny(value);
        } else {
            _logger.warn("Ignoring special header: " + key);
        }
    }

    private boolean isAny(Object value) {
        if (value instanceof String) {
            if ("any".equalsIgnoreCase((String)value)) {
                return true;
            }
            if ("all".equalsIgnoreCase((String)value)) {
                return false;
            }
        }
        _logger.warn("Ignoring unrecognised match type: " + value);
        return false;
    }

    static boolean isSpecial(Object key) {
        return key instanceof String && HeadersBinding.isSpecial((String)key);
    }

    static boolean isSpecial(String key) {
        return key.startsWith("X-") || key.startsWith("x-");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof HeadersBinding)) {
            return false;
        }
        HeadersBinding hb = (HeadersBinding)o;
        return !(this._binding == null ? hb.getBinding() != null : !this._binding.equals(hb.getBinding()));
    }

    public int hashCode() {
        return this._binding == null ? 0 : this._binding.hashCode();
    }

    private static class ExcludeAllFilter
    implements MessageFilter {
        private ExcludeAllFilter() {
        }

        @Override
        public String getName() {
            return "";
        }

        @Override
        public boolean startAtTail() {
            return false;
        }

        @Override
        public boolean matches(Filterable message) {
            return false;
        }

        public String toString() {
            return "ExcludeAllFilter[]";
        }
    }
}

