/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.qpid.server.exchange.AbstractExchange;
import org.apache.qpid.server.filter.AMQInvalidArgumentException;
import org.apache.qpid.server.filter.FilterManager;
import org.apache.qpid.server.filter.FilterSupport;
import org.apache.qpid.server.filter.Filterable;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.Binding;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.queue.BaseQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(category=false, type="fanout")
public class FanoutExchange
extends AbstractExchange<FanoutExchange> {
    private static final Logger _logger = LoggerFactory.getLogger(FanoutExchange.class);
    private static final Integer ONE = 1;
    private final Map<Queue<?>, Integer> _queues = new HashMap();
    private final CopyOnWriteArrayList<Queue<?>> _unfilteredQueues = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<Queue<?>> _filteredQueues = new CopyOnWriteArrayList();
    private final AtomicReference<Map<Queue<?>, Map<Binding<?>, FilterManager>>> _filteredBindings = new AtomicReference();

    @ManagedObjectFactoryConstructor
    public FanoutExchange(Map<String, Object> attributes, VirtualHost<?> vhost) {
        super(attributes, vhost);
        Map emptyMap = Collections.emptyMap();
        this._filteredBindings.set(emptyMap);
    }

    public ArrayList<BaseQueue> doRoute(ServerMessage payload, String routingKey, InstanceProperties instanceProperties) {
        for (Binding<?> b : this.getBindings()) {
            b.incrementMatches();
        }
        ArrayList<BaseQueue> result = new ArrayList<BaseQueue>(this._unfilteredQueues);
        Map<Queue<?>, Map<Binding<?>, FilterManager>> filteredBindings = this._filteredBindings.get();
        if (!this._filteredQueues.isEmpty()) {
            block1: for (Queue<?> q : this._filteredQueues) {
                Map<Binding<?>, FilterManager> bindingMessageFilterMap = filteredBindings.get(q);
                if (bindingMessageFilterMap == null || result.contains(q)) continue;
                for (FilterManager filter : bindingMessageFilterMap.values()) {
                    if (!filter.allAllow(Filterable.Factory.newInstance(payload, instanceProperties))) continue;
                    result.add(q);
                    continue block1;
                }
            }
        }
        _logger.debug("Publishing message to queue {}", result);
        return result;
    }

    @Override
    protected synchronized void onBindingUpdated(Binding<?> binding, Map<String, Object> oldArguments) {
        Queue<?> queue = binding.getQueue();
        if (binding.getArguments() == null || binding.getArguments().isEmpty() || !FilterSupport.argumentsContainFilter(binding.getArguments())) {
            if (oldArguments != null && !oldArguments.isEmpty() && FilterSupport.argumentsContainFilter(oldArguments)) {
                this._unfilteredQueues.add(queue);
                if (this._queues.containsKey(queue)) {
                    this._queues.put(queue, this._queues.get(queue) + 1);
                } else {
                    this._queues.put(queue, ONE);
                }
                this._filteredQueues.remove(queue);
            }
        } else {
            HashMap<Object, Object> bindingsForQueue;
            FilterManager messageFilter;
            HashMap filteredBindings = new HashMap(this._filteredBindings.get());
            try {
                messageFilter = FilterSupport.createMessageFilter(binding.getArguments(), binding.getQueue());
            }
            catch (AMQInvalidArgumentException e) {
                _logger.warn("Cannot bind queue " + queue + " to exchange this " + this + " because selector cannot be parsed.", (Throwable)e);
                return;
            }
            if (oldArguments != null && !oldArguments.isEmpty() && FilterSupport.argumentsContainFilter(oldArguments)) {
                bindingsForQueue = new HashMap(filteredBindings.remove(binding.getQueue()));
            } else {
                bindingsForQueue = new HashMap();
                Integer oldValue = this._queues.remove(queue);
                if (ONE.equals(oldValue)) {
                    this._filteredQueues.add(queue);
                    this._unfilteredQueues.remove(queue);
                } else {
                    this._queues.put(queue, oldValue - 1);
                }
            }
            bindingsForQueue.put(binding, messageFilter);
            filteredBindings.put(binding.getQueue(), bindingsForQueue);
            this._filteredBindings.set(filteredBindings);
        }
    }

    @Override
    protected synchronized void onBind(Binding<?> binding) {
        Queue<?> queue = binding.getQueue();
        assert (queue != null);
        if (binding.getArguments() == null || binding.getArguments().isEmpty() || !FilterSupport.argumentsContainFilter(binding.getArguments())) {
            if (this._queues.containsKey(queue)) {
                this._queues.put(queue, this._queues.get(queue) + 1);
            } else {
                this._queues.put(queue, ONE);
                this._unfilteredQueues.add(queue);
                this._filteredQueues.remove(queue);
            }
        } else {
            try {
                HashMap filteredBindings = new HashMap(this._filteredBindings.get());
                Map<Binding<?>, FilterManager> bindingsForQueue = filteredBindings.remove(binding.getQueue());
                FilterManager messageFilter = FilterSupport.createMessageFilter(binding.getArguments(), binding.getQueue());
                if (bindingsForQueue != null) {
                    bindingsForQueue = new HashMap(bindingsForQueue);
                    bindingsForQueue.put(binding, messageFilter);
                } else {
                    bindingsForQueue = Collections.singletonMap(binding, messageFilter);
                    if (!this._unfilteredQueues.contains(queue)) {
                        this._filteredQueues.add(queue);
                    }
                }
                filteredBindings.put(binding.getQueue(), bindingsForQueue);
                this._filteredBindings.set(filteredBindings);
            }
            catch (AMQInvalidArgumentException e) {
                _logger.warn("Cannot bind queue " + queue + " to exchange this " + this + " because selector cannot be parsed.", (Throwable)e);
                return;
            }
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("Binding queue " + queue + " with routing key " + binding.getBindingKey() + " to exchange " + this);
        }
    }

    @Override
    protected synchronized void onUnbind(Binding<?> binding) {
        Queue<?> queue = binding.getQueue();
        if (binding.getArguments() == null || binding.getArguments().isEmpty() || !FilterSupport.argumentsContainFilter(binding.getArguments())) {
            Integer oldValue = this._queues.remove(queue);
            if (ONE.equals(oldValue)) {
                if (this._filteredBindings.get().containsKey(queue)) {
                    this._filteredQueues.add(queue);
                }
                this._unfilteredQueues.remove(queue);
            } else {
                this._queues.put(queue, oldValue - 1);
            }
        } else {
            HashMap filteredBindings = new HashMap(this._filteredBindings.get());
            Map<Binding<?>, FilterManager> bindingsForQueue = filteredBindings.remove(binding.getQueue());
            if (bindingsForQueue.size() > 1) {
                bindingsForQueue = new HashMap(bindingsForQueue);
                bindingsForQueue.remove(binding);
                filteredBindings.put(binding.getQueue(), bindingsForQueue);
            } else {
                this._filteredQueues.remove(queue);
            }
            this._filteredBindings.set(filteredBindings);
        }
    }
}

