/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.qpid.server.exchange.AbstractExchange;
import org.apache.qpid.server.filter.AMQInvalidArgumentException;
import org.apache.qpid.server.filter.FilterManager;
import org.apache.qpid.server.filter.FilterSupport;
import org.apache.qpid.server.filter.Filterable;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.Binding;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.queue.BaseQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(category=false, type="direct")
public class DirectExchange
extends AbstractExchange<DirectExchange> {
    private static final Logger _logger = LoggerFactory.getLogger(DirectExchange.class);
    private final ConcurrentMap<String, BindingSet> _bindingsByKey = new ConcurrentHashMap<String, BindingSet>();

    @ManagedObjectFactoryConstructor
    public DirectExchange(Map<String, Object> attributes, VirtualHost<?> vhost) {
        super(attributes, vhost);
    }

    @Override
    public List<? extends BaseQueue> doRoute(ServerMessage payload, String routingKey, InstanceProperties instanceProperties) {
        BindingSet bindings = (BindingSet)this._bindingsByKey.get(routingKey == null ? "" : routingKey);
        if (bindings != null) {
            List<BaseQueue> queues = bindings.getUnfilteredQueues();
            if (bindings.hasFilteredQueues()) {
                HashSet<BaseQueue> queuesSet = new HashSet<BaseQueue>(queues);
                Filterable filterable = Filterable.Factory.newInstance(payload, instanceProperties);
                Map<BaseQueue, FilterManager> filteredQueues = bindings.getFilteredQueues();
                for (Map.Entry<BaseQueue, FilterManager> entry : filteredQueues.entrySet()) {
                    FilterManager filter;
                    if (queuesSet.contains(entry.getKey()) || !(filter = entry.getValue()).allAllow(filterable)) continue;
                    queuesSet.add(entry.getKey());
                }
                if (queues.size() != queuesSet.size()) {
                    queues = new ArrayList<BaseQueue>(queuesSet);
                }
            }
            return queues;
        }
        return Collections.emptyList();
    }

    @Override
    protected void onBindingUpdated(Binding<?> binding, Map<String, Object> oldArguments) {
        String bindingKey = binding.getBindingKey();
        Queue<?> queue = binding.getQueue();
        assert (queue != null);
        assert (bindingKey != null);
        BindingSet bindings = (BindingSet)this._bindingsByKey.get(bindingKey);
        bindings.updateBinding(binding);
    }

    @Override
    protected void onBind(Binding<?> binding) {
        BindingSet newBindings;
        String bindingKey = binding.getBindingKey();
        Queue<?> queue = binding.getQueue();
        assert (queue != null);
        assert (bindingKey != null);
        BindingSet bindings = (BindingSet)this._bindingsByKey.get(bindingKey);
        if (bindings == null && (newBindings = this._bindingsByKey.putIfAbsent(bindingKey, bindings = new BindingSet())) != null) {
            bindings = newBindings;
        }
        bindings.addBinding(binding);
    }

    @Override
    protected void onUnbind(Binding<?> binding) {
        assert (binding != null);
        BindingSet bindings = (BindingSet)this._bindingsByKey.get(binding.getBindingKey());
        if (bindings != null) {
            bindings.removeBinding(binding);
        }
    }

    private static final class BindingSet {
        private CopyOnWriteArraySet<Binding<?>> _bindings = new CopyOnWriteArraySet();
        private List<BaseQueue> _unfilteredQueues = new ArrayList<BaseQueue>();
        private Map<BaseQueue, FilterManager> _filteredQueues = new HashMap<BaseQueue, FilterManager>();

        private BindingSet() {
        }

        public synchronized void addBinding(Binding<?> binding) {
            this._bindings.add(binding);
            this.recalculateQueues();
        }

        public synchronized void removeBinding(Binding<?> binding) {
            this._bindings.remove(binding);
            this.recalculateQueues();
        }

        public synchronized void updateBinding(Binding<?> binding) {
            this.recalculateQueues();
        }

        private void recalculateQueues() {
            ArrayList<BaseQueue> queues = new ArrayList<BaseQueue>(this._bindings.size());
            HashMap<BaseQueue, FilterManager> filteredQueues = new HashMap<BaseQueue, FilterManager>();
            for (Binding<?> b : this._bindings) {
                if (FilterSupport.argumentsContainFilter(b.getArguments())) {
                    try {
                        FilterManager filter = FilterSupport.createMessageFilter(b.getArguments(), b.getQueue());
                        filteredQueues.put(b.getQueue(), filter);
                    }
                    catch (AMQInvalidArgumentException e) {
                        _logger.warn("Binding ignored: cannot parse filter on binding of queue '" + b.getQueue().getName() + "' to exchange '" + b.getExchange().getName() + "' with arguments: " + b.getArguments(), (Throwable)e);
                    }
                    continue;
                }
                if (queues.contains(b.getQueue())) continue;
                queues.add(b.getQueue());
            }
            this._unfilteredQueues = queues;
            this._filteredQueues = filteredQueues;
        }

        public List<BaseQueue> getUnfilteredQueues() {
            return this._unfilteredQueues;
        }

        public CopyOnWriteArraySet<Binding<?>> getBindings() {
            return this._bindings;
        }

        public boolean hasFilteredQueues() {
            return !this._filteredQueues.isEmpty();
        }

        public Map<BaseQueue, FilterManager> getFilteredQueues() {
            return this._filteredQueues;
        }
    }
}

