/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import java.security.AccessControlException;
import java.util.Map;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.PermissionedObject;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.security.AccessControl;
import org.apache.qpid.server.security.Result;
import org.apache.qpid.server.security.SecurityToken;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.util.Action;

public class DefaultDestination
implements MessageDestination,
PermissionedObject {
    private static final Operation PUBLISH_ACTION = Operation.ACTION("publish");
    private final AccessControl _accessControl;
    private VirtualHost<?> _virtualHost;

    public DefaultDestination(VirtualHost<?> virtualHost, AccessControl accessControl) {
        this._virtualHost = virtualHost;
        this._accessControl = accessControl;
    }

    @Override
    public Class<? extends ConfiguredObject> getCategoryClass() {
        return Exchange.class;
    }

    @Override
    public NamedAddressSpace getAddressSpace() {
        return this._virtualHost;
    }

    @Override
    public void authorisePublish(SecurityToken token, Map<String, Object> arguments) throws AccessControlException {
        if (this._accessControl != null) {
            Result result = this._accessControl.authorise(token, PUBLISH_ACTION, this, arguments);
            if (result == Result.DEFER) {
                result = this._accessControl.getDefault();
            }
            if (result == Result.DENIED) {
                throw new AccessControlException("Access denied to publish to default exchange with arguments: " + arguments);
            }
        }
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public final <M extends ServerMessage<? extends StorableMessageMetaData>> int send(M message, String routingAddress, InstanceProperties instanceProperties, ServerTransaction txn, Action<? super MessageInstance> postEnqueueAction) {
        if (routingAddress == null || routingAddress.trim().equals("")) {
            return 0;
        }
        MessageDestination dest = this._virtualHost.getAttainedMessageDestination(routingAddress);
        if (dest == null) {
            Exchange exchange;
            if ((routingAddress = this._virtualHost.getLocalAddress(routingAddress)).contains("/") && !routingAddress.startsWith("/")) {
                String[] parts = routingAddress.split("/", 2);
                Exchange exchange2 = this._virtualHost.getAttainedChildFromAddress(Exchange.class, parts[0]);
                if (exchange2 != null) {
                    return exchange2.send(message, parts[1], instanceProperties, txn, postEnqueueAction);
                }
            } else if (!routingAddress.contains("/") && (exchange = this._virtualHost.getAttainedChildFromAddress(Exchange.class, routingAddress)) != null) {
                return exchange.send(message, "", instanceProperties, txn, postEnqueueAction);
            }
            return 0;
        }
        return dest.send(message, routingAddress, instanceProperties, txn, postEnqueueAction);
    }
}

