/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.security.AccessControlException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.Subject;
import org.apache.qpid.server.binding.BindingImpl;
import org.apache.qpid.server.configuration.updater.Task;
import org.apache.qpid.server.exchange.ExchangeReferrer;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.logging.messages.ExchangeMessages;
import org.apache.qpid.server.logging.subjects.ExchangeLogSubject;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.message.MessageReference;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.Binding;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.Publisher;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.security.SecurityToken;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.store.MessageEnqueueRecord;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.virtualhost.ExchangeIsAlternateException;
import org.apache.qpid.server.virtualhost.RequiredExchangeException;
import org.apache.qpid.server.virtualhost.ReservedExchangeNameException;
import org.apache.qpid.server.virtualhost.VirtualHostUnavailableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExchange<T extends AbstractExchange<T>>
extends AbstractConfiguredObject<T>
implements Exchange<T> {
    private static final Logger _logger = LoggerFactory.getLogger(AbstractExchange.class);
    private static final Operation PUBLISH_ACTION = Operation.ACTION("publish");
    private final AtomicBoolean _closed = new AtomicBoolean();
    @ManagedAttributeField(beforeSet="preSetAlternateExchange", afterSet="postSetAlternateExchange")
    private Exchange<?> _alternateExchange;
    @ManagedAttributeField
    private Exchange.UnroutableMessageBehaviour _unroutableMessageBehaviour;
    private VirtualHost<?> _virtualHost;
    private boolean _autoDelete;
    private LogSubject _logSubject;
    private Map<ExchangeReferrer, Object> _referrers = new ConcurrentHashMap<ExchangeReferrer, Object>();
    private final CopyOnWriteArrayList<Binding<?>> _bindings = new CopyOnWriteArrayList();
    private final AtomicLong _receivedMessageCount = new AtomicLong();
    private final AtomicLong _receivedMessageSize = new AtomicLong();
    private final AtomicLong _routedMessageCount = new AtomicLong();
    private final AtomicLong _routedMessageSize = new AtomicLong();
    private final AtomicLong _droppedMessageCount = new AtomicLong();
    private final AtomicLong _droppedMessageSize = new AtomicLong();
    private final ConcurrentMap<BindingIdentifier, Binding<?>> _bindingsMap = new ConcurrentHashMap();

    public AbstractExchange(Map<String, Object> attributes, VirtualHost<?> vhost) {
        super(AbstractExchange.parentsMap(vhost), attributes);
        HashSet<String> providedAttributeNames = new HashSet<String>(attributes.keySet());
        providedAttributeNames.removeAll(this.getAttributeNames());
        if (!providedAttributeNames.isEmpty()) {
            throw new IllegalArgumentException("Unknown attributes provided: " + providedAttributeNames);
        }
        this._virtualHost = vhost;
        this._logSubject = new ExchangeLogSubject(this, this.getVirtualHost());
    }

    @Override
    public void onValidate() {
        super.onValidate();
        if (!this.isSystemProcess() && this.isReservedExchangeName(this.getName())) {
            throw new ReservedExchangeNameException(this.getName());
        }
    }

    private boolean isReservedExchangeName(String name) {
        return name == null || "".equals(name) || name.startsWith("amq.") || name.startsWith("qpid.");
    }

    @Override
    protected void onOpen() {
        super.onOpen();
        this.getEventLogger().message(ExchangeMessages.CREATED(this.getType(), this.getName(), this.isDurable()));
    }

    @Override
    public EventLogger getEventLogger() {
        return this._virtualHost.getEventLogger();
    }

    @Override
    public boolean isAutoDelete() {
        return this.getLifetimePolicy() != LifetimePolicy.PERMANENT;
    }

    private ListenableFuture<Void> deleteWithChecks() {
        if (this.hasReferrers()) {
            throw new ExchangeIsAlternateException(this.getName());
        }
        if (this.isReservedExchangeName(this.getName())) {
            throw new RequiredExchangeException(this.getName());
        }
        if (this._closed.compareAndSet(false, true)) {
            final ArrayList removeBindingFutures = new ArrayList(this._bindings.size());
            final ArrayList bindings = new ArrayList(this._bindings);
            Subject.doAs(this.getSubjectWithAddedSystemRights(), new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    for (Binding binding : bindings) {
                        removeBindingFutures.add(binding.deleteAsync());
                    }
                    return null;
                }
            });
            ListenableFuture combinedFuture = Futures.allAsList(removeBindingFutures);
            return this.doAfter(combinedFuture, new Runnable(){

                @Override
                public void run() {
                    if (AbstractExchange.this._alternateExchange != null) {
                        AbstractExchange.this._alternateExchange.removeReference(AbstractExchange.this);
                    }
                    AbstractExchange.this.getEventLogger().message(AbstractExchange.this._logSubject, ExchangeMessages.DELETED());
                    AbstractExchange.this.deleted();
                }
            });
        }
        this.deleted();
        return Futures.immediateFuture(null);
    }

    @Override
    public Exchange.UnroutableMessageBehaviour getUnroutableMessageBehaviour() {
        return this._unroutableMessageBehaviour;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }

    public VirtualHost<?> getVirtualHost() {
        return this._virtualHost;
    }

    @Override
    public final boolean isBound(String bindingKey, Map<String, Object> arguments, Queue<?> queue) {
        for (Binding<?> b : this._bindings) {
            if (!bindingKey.equals(b.getBindingKey()) || queue != b.getQueue()) continue;
            return b.getArguments() == null || b.getArguments().isEmpty() ? arguments == null || arguments.isEmpty() : b.getArguments().equals(arguments);
        }
        return false;
    }

    @Override
    public final boolean isBound(String bindingKey, Queue<?> queue) {
        for (Binding<?> b : this._bindings) {
            if (!bindingKey.equals(b.getBindingKey()) || queue != b.getQueue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean isBound(String bindingKey) {
        for (Binding<?> b : this._bindings) {
            if (!bindingKey.equals(b.getBindingKey())) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean isBound(Queue<?> queue) {
        for (Binding<?> b : this._bindings) {
            if (queue != b.getQueue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean isBound(Map<String, Object> arguments, Queue<?> queue) {
        for (Binding<?> b : this._bindings) {
            if (queue != b.getQueue() || !(b.getArguments() == null || b.getArguments().isEmpty() ? arguments == null || arguments.isEmpty() : b.getArguments().equals(arguments))) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean isBound(Map<String, Object> arguments) {
        for (Binding<?> b : this._bindings) {
            if (!(b.getArguments() == null || b.getArguments().isEmpty() ? arguments == null || arguments.isEmpty() : b.getArguments().equals(arguments))) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean isBound(String bindingKey, Map<String, Object> arguments) {
        for (Binding<?> b : this._bindings) {
            if (!b.getBindingKey().equals(bindingKey) || !(b.getArguments() == null || b.getArguments().isEmpty() ? arguments == null || arguments.isEmpty() : b.getArguments().equals(arguments))) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean hasBindings() {
        return !this._bindings.isEmpty();
    }

    @Override
    public Exchange<?> getAlternateExchange() {
        return this._alternateExchange;
    }

    private void preSetAlternateExchange() {
        if (this._alternateExchange != null) {
            this._alternateExchange.removeReference(this);
        }
    }

    private void postSetAlternateExchange() {
        if (this._alternateExchange != null) {
            this._alternateExchange.addReference(this);
        }
    }

    @Override
    public void removeReference(ExchangeReferrer exchange) {
        this._referrers.remove(exchange);
    }

    @Override
    public void addReference(ExchangeReferrer exchange) {
        this._referrers.put(exchange, Boolean.TRUE);
    }

    @Override
    public boolean hasReferrers() {
        return !this._referrers.isEmpty();
    }

    public final void doAddBinding(BindingImpl binding) {
        this._bindings.add(binding);
        this.onBind(binding);
    }

    public final void doRemoveBinding(Binding<?> binding) {
        this.onUnbind(binding);
        this._bindings.remove(binding);
    }

    @Override
    public final Collection<Binding<?>> getBindings() {
        return Collections.unmodifiableList(this._bindings);
    }

    protected abstract void onBind(Binding<?> var1);

    protected abstract void onUnbind(Binding<?> var1);

    public Map<String, Object> getArguments() {
        return Collections.emptyMap();
    }

    @Override
    public long getBindingCount() {
        return this.getBindings().size();
    }

    final List<? extends BaseQueue> route(ServerMessage message, String routingAddress, InstanceProperties instanceProperties) {
        List<BaseQueue> queues;
        this._receivedMessageCount.incrementAndGet();
        this._receivedMessageSize.addAndGet(message.getSize());
        List<BaseQueue> allQueues = queues = this.doRoute(message, routingAddress, instanceProperties);
        boolean deletedQueues = false;
        for (BaseQueue q : allQueues) {
            if (!q.isDeleted()) continue;
            if (!deletedQueues) {
                deletedQueues = true;
                queues = new ArrayList<BaseQueue>(allQueues);
            }
            _logger.debug("Exchange: {} - attempt to enqueue message onto deleted queue {}", (Object)this.getName(), (Object)q.getName());
            queues.remove(q);
        }
        if (!queues.isEmpty()) {
            this._routedMessageCount.incrementAndGet();
            this._routedMessageSize.addAndGet(message.getSize());
        } else {
            this._droppedMessageCount.incrementAndGet();
            this._droppedMessageSize.addAndGet(message.getSize());
        }
        return queues;
    }

    @Override
    public final <M extends ServerMessage<? extends StorableMessageMetaData>> int send(final M message, String routingAddress, InstanceProperties instanceProperties, ServerTransaction txn, final Action<? super MessageInstance> postEnqueueAction) {
        BaseQueue[] baseQueues;
        if (this._virtualHost.getState() != State.ACTIVE) {
            throw new VirtualHostUnavailableException(this._virtualHost);
        }
        List<BaseQueue> queues = this.route(message, routingAddress, instanceProperties);
        if (queues == null || queues.isEmpty()) {
            Exchange<?> altExchange = this.getAlternateExchange();
            if (altExchange != null) {
                return altExchange.send(message, routingAddress, instanceProperties, txn, postEnqueueAction);
            }
            return 0;
        }
        if (message.isReferenced()) {
            ArrayList<BaseQueue> uniqueQueues = new ArrayList<BaseQueue>(queues.size());
            for (BaseQueue q : queues) {
                if (message.isReferenced(q)) continue;
                uniqueQueues.add(q);
            }
            baseQueues = uniqueQueues.toArray(new BaseQueue[uniqueQueues.size()]);
            queues = uniqueQueues;
        } else {
            baseQueues = queues.toArray(new BaseQueue[queues.size()]);
        }
        txn.enqueue(queues, message, new ServerTransaction.EnqueueAction(){
            MessageReference _reference;
            {
                this._reference = message.newReference();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void postCommit(MessageEnqueueRecord ... records) {
                try {
                    for (int i = 0; i < baseQueues.length; ++i) {
                        baseQueues[i].enqueue(message, postEnqueueAction, records[i]);
                    }
                }
                finally {
                    this._reference.release();
                }
            }

            @Override
            public void onRollback() {
                this._reference.release();
            }
        });
        return queues.size();
    }

    protected abstract List<? extends BaseQueue> doRoute(ServerMessage var1, String var2, InstanceProperties var3);

    @Override
    public long getMessagesIn() {
        return this._receivedMessageCount.get();
    }

    public long getMsgRoutes() {
        return this._routedMessageCount.get();
    }

    @Override
    public long getMessagesDropped() {
        return this._droppedMessageCount.get();
    }

    @Override
    public long getBytesIn() {
        return this._receivedMessageSize.get();
    }

    public long getByteRoutes() {
        return this._routedMessageSize.get();
    }

    @Override
    public long getBytesDropped() {
        return this._droppedMessageSize.get();
    }

    @Override
    public boolean addBinding(final String bindingKey, final Queue<?> queue, final Map<String, Object> arguments) {
        return this.doSync(this.doOnConfigThread(new Task<ListenableFuture<Boolean>, RuntimeException>(){

            @Override
            public ListenableFuture<Boolean> execute() {
                return AbstractExchange.this.makeBindingAsync(null, bindingKey, queue, arguments, false);
            }

            @Override
            public String getObject() {
                return AbstractExchange.this.toString();
            }

            @Override
            public String getAction() {
                return "add binding";
            }

            @Override
            public String getArguments() {
                return "bindingKey=" + bindingKey + ", queue=" + queue + ", arguments=" + arguments;
            }
        }));
    }

    @Override
    public boolean replaceBinding(final String bindingKey, final Queue<?> queue, final Map<String, Object> arguments) {
        return this.doSync(this.doOnConfigThread(new Task<ListenableFuture<Boolean>, RuntimeException>(){

            @Override
            public ListenableFuture<Boolean> execute() {
                Binding<?> existingBinding = AbstractExchange.this.getBinding(bindingKey, queue);
                return AbstractExchange.this.makeBindingAsync(existingBinding == null ? null : existingBinding.getId(), bindingKey, queue, arguments, true);
            }

            @Override
            public String getObject() {
                return AbstractExchange.this.toString();
            }

            @Override
            public String getAction() {
                return "replace binding";
            }

            @Override
            public String getArguments() {
                return "bindingKey=" + bindingKey + ", queue=" + queue + ", arguments=" + arguments;
            }
        }));
    }

    @Override
    public ListenableFuture<Void> removeBindingAsync(Binding<?> binding) {
        String bindingKey = binding.getBindingKey();
        Queue<?> queue = binding.getQueue();
        assert (queue != null);
        if (bindingKey == null) {
            bindingKey = "";
        }
        binding.authorise(Operation.DELETE);
        Binding b = (Binding)this._bindingsMap.remove(new BindingIdentifier(bindingKey, queue));
        if (b != null) {
            this.doRemoveBinding(b);
            queue.removeBinding(b);
            return this.autoDeleteIfNecessaryAsync();
        }
        return Futures.immediateFuture(null);
    }

    private ListenableFuture<Void> autoDeleteIfNecessaryAsync() {
        if (this.isAutoDeletePending()) {
            _logger.debug("Auto-deleting exchange: {}", (Object)this);
            return this.deleteAsync();
        }
        return Futures.immediateFuture(null);
    }

    private void autoDeleteIfNecessary() {
        if (this.isAutoDeletePending()) {
            _logger.debug("Auto-deleting exchange: {}", (Object)this);
            this.delete();
        }
    }

    private boolean isAutoDeletePending() {
        return (this.getLifetimePolicy() == LifetimePolicy.DELETE_ON_NO_OUTBOUND_LINKS || this.getLifetimePolicy() == LifetimePolicy.DELETE_ON_NO_LINKS) && this.getBindingCount() == 0L;
    }

    public Binding<?> getBinding(String bindingKey, Queue<?> queue) {
        assert (queue != null);
        if (bindingKey == null) {
            bindingKey = "";
        }
        return (Binding)this._bindingsMap.get(new BindingIdentifier(bindingKey, queue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListenableFuture<Boolean> makeBindingAsync(UUID id, String bindingKey, Queue<?> queue, Map<String, Object> arguments, boolean force) {
        if (bindingKey == null) {
            bindingKey = "";
        }
        if (arguments == null) {
            arguments = Collections.emptyMap();
        }
        if (id == null) {
            id = UUID.randomUUID();
        }
        AbstractExchange abstractExchange = this;
        synchronized (abstractExchange) {
            BindingIdentifier bindingIdentifier = new BindingIdentifier(bindingKey, queue);
            Binding existingMapping = (Binding)this._bindingsMap.get(bindingIdentifier);
            if (existingMapping == null) {
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                attributes.put("name", bindingKey);
                attributes.put("id", id);
                attributes.put("arguments", arguments);
                final BindingImpl b = new BindingImpl(attributes, queue, this);
                final SettableFuture returnVal = SettableFuture.create();
                AbstractExchange.addFutureCallback(b.createAsync(), new FutureCallback<Void>(){

                    public void onSuccess(Void result) {
                        try {
                            AbstractExchange.this.addBinding(b);
                            returnVal.set((Object)true);
                        }
                        catch (Throwable t) {
                            returnVal.setException(t);
                        }
                    }

                    public void onFailure(Throwable t) {
                        returnVal.setException(t);
                    }
                }, this.getTaskExecutor());
                return returnVal;
            }
            if (force) {
                Map<String, Object> oldArguments = existingMapping.getArguments();
                ((BindingImpl)existingMapping).setArguments(arguments);
                this.onBindingUpdated(existingMapping, oldArguments);
                return Futures.immediateFuture((Object)true);
            }
            return Futures.immediateFuture((Object)false);
        }
    }

    @Override
    public void addBinding(Binding<?> b) {
        BindingIdentifier identifier = new BindingIdentifier(b.getName(), b.getQueue());
        this._bindingsMap.put(identifier, b);
        b.getQueue().addBinding(b);
        this.childAdded(b);
    }

    protected abstract void onBindingUpdated(Binding<?> var1, Map<String, Object> var2);

    @StateTransition(currentState={State.UNINITIALIZED, State.ERRORED}, desiredState=State.ACTIVE)
    private ListenableFuture<Void> activate() {
        this.setState(State.ACTIVE);
        return Futures.immediateFuture(null);
    }

    @StateTransition(currentState={State.UNINITIALIZED}, desiredState=State.DELETED)
    private ListenableFuture<Void> doDeleteBeforeInitialize() {
        this.preSetAlternateExchange();
        this.setState(State.DELETED);
        return Futures.immediateFuture(null);
    }

    @StateTransition(currentState={State.ACTIVE}, desiredState=State.DELETED)
    private ListenableFuture<Void> doDelete() {
        try {
            ListenableFuture<Void> removeExchangeFuture = this.deleteWithChecks();
            return this.doAfter(removeExchangeFuture, new Runnable(){

                @Override
                public void run() {
                    AbstractExchange.this.preSetAlternateExchange();
                    AbstractExchange.this.setState(State.DELETED);
                }
            });
        }
        catch (ExchangeIsAlternateException | RequiredExchangeException e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    @Override
    public <C extends ConfiguredObject> Collection<C> getChildren(Class<C> clazz) {
        if (Binding.class.isAssignableFrom(clazz)) {
            return this.getBindings();
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public Collection<Publisher> getPublishers() {
        return Collections.emptySet();
    }

    @Override
    public boolean deleteBinding(String bindingKey, Queue<?> queue) {
        Binding<?> binding = this.getBinding(bindingKey, queue);
        if (binding == null) {
            return false;
        }
        binding.delete();
        this.autoDeleteIfNecessary();
        return true;
    }

    @Override
    public boolean hasBinding(String bindingKey, Queue<?> queue) {
        return this.getBinding(bindingKey, queue) != null;
    }

    @Override
    public Binding createBinding(String bindingKey, Queue queue, Map<String, Object> bindingArguments, Map<String, Object> attributes) {
        this.addBinding(bindingKey, queue, bindingArguments);
        Binding<?> binding = this.getBinding(bindingKey, queue);
        return binding;
    }

    @Override
    public NamedAddressSpace getAddressSpace() {
        return this._virtualHost;
    }

    @Override
    public void authorisePublish(SecurityToken token, Map<String, Object> arguments) throws AccessControlException {
        this.authorise(token, PUBLISH_ACTION, arguments);
    }

    private static final class BindingIdentifier {
        private final String _bindingKey;
        private final Queue<?> _destination;

        private BindingIdentifier(String bindingKey, Queue<?> destination) {
            this._bindingKey = bindingKey;
            this._destination = destination;
        }

        public String getBindingKey() {
            return this._bindingKey;
        }

        public Queue<?> getDestination() {
            return this._destination;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BindingIdentifier that = (BindingIdentifier)o;
            if (!this._bindingKey.equals(that._bindingKey)) {
                return false;
            }
            return this._destination.equals(that._destination);
        }

        public int hashCode() {
            int result = this._bindingKey.hashCode();
            result = 31 * result + this._destination.hashCode();
            return result;
        }
    }

    private static interface BindingListener<X extends AbstractExchange<X>> {
        public void bindingAdded(AbstractExchange<X> var1, Binding<?> var2);

        public void bindingRemoved(AbstractExchange<X> var1, Binding<?> var2);
    }
}

