/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.consumer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.qpid.server.consumer.ConsumerImpl;
import org.apache.qpid.server.consumer.ConsumerMessageInstancePair;
import org.apache.qpid.server.consumer.ConsumerTarget;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.logging.messages.SubscriptionMessages;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.queue.SuspendedConsumerLoggingTicker;
import org.apache.qpid.server.transport.AMQPConnection;
import org.apache.qpid.server.util.StateChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConsumerTarget
implements ConsumerTarget,
LogSubject {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractConsumerTarget.class);
    protected static final String PULL_ONLY_CONSUMER = "x-pull-only";
    private final AtomicReference<ConsumerTarget.State> _state;
    private final Set<StateChangeListener<ConsumerTarget, ConsumerTarget.State>> _stateChangeListeners = new CopyOnWriteArraySet<StateChangeListener<ConsumerTarget, ConsumerTarget.State>>();
    private final Lock _stateChangeLock = new ReentrantLock();
    private final AtomicInteger _stateActivates = new AtomicInteger();
    private final boolean _isMultiQueue;
    private final SuspendedConsumerLoggingTicker _suspendedConsumerLoggingTicker;
    private ConcurrentLinkedQueue<ConsumerMessageInstancePair> _queue = new ConcurrentLinkedQueue();
    private final List<ConsumerImpl> _consumers = new CopyOnWriteArrayList<ConsumerImpl>();
    private final boolean _isPullOnly;
    private Iterator<ConsumerImpl> _pullIterator;

    protected AbstractConsumerTarget(ConsumerTarget.State initialState, boolean isPullOnly, boolean isMultiQueue, final AMQPConnection<?> amqpConnection) {
        this._state = new AtomicReference<ConsumerTarget.State>(initialState);
        this._isPullOnly = isPullOnly;
        this._isMultiQueue = isMultiQueue;
        this._suspendedConsumerLoggingTicker = isMultiQueue ? new SuspendedConsumerLoggingTicker(amqpConnection.getContextValue(Long.class, "consumer.suspendNotificationPeriod")){

            @Override
            protected void log(long period) {
                amqpConnection.getEventLogger().message(AbstractConsumerTarget.this, SubscriptionMessages.STATE(period));
            }
        } : null;
    }

    @Override
    public boolean isMultiQueue() {
        return this._isMultiQueue;
    }

    @Override
    public boolean processPending() {
        if (!this.getSessionModel().getAMQPConnection().isIOThread()) {
            return false;
        }
        if (this.sendNextMessage()) {
            return true;
        }
        this.processStateChanged();
        this.processClosed();
        return false;
    }

    @Override
    public boolean hasPendingWork() {
        return this.hasMessagesToSend() || this.hasStateChanged() || this.hasClosed();
    }

    protected abstract boolean hasStateChanged();

    protected abstract boolean hasClosed();

    protected abstract void processStateChanged();

    protected abstract void processClosed();

    @Override
    public void consumerAdded(ConsumerImpl sub) {
        this._consumers.add(sub);
    }

    @Override
    public void consumerRemoved(ConsumerImpl sub) {
        this._consumers.remove(sub);
        if (this._consumers.isEmpty()) {
            this.close();
        }
    }

    public List<ConsumerImpl> getConsumers() {
        return this._consumers;
    }

    @Override
    public final boolean isSuspended() {
        return this.getSessionModel().getAMQPConnection().isMessageAssignmentSuspended() || this.isFlowSuspended();
    }

    @Override
    public boolean hasCredit() {
        return !this.isFlowSuspended();
    }

    protected abstract boolean isFlowSuspended();

    @Override
    public final ConsumerTarget.State getState() {
        return this._state.get();
    }

    protected final boolean updateState(ConsumerTarget.State from, ConsumerTarget.State to) {
        if (this._state.compareAndSet(from, to)) {
            if (to == ConsumerTarget.State.ACTIVE && this._stateChangeListeners.size() > 1) {
                int offset = this._stateActivates.incrementAndGet();
                if (offset >= this._stateChangeListeners.size()) {
                    this._stateActivates.set(0);
                    offset = 0;
                }
                ArrayList<StateChangeListener<ConsumerTarget, ConsumerTarget.State>> holdovers = new ArrayList<StateChangeListener<ConsumerTarget, ConsumerTarget.State>>();
                int pos = 0;
                for (StateChangeListener<ConsumerTarget, ConsumerTarget.State> listener : this._stateChangeListeners) {
                    if (pos++ < offset) {
                        holdovers.add(listener);
                        continue;
                    }
                    listener.stateChanged(this, from, to);
                }
                for (StateChangeListener<ConsumerTarget, ConsumerTarget.State> listener : holdovers) {
                    listener.stateChanged(this, from, to);
                }
            } else if (!this._stateChangeListeners.isEmpty()) {
                for (StateChangeListener<ConsumerTarget, ConsumerTarget.State> listener : this._stateChangeListeners) {
                    listener.stateChanged(this, from, to);
                }
            }
            if (this._suspendedConsumerLoggingTicker != null) {
                if (to == ConsumerTarget.State.SUSPENDED) {
                    this._suspendedConsumerLoggingTicker.setStartTime(System.currentTimeMillis());
                    this.getSessionModel().addTicker(this._suspendedConsumerLoggingTicker);
                } else {
                    this.getSessionModel().removeTicker(this._suspendedConsumerLoggingTicker);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public final void notifyCurrentState() {
        for (StateChangeListener<ConsumerTarget, ConsumerTarget.State> listener : this._stateChangeListeners) {
            ConsumerTarget.State state = this.getState();
            listener.stateChanged(this, state, state);
        }
    }

    @Override
    public final void addStateListener(StateChangeListener<ConsumerTarget, ConsumerTarget.State> listener) {
        this._stateChangeListeners.add(listener);
    }

    @Override
    public void removeStateChangeListener(StateChangeListener<ConsumerTarget, ConsumerTarget.State> listener) {
        this._stateChangeListeners.remove(listener);
    }

    @Override
    public final boolean trySendLock() {
        return this._stateChangeLock.tryLock();
    }

    @Override
    public final void getSendLock() {
        this._stateChangeLock.lock();
    }

    @Override
    public final void releaseSendLock() {
        this._stateChangeLock.unlock();
    }

    @Override
    public boolean isPullOnly() {
        return this._isPullOnly;
    }

    @Override
    public final long send(ConsumerImpl consumer, MessageInstance entry, boolean batch) {
        AMQPConnection<?> amqpConnection = this.getSessionModel().getAMQPConnection();
        amqpConnection.reserveOutboundMessageSpace(entry.getMessage().getSize());
        this._queue.add(new ConsumerMessageInstancePair(consumer, entry, batch));
        amqpConnection.notifyWork();
        return entry.getMessage().getSize();
    }

    protected abstract void doSend(ConsumerImpl var1, MessageInstance var2, boolean var3);

    @Override
    public boolean hasMessagesToSend() {
        return !this._queue.isEmpty() || this.isPullOnly() && this.messagesAvailable();
    }

    private boolean messagesAvailable() {
        if (this.hasCredit()) {
            for (ConsumerImpl consumer : this._consumers) {
                if (!consumer.hasAvailableMessages()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendNextMessage() {
        ConsumerMessageInstancePair consumerMessage;
        if (this.isPullOnly()) {
            if (this._pullIterator == null || !this._pullIterator.hasNext()) {
                this._pullIterator = this.getConsumers().iterator();
            }
            if (this._pullIterator.hasNext()) {
                ConsumerImpl consumer = this._pullIterator.next();
                consumer.pullMessage();
            }
        }
        if ((consumerMessage = this._queue.poll()) != null) {
            try {
                ConsumerImpl consumer = consumerMessage.getConsumer();
                MessageInstance entry = consumerMessage.getEntry();
                boolean batch = consumerMessage.isBatch();
                this.doSend(consumer, entry, batch);
                if (consumer.acquires()) {
                    entry.makeAcquisitionStealable();
                }
            }
            finally {
                consumerMessage.release();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean close() {
        boolean closed = false;
        ConsumerTarget.State state = this.getState();
        this.getSendLock();
        try {
            ConsumerMessageInstancePair instance;
            while (!closed && state != ConsumerTarget.State.CLOSED) {
                closed = this.updateState(state, ConsumerTarget.State.CLOSED);
                if (closed) continue;
                state = this.getState();
            }
            while ((instance = this._queue.poll()) != null) {
                MessageInstance entry = instance.getEntry();
                entry.release(instance.getConsumer());
                instance.release();
            }
            this.doCloseInternal();
        }
        finally {
            this.releaseSendLock();
        }
        for (ConsumerImpl consumer : this._consumers) {
            consumer.close();
        }
        if (this._suspendedConsumerLoggingTicker != null) {
            this.getSessionModel().removeTicker(this._suspendedConsumerLoggingTicker);
        }
        return closed;
    }

    @Override
    public String toLogString() {
        return "[(** Multi-Queue **)] ";
    }

    protected abstract void doCloseInternal();
}

