/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.connection;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import org.apache.qpid.server.logging.messages.ConnectionMessages;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.plugin.ConnectionValidator;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.transport.AMQPConnection;
import org.apache.qpid.server.util.ParameterizedTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluggableService
public class ConnectionVersionValidator
implements ConnectionValidator {
    public static final String VIRTUALHOST_ALLOWED_CONNECTION_VERSION = "virtualhost.allowedConnectionVersion";
    public static final String VIRTUALHOST_LOGGED_CONNECTION_VERSION = "virtualhost.loggedConnectionVersion";
    public static final String VIRTUALHOST_REJECTED_CONNECTION_VERSION = "virtualhost.rejectedConnectionVersion";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionVersionValidator.class);
    private final Map<String, Set<List<String>>> _cachedLists = Collections.synchronizedMap(new HashMap());

    public ConnectionVersionValidator() {
        this._cachedLists.put(VIRTUALHOST_ALLOWED_CONNECTION_VERSION, Collections.synchronizedSet(Collections.newSetFromMap(new BoundedCache())));
        this._cachedLists.put(VIRTUALHOST_LOGGED_CONNECTION_VERSION, Collections.synchronizedSet(Collections.newSetFromMap(new BoundedCache())));
        this._cachedLists.put(VIRTUALHOST_REJECTED_CONNECTION_VERSION, Collections.synchronizedSet(Collections.newSetFromMap(new BoundedCache())));
    }

    @Override
    public boolean validateConnectionCreation(AMQPConnection<?> connection, VirtualHost<?> virtualHost) {
        String connectionVersion = connection.getClientVersion();
        if (connectionVersion == null) {
            connectionVersion = "";
        }
        boolean valid = true;
        if (!this.connectionMatches(virtualHost, VIRTUALHOST_ALLOWED_CONNECTION_VERSION, connectionVersion)) {
            if (this.connectionMatches(virtualHost, VIRTUALHOST_LOGGED_CONNECTION_VERSION, connectionVersion)) {
                virtualHost.getBroker().getEventLogger().message(ConnectionMessages.CLIENT_VERSION_LOG(connection.getClientVersion()));
            } else if (this.connectionMatches(virtualHost, VIRTUALHOST_REJECTED_CONNECTION_VERSION, connectionVersion)) {
                virtualHost.getBroker().getEventLogger().message(ConnectionMessages.CLIENT_VERSION_REJECT(connection.getClientVersion()));
                valid = false;
            }
        }
        return valid;
    }

    private boolean connectionMatches(VirtualHost<?> virtualHost, String listName, String connectionVersion) {
        List<String> versionRegexList = this.getContextValueList(virtualHost, listName);
        if (versionRegexList != null) {
            for (String versionRegEx : versionRegexList) {
                try {
                    if (!connectionVersion.matches(versionRegEx)) continue;
                    return true;
                }
                catch (PatternSyntaxException e) {
                    if (!this._cachedLists.get(listName).add(versionRegexList)) continue;
                    LOGGER.warn("Invalid regex in context variable " + listName + ": " + versionRegEx);
                }
            }
        }
        return false;
    }

    private List<String> getContextValueList(VirtualHost<?> virtualHost, String variableName) {
        if (virtualHost.getContextKeys(false).contains(variableName)) {
            return virtualHost.getContextValue(List.class, ParameterizedTypes.LIST_OF_STRINGS, variableName);
        }
        return Collections.emptyList();
    }

    @Override
    public String getType() {
        return "ConnectionVersionValidator";
    }

    private static class BoundedCache
    extends LinkedHashMap<List<String>, Boolean> {
        private static final int CACHE_SIZE = 20;

        private BoundedCache() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<List<String>, Boolean> eldest) {
            return this.size() >= 20;
        }
    }
}

