/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.configuration.updater;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Subject;
import org.apache.qpid.server.configuration.updater.Task;
import org.apache.qpid.server.configuration.updater.TaskExecutor;
import org.apache.qpid.server.pool.QpidByteBufferDisposingThreadPoolExecutor;
import org.apache.qpid.server.util.FutureHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskExecutorImpl
implements TaskExecutor {
    private static final String TASK_EXECUTION_THREAD_NAME = "Broker-Config";
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskExecutorImpl.class);
    private final TaskExecutor.PrincipalAccessor _principalAccessor;
    private volatile Thread _taskThread;
    private final AtomicBoolean _running = new AtomicBoolean();
    private volatile ListeningExecutorService _executor;
    private final ImmediateIfSameThreadExecutor _wrappedExecutor = new ImmediateIfSameThreadExecutor();
    private final String _name;

    public TaskExecutorImpl() {
        this(TASK_EXECUTION_THREAD_NAME, null);
    }

    public TaskExecutorImpl(String name, TaskExecutor.PrincipalAccessor principalAccessor) {
        this._name = name;
        this._principalAccessor = principalAccessor;
    }

    @Override
    public boolean isRunning() {
        return this._running.get();
    }

    @Override
    public void start() {
        if (this._running.compareAndSet(false, true)) {
            LOGGER.debug("Starting task executor {}", (Object)this._name);
            this._executor = MoreExecutors.listeningDecorator((ExecutorService)new QpidByteBufferDisposingThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    TaskExecutorImpl.this._taskThread = new TaskThread(r, TaskExecutorImpl.this._name, TaskExecutorImpl.this);
                    return TaskExecutorImpl.this._taskThread;
                }
            }));
            LOGGER.debug("Task executor is started");
        }
    }

    @Override
    public void stopImmediately() {
        ListeningExecutorService executor;
        if (this._running.compareAndSet(true, false) && (executor = this._executor) != null) {
            LOGGER.debug("Stopping task executor {} immediately", (Object)this._name);
            List<Runnable> cancelledTasks = executor.shutdownNow();
            for (Runnable runnable : cancelledTasks) {
                if (!(runnable instanceof RunnableFuture)) continue;
                ((RunnableFuture)runnable).cancel(true);
            }
            this._executor = null;
            this._taskThread = null;
            LOGGER.debug("Task executor was stopped immediately. Number of unfinished tasks: " + cancelledTasks.size());
        }
    }

    @Override
    public void stop() {
        ListeningExecutorService executor;
        if (this._running.compareAndSet(true, false) && (executor = this._executor) != null) {
            LOGGER.debug("Stopping task executor {}", (Object)this._name);
            executor.shutdown();
            this._executor = null;
            this._taskThread = null;
            LOGGER.debug("Task executor is stopped");
        }
    }

    @Override
    public <T, E extends Exception> ListenableFuture<T> submit(Task<T, E> userTask) throws E {
        return this.submitWrappedTask(new TaskLoggingWrapper<T, E>(userTask));
    }

    private <T, E extends Exception> ListenableFuture<T> submitWrappedTask(TaskLoggingWrapper<T, E> task) throws E {
        this.checkState(task);
        if (this.isTaskExecutorThread()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Running {} immediately", task);
            }
            T result = task.execute();
            return Futures.immediateFuture(result);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Submitting {} to executor {}", task, (Object)this._name);
        }
        return this._executor.submit(new CallableWrapper<T, E>(task));
    }

    @Override
    public void execute(Runnable command) {
        LOGGER.trace("Running runnable {} through executor interface", (Object)command);
        this._wrappedExecutor.execute(command);
    }

    @Override
    public <T, E extends Exception> T run(Task<T, E> userTask) throws CancellationException, E {
        TaskLoggingWrapper<T, E> task = new TaskLoggingWrapper<T, E>(userTask);
        return FutureHelper.await(this.submitWrappedTask(task));
    }

    private boolean isTaskExecutorThread() {
        return Thread.currentThread() == this._taskThread;
    }

    private void checkState(Task<?, ?> task) {
        if (!this._running.get()) {
            LOGGER.error("Task executor {} is not in ACTIVE state, unable to execute : {} ", (Object)this._name, task);
            throw new IllegalStateException("Task executor " + this._name + " is not in ACTIVE state");
        }
    }

    private Subject getContextSubject() {
        Subject contextSubject = Subject.getSubject(AccessController.getContext());
        if (contextSubject != null && this._principalAccessor != null) {
            Principal additionalPrincipal = this._principalAccessor.getPrincipal();
            Set<Principal> principals = contextSubject.getPrincipals();
            if (additionalPrincipal != null && !principals.contains(additionalPrincipal)) {
                HashSet<Principal> extendedPrincipals = new HashSet<Principal>(principals);
                extendedPrincipals.add(additionalPrincipal);
                contextSubject = new Subject(contextSubject.isReadOnly(), extendedPrincipals, contextSubject.getPublicCredentials(), contextSubject.getPrivateCredentials());
            }
        }
        return contextSubject;
    }

    @Override
    public TaskExecutor.Factory getFactory() {
        return new TaskExecutor.Factory(){

            @Override
            public TaskExecutor newInstance() {
                return new TaskExecutorImpl();
            }

            @Override
            public TaskExecutor newInstance(String name, TaskExecutor.PrincipalAccessor principalAccessor) {
                return new TaskExecutorImpl(name, principalAccessor);
            }
        };
    }

    private static class TaskThread
    extends Thread {
        private final TaskExecutorImpl _taskExecutor;

        public TaskThread(Runnable r, String name, TaskExecutorImpl taskExecutor) {
            super(r, name);
            this._taskExecutor = taskExecutor;
        }

        public TaskExecutorImpl getTaskExecutor() {
            return this._taskExecutor;
        }
    }

    private class ImmediateIfSameThreadExecutor
    implements Executor {
        private ImmediateIfSameThreadExecutor() {
        }

        @Override
        public void execute(final Runnable command) {
            if (TaskExecutorImpl.this.isTaskExecutorThread() || TaskExecutorImpl.this._executor == null && Thread.currentThread() instanceof TaskThread && ((TaskThread)Thread.currentThread()).getTaskExecutor() == TaskExecutorImpl.this) {
                command.run();
            } else {
                final Subject subject = TaskExecutorImpl.this.getContextSubject();
                TaskExecutorImpl.this._executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        Subject.doAs(subject, new PrivilegedAction<Void>(){

                            @Override
                            public Void run() {
                                command.run();
                                return null;
                            }
                        });
                    }
                });
            }
        }
    }

    private static class ImmediateFuture<T>
    implements Future<T> {
        private T _result;

        public ImmediateFuture(T result) {
            this._result = result;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public T get() {
            return this._result;
        }

        @Override
        public T get(long timeout, TimeUnit unit) {
            return this.get();
        }
    }

    private class CallableWrapper<T, E extends Exception>
    implements Callable<T> {
        private final Task<T, E> _userTask;
        private final Subject _contextSubject;
        private final AtomicReference<Throwable> _throwable;

        public CallableWrapper(Task<T, E> userWork) {
            this._userTask = userWork;
            this._contextSubject = TaskExecutorImpl.this.getContextSubject();
            this._throwable = new AtomicReference();
        }

        @Override
        public T call() throws Exception {
            Object result = Subject.doAs(this._contextSubject, new PrivilegedAction<T>(){

                @Override
                public T run() {
                    try {
                        return CallableWrapper.this._userTask.execute();
                    }
                    catch (Throwable t) {
                        CallableWrapper.this._throwable.set(t);
                        return null;
                    }
                }
            });
            Throwable t = this._throwable.get();
            if (t != null) {
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw (Exception)t;
            }
            return result;
        }
    }

    private class TaskLoggingWrapper<T, E extends Exception>
    implements Task<T, E> {
        private final Task<T, E> _task;

        public TaskLoggingWrapper(Task<T, E> task) {
            this._task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T execute() throws E {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Performing {}", (Object)this);
            }
            boolean success = false;
            T result = null;
            try {
                result = this._task.execute();
                success = true;
            }
            finally {
                if (LOGGER.isDebugEnabled()) {
                    if (success) {
                        LOGGER.debug("{} performed successfully with result: {}", (Object)this, result);
                    } else {
                        LOGGER.debug("{} failed to perform successfully", (Object)this);
                    }
                }
            }
            return result;
        }

        @Override
        public String getObject() {
            return this._task.getObject();
        }

        @Override
        public String getAction() {
            return this._task.getAction();
        }

        @Override
        public String getArguments() {
            return this._task.getArguments();
        }

        public String toString() {
            String arguments = this.getArguments();
            if (arguments == null) {
                return String.format("Task['%s' on '%s']", this.getAction(), this.getObject());
            }
            return String.format("Task['%s' on '%s' with arguments '%s']", this.getAction(), this.getObject(), arguments);
        }
    }
}

