/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.binding;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.configuration.updater.Task;
import org.apache.qpid.server.exchange.AbstractExchange;
import org.apache.qpid.server.filter.AMQInvalidArgumentException;
import org.apache.qpid.server.filter.FilterSupport;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.messages.BindingMessages;
import org.apache.qpid.server.logging.subjects.BindingLogSubject;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.Binding;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.security.access.Operation;

public class BindingImpl
extends AbstractConfiguredObject<BindingImpl>
implements Binding<BindingImpl> {
    private final String _bindingKey;
    private final Queue<?> _queue;
    private final Exchange<?> _exchange;
    @ManagedAttributeField
    private Map<String, Object> _arguments;
    private final AtomicLong _matches = new AtomicLong();
    private BindingLogSubject _logSubject;

    public BindingImpl(Map<String, Object> attributes, Queue<?> queue, Exchange<?> exchange) {
        super(BindingImpl.parentsMap(queue, exchange), BindingImpl.stripEmptyArguments(BindingImpl.enhanceWithDurable(attributes, queue, exchange)));
        this._bindingKey = this.getName();
        this._queue = queue;
        this._exchange = exchange;
    }

    private static Map<String, Object> stripEmptyArguments(Map<String, Object> attributes) {
        Map<String, Object> returnVal;
        if (attributes != null && attributes.containsKey("arguments") && attributes.get("arguments") instanceof Map && ((Map)attributes.get("arguments")).isEmpty()) {
            returnVal = new HashMap<String, Object>(attributes);
            returnVal.remove("arguments");
        } else {
            returnVal = attributes;
        }
        return returnVal;
    }

    @Override
    protected void onOpen() {
        super.onOpen();
        this._logSubject = new BindingLogSubject(this._bindingKey, this._exchange, this._queue);
        this.getEventLogger().message(this._logSubject, BindingMessages.CREATED(String.valueOf(this.getArguments()), this.getArguments() != null && !this.getArguments().isEmpty()));
        if (this._exchange instanceof AbstractExchange) {
            ((AbstractExchange)this._exchange).doAddBinding(this);
        }
    }

    private static Map<String, Object> enhanceWithDurable(Map<String, Object> attributes, Queue<?> queue, Exchange<?> exchange) {
        if (!attributes.containsKey("durable")) {
            attributes = new HashMap<String, Object>(attributes);
            attributes.put("durable", queue.isDurable() && exchange.isDurable());
        }
        return attributes;
    }

    @Override
    public String getBindingKey() {
        return this._bindingKey;
    }

    @Override
    public Queue<?> getQueue() {
        return this._queue;
    }

    @Override
    public Exchange<?> getExchange() {
        return this._exchange;
    }

    @Override
    public Map<String, Object> getArguments() {
        return this._arguments;
    }

    @Override
    public void incrementMatches() {
        this._matches.incrementAndGet();
    }

    @Override
    public long getMatches() {
        return this._matches.get();
    }

    @Override
    public <C extends ConfiguredObject> Collection<C> getChildren(Class<C> clazz) {
        return Collections.emptySet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BindingImpl)) {
            return false;
        }
        BindingImpl binding = (BindingImpl)o;
        return (this._bindingKey == null ? binding.getBindingKey() == null : this._bindingKey.equals(binding.getBindingKey())) && (this._exchange == null ? binding.getExchange() == null : this._exchange.equals(binding.getExchange())) && (this._queue == null ? binding.getQueue() == null : this._queue.equals(binding.getQueue()));
    }

    public int hashCode() {
        int result = this._bindingKey == null ? 1 : this._bindingKey.hashCode();
        result = 31 * result + (this._queue == null ? 3 : this._queue.hashCode());
        result = 31 * result + (this._exchange == null ? 5 : this._exchange.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "Binding{bindingKey=" + this._bindingKey + ", exchange=" + this._exchange + ", queue=" + this._queue + ", id= " + this.getId() + " }";
    }

    @StateTransition(currentState={State.ACTIVE}, desiredState=State.DELETED)
    private ListenableFuture<Void> doDelete() {
        ListenableFuture<Void> removeBinding = this._exchange.removeBindingAsync(this);
        return this.doAfter(removeBinding, new Runnable(){

            @Override
            public void run() {
                BindingImpl.this.getEventLogger().message(BindingImpl.this._logSubject, BindingMessages.DELETED());
                BindingImpl.this.deleted();
                BindingImpl.this.setState(State.DELETED);
            }
        });
    }

    @StateTransition(currentState={State.UNINITIALIZED}, desiredState=State.ACTIVE)
    private ListenableFuture<Void> activate() {
        this.setState(State.ACTIVE);
        return Futures.immediateFuture(null);
    }

    private EventLogger getEventLogger() {
        return this._exchange.getEventLogger();
    }

    public void setArguments(final Map<String, Object> arguments) {
        this.runTask(new Task<Void, RuntimeException>(){

            @Override
            public Void execute() {
                BindingImpl.this._arguments = arguments;
                BindingImpl.super.setAttributes(Collections.singletonMap("arguments", arguments));
                return null;
            }

            @Override
            public String getObject() {
                return BindingImpl.this.toString();
            }

            @Override
            public String getAction() {
                return "set arguments";
            }

            @Override
            public String getArguments() {
                return arguments.toString();
            }
        });
    }

    @Override
    public void validateOnCreate() {
        this.authorise(Operation.CREATE);
        Queue<?> queue = this.getQueue();
        Map<String, Object> arguments = this.getArguments();
        if (arguments != null && !arguments.isEmpty() && FilterSupport.argumentsContainFilter(arguments)) {
            try {
                FilterSupport.createMessageFilter(arguments, queue);
            }
            catch (AMQInvalidArgumentException e) {
                throw new IllegalConfigurationException(e.getMessage(), e);
            }
        }
    }
}

