/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server;

import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BrokerOptions {
    public static final String QPID_WORK_DIR = "qpid.work_dir";
    public static final String QPID_HOME_DIR = "qpid.home_dir";
    public static final String DEFAULT_INITIAL_CONFIG_NAME = "initial-config.json";
    public static final String DEFAULT_STORE_TYPE = "JSON";
    public static final String DEFAULT_CONFIG_NAME_PREFIX = "config";
    public static final String DEFAULT_INITIAL_CONFIG_LOCATION = BrokerOptions.class.getClassLoader().getResource("initial-config.json").toExternalForm();
    public static final String MANAGEMENT_MODE_USER_NAME = "mm_admin";
    private static final File FALLBACK_WORK_DIR = new File(System.getProperty("user.dir"), "work");
    private String _configurationStoreLocation;
    private String _configurationStoreType;
    private String _initialConfigurationLocation;
    private boolean _managementMode;
    private boolean _managementModeQuiesceVhosts;
    private int _managementModeHttpPortOverride;
    private String _managementModePassword;
    private boolean _overwriteConfigurationStore;
    private Map<String, String> _configProperties = new HashMap<String, String>();
    private boolean _startupLoggedToSystemOut = true;
    private String _initialSystemProperties;

    public Map<String, Object> convertToSystemConfigAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("storePath", this.getConfigurationStoreLocation());
        attributes.put("context", this.getConfigProperties());
        attributes.put("managementMode", this._managementMode);
        attributes.put("managementModeQuiesceVirtualHosts", this._managementModeQuiesceVhosts);
        attributes.put("managementModeHttpPortOverride", this._managementModeHttpPortOverride);
        attributes.put("managementModePassword", this._managementModePassword);
        attributes.put("initialConfigurationLocation", this.getInitialConfigurationLocation());
        attributes.put("startupLoggedToSystemOut", this.isStartupLoggedToSystemOut());
        return attributes;
    }

    public String getManagementModePassword() {
        return this._managementModePassword;
    }

    public void setManagementModePassword(String managementModePassword) {
        this._managementModePassword = managementModePassword;
    }

    public boolean isManagementMode() {
        return this._managementMode;
    }

    public void setManagementMode(boolean managementMode) {
        this._managementMode = managementMode;
    }

    public boolean isManagementModeQuiesceVirtualHosts() {
        return this._managementModeQuiesceVhosts;
    }

    public void setManagementModeQuiesceVirtualHosts(boolean managementModeQuiesceVhosts) {
        this._managementModeQuiesceVhosts = managementModeQuiesceVhosts;
    }

    public int getManagementModeHttpPortOverride() {
        return this._managementModeHttpPortOverride;
    }

    public void setManagementModeHttpPortOverride(int managementModeHttpPortOverride) {
        this._managementModeHttpPortOverride = managementModeHttpPortOverride;
    }

    public String getConfigurationStoreType() {
        if (this._configurationStoreType == null) {
            return DEFAULT_STORE_TYPE;
        }
        return this._configurationStoreType;
    }

    public void setConfigurationStoreType(String configurationStoreType) {
        this._configurationStoreType = configurationStoreType;
    }

    public String getConfigurationStoreLocation() {
        if (this._configurationStoreLocation == null) {
            String workDir = this.getWorkDir();
            String storeType = this.getConfigurationStoreType();
            return new File(workDir, "config." + storeType.toLowerCase()).getAbsolutePath();
        }
        return this._configurationStoreLocation;
    }

    public void setConfigurationStoreLocation(String configurationStore) {
        this._configurationStoreLocation = configurationStore;
    }

    public boolean isOverwriteConfigurationStore() {
        return this._overwriteConfigurationStore;
    }

    public void setOverwriteConfigurationStore(boolean overwrite) {
        this._overwriteConfigurationStore = overwrite;
    }

    public String getInitialConfigurationLocation() {
        if (this._initialConfigurationLocation == null) {
            String overriddenDefaultConfigurationLocation = System.getProperty("qpid.initialConfigurationLocation");
            if (overriddenDefaultConfigurationLocation != null) {
                URL resource = BrokerOptions.class.getClassLoader().getResource(overriddenDefaultConfigurationLocation);
                if (resource == null) {
                    throw new IllegalArgumentException(String.format("Initial configuration '%s' is not found", overriddenDefaultConfigurationLocation));
                }
                return resource.toExternalForm();
            }
            return DEFAULT_INITIAL_CONFIG_LOCATION;
        }
        return this._initialConfigurationLocation;
    }

    public void setInitialConfigurationLocation(String initialConfigurationLocation) {
        this._initialConfigurationLocation = initialConfigurationLocation;
    }

    public void setConfigProperty(String name, String value) {
        if (value == null) {
            this._configProperties.remove(name);
        } else {
            this._configProperties.put(name, value);
        }
    }

    public Map<String, String> getConfigProperties() {
        ConcurrentHashMap<String, String> properties = new ConcurrentHashMap<String, String>();
        properties.putAll(this._configProperties);
        properties.putIfAbsent(QPID_WORK_DIR, this.getWorkDir());
        String homeDir = this.getHomeDir();
        if (homeDir != null) {
            properties.putIfAbsent(QPID_HOME_DIR, homeDir);
        }
        return Collections.unmodifiableMap(properties);
    }

    private String getProperty(String propName, String altPropName, String defaultValue) {
        String value = this.getProperty(propName);
        if (value == null && (value = this.getProperty(altPropName)) == null) {
            value = defaultValue;
        }
        return value;
    }

    private String getProperty(String propName) {
        return this._configProperties.containsKey(propName) ? this._configProperties.get(propName) : (System.getProperties().containsKey(propName) ? System.getProperty(propName) : System.getenv(propName));
    }

    private String getWorkDir() {
        return this.getProperty(QPID_WORK_DIR, "QPID_WORK", FALLBACK_WORK_DIR.getAbsolutePath());
    }

    private String getHomeDir() {
        return this.getProperty(QPID_HOME_DIR, "QPID_HOME", null);
    }

    public boolean isStartupLoggedToSystemOut() {
        return this._startupLoggedToSystemOut;
    }

    public void setStartupLoggedToSystemOut(boolean startupLoggedToSystemOut) {
        this._startupLoggedToSystemOut = startupLoggedToSystemOut;
    }

    public String getInitialSystemProperties() {
        return this._initialSystemProperties;
    }

    public void setInitialSystemProperties(String initialSystemProperties) {
        this._initialSystemProperties = initialSystemProperties;
    }

    public String toString() {
        return "BrokerOptions{_configurationStoreLocation='" + this._configurationStoreLocation + '\'' + ", _configurationStoreType='" + this._configurationStoreType + '\'' + ", _initialConfigurationLocation='" + this._initialConfigurationLocation + '\'' + ", _managementMode=" + this._managementMode + ", _managementModeQuiesceVhosts=" + this._managementModeQuiesceVhosts + ", _managementModeHttpPortOverride=" + this._managementModeHttpPortOverride + ", _overwriteConfigurationStore=" + this._overwriteConfigurationStore + ", _configProperties=" + this._configProperties + ", _startupLoggedToSystemOut=" + this._startupLoggedToSystemOut + ", _initialSystemProperties='" + this._initialSystemProperties + '\'' + '}';
    }
}

