/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.security.Result;
import org.apache.qpid.server.security.access.config.AclAction;
import org.apache.qpid.server.security.access.config.AclRulePredicates;
import org.apache.qpid.server.security.access.config.LegacyOperation;
import org.apache.qpid.server.security.access.config.ObjectProperties;
import org.apache.qpid.server.security.access.config.ObjectType;
import org.apache.qpid.server.security.access.config.Rule;
import org.apache.qpid.server.security.access.config.RuleSet;
import org.apache.qpid.server.security.access.plugins.RuleOutcome;

final class RuleSetCreator {
    private final SortedMap<Integer, Rule> _rules = new TreeMap<Integer, Rule>();
    private static final Integer INCREMENT = 10;
    private Result _defaultResult = Result.DENIED;

    RuleSetCreator() {
    }

    boolean isValidNumber(Integer number) {
        return !this._rules.containsKey(number);
    }

    void addRule(Integer number, String identity, RuleOutcome ruleOutcome, LegacyOperation operation) {
        AclAction action = new AclAction(operation);
        this.addRule(number, identity, ruleOutcome, action);
    }

    void addRule(Integer number, String identity, RuleOutcome ruleOutcome, LegacyOperation operation, ObjectType object, ObjectProperties properties) {
        AclAction action = new AclAction(operation, object, properties);
        this.addRule(number, identity, ruleOutcome, action);
    }

    void addRule(Integer number, String identity, RuleOutcome ruleOutcome, LegacyOperation operation, ObjectType object, AclRulePredicates predicates) {
        AclAction aclAction = new AclAction(operation, object, predicates);
        this.addRule(number, identity, ruleOutcome, aclAction);
    }

    private boolean ruleExists(String identity, AclAction action) {
        for (Rule rule : this._rules.values()) {
            if (!rule.getIdentity().equals(identity) || !rule.getAclAction().equals(action)) continue;
            return true;
        }
        return false;
    }

    private void addRule(Integer number, String identity, RuleOutcome ruleOutcome, AclAction action) {
        if (!action.isAllowed()) {
            throw new IllegalArgumentException("Action is not allowed: " + action);
        }
        if (this.ruleExists(identity, action)) {
            return;
        }
        Rule rule = new Rule(identity, action, ruleOutcome);
        if (number == null) {
            number = this._rules.isEmpty() ? Integer.valueOf(0) : Integer.valueOf(this._rules.lastKey() + INCREMENT);
        }
        this._rules.put(number, rule);
    }

    void setDefaultResult(Result defaultResult) {
        this._defaultResult = defaultResult;
    }

    Result getDefaultResult() {
        return this._defaultResult;
    }

    SortedMap<Integer, Rule> getRules() {
        return this._rules;
    }

    RuleSet createRuleSet(EventLoggerProvider eventLoggerProvider) {
        return new RuleSet(eventLoggerProvider, this._rules.values(), this._defaultResult);
    }
}

