/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import java.util.ArrayList;
import java.util.List;

public class StartupAppender
extends AppenderBase<ILoggingEvent> {
    private List<ILoggingEvent> _accumulatedLoggingEvents = new ArrayList<ILoggingEvent>();
    private Level _consoleAppenderAcceptLogLevel = Level.INFO;

    public StartupAppender() {
        this.setName(StartupAppender.class.getName());
        String overriddenLogLevel = System.getProperty("qpid.startup_failover_console_log_level");
        if (overriddenLogLevel != null) {
            this._consoleAppenderAcceptLogLevel = Level.valueOf((String)overriddenLogLevel);
        }
    }

    protected synchronized void append(ILoggingEvent e) {
        this._accumulatedLoggingEvents.add(e);
    }

    public synchronized void replayAccumulatedEvents(Appender<ILoggingEvent> appender) {
        for (ILoggingEvent event : this._accumulatedLoggingEvents) {
            appender.doAppend((Object)event);
        }
    }

    public void logToConsole() {
        Context context = this.getContext();
        ConsoleAppender consoleAppender = new ConsoleAppender();
        consoleAppender.setContext(context);
        PatternLayoutEncoder patternLayoutEncoder = new PatternLayoutEncoder();
        patternLayoutEncoder.setContext(context);
        patternLayoutEncoder.setPattern("%X{qpid.log.prefix}%d{HH:mm:ss.SSS} [%thread] %-5level %logger{36} - %msg%n");
        patternLayoutEncoder.start();
        consoleAppender.addFilter((Filter)new Filter<ILoggingEvent>(){

            public FilterReply decide(ILoggingEvent event) {
                return event.getLevel().isGreaterOrEqual(StartupAppender.this._consoleAppenderAcceptLogLevel) ? FilterReply.ACCEPT : FilterReply.DENY;
            }
        });
        consoleAppender.setEncoder((Encoder)patternLayoutEncoder);
        consoleAppender.start();
        this.replayAccumulatedEvents((Appender<ILoggingEvent>)consoleAppender);
        consoleAppender.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        super.stop();
        StartupAppender startupAppender = this;
        synchronized (startupAppender) {
            this._accumulatedLoggingEvents.clear();
        }
    }
}

