/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.logback;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.apache.qpid.server.logging.LogFileDetails;
import org.apache.qpid.server.logging.PathContent;
import org.apache.qpid.server.logging.ZippedContent;
import org.apache.qpid.server.logging.logback.RollingPolicyDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RolloverWatcher
implements RollingPolicyDecorator.RolloverListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(RolloverWatcher.class);
    private static final Comparator<LogFileDetails> LAST_MODIFIED_COMPARATOR = new Comparator<LogFileDetails>(){

        @Override
        public int compare(LogFileDetails o1, LogFileDetails o2) {
            return Long.compare(o2.getLastModified(), o1.getLastModified());
        }
    };
    private final Path _activeFilePath;
    private volatile Collection<String> _rolledFiles;
    private volatile Path _baseFolder;

    public RolloverWatcher(String activeFileName) {
        this._activeFilePath = new File(activeFileName).toPath();
        this._rolledFiles = Collections.emptyList();
    }

    @Override
    public void onRollover(Path baseFolder, String[] relativeFileNames) {
        this._rolledFiles = Collections.unmodifiableCollection(Arrays.asList(relativeFileNames));
        this._baseFolder = baseFolder;
    }

    @Override
    public void onNoRolloverDetected(Path baseFolder, String[] relativeFileNames) {
        if (this._baseFolder == null) {
            this._baseFolder = baseFolder;
        }
        LOGGER.warn("Exceeded maximum number of rescans without detecting rolled over log file.");
    }

    public PathContent getFileContent(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("File name cannot be null");
        }
        Path path = this.getPath(fileName);
        return new PathContent(path, this.getContentType(fileName));
    }

    private Path getPath(String fileName) {
        Path path = null;
        File active = this._activeFilePath.toFile();
        if (fileName.equals(active.getName())) {
            path = active.toPath();
        } else if (this._rolledFiles.contains(fileName)) {
            path = this._baseFolder.resolve(fileName);
        }
        return path;
    }

    public Collection<String> getRolledFiles() {
        return this._rolledFiles;
    }

    public List<LogFileDetails> getLogFileDetails() {
        ArrayList<LogFileDetails> results = new ArrayList<LogFileDetails>();
        results.add(this.getFileDetails(this._activeFilePath));
        ArrayList<String> rolledFiles = new ArrayList<String>(this._rolledFiles);
        for (String fileName : rolledFiles) {
            Path file = this._baseFolder.resolve(fileName);
            LogFileDetails details = this.getFileDetails(file);
            results.add(details);
        }
        Collections.sort(results, LAST_MODIFIED_COMPARATOR);
        return results;
    }

    private LogFileDetails getFileDetails(Path path) {
        File file = path.toFile();
        return new LogFileDetails(this.getDisplayName(path), file.lastModified(), file.length());
    }

    private String getDisplayName(Path path) {
        String displayName = path.getFileName().toString();
        if (!this._activeFilePath.equals(path) && this._baseFolder != null) {
            try {
                displayName = this._baseFolder.relativize(path).toString();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return displayName;
    }

    public String getContentType(String fileName) {
        String fileNameLower = fileName.toLowerCase();
        if (fileNameLower.endsWith(".gz")) {
            return "application/x-gzip";
        }
        if (fileNameLower.endsWith(".zip")) {
            return "application/x-zip";
        }
        return "text/plain";
    }

    public ZippedContent getFilesAsZippedContent(Set<String> fileNames) {
        if (fileNames == null) {
            throw new IllegalArgumentException("File name cannot be null");
        }
        TreeMap<String, Path> paths = new TreeMap<String, Path>();
        for (String name : fileNames) {
            Path filePath = this.getPath(name);
            if (filePath == null) continue;
            paths.put(name, filePath);
        }
        return new ZippedContent(paths);
    }

    public ZippedContent getAllFilesAsZippedContent() {
        HashSet<String> fileNames = new HashSet<String>(this._rolledFiles);
        fileNames.add(this.getDisplayName(this._activeFilePath));
        return this.getFilesAsZippedContent(fileNames);
    }
}

