/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.Filter;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import org.apache.qpid.server.logging.LogLevel;
import org.apache.qpid.server.logging.logback.LoggerNameAndLevelFilter;
import org.apache.qpid.server.logging.logback.QpidLoggerTurboFilter;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;

public abstract class AbstractNameAndLevelLogInclusionRule<X extends AbstractNameAndLevelLogInclusionRule<X>>
extends AbstractConfiguredObject<X> {
    @ManagedAttributeField
    private String _loggerName;
    @ManagedAttributeField(afterSet="logLevelAfterSet")
    private LogLevel _level;
    private LoggerNameAndLevelFilter _filter;

    protected AbstractNameAndLevelLogInclusionRule(Map<Class<? extends ConfiguredObject>, ConfiguredObject<?>> parents, Map<String, Object> attributes) {
        super(parents, attributes);
    }

    protected void postResolve() {
        super.postResolve();
        this._filter = new LoggerNameAndLevelFilter(this.getLoggerName(), Level.toLevel((String)this.getLevel().name()));
    }

    public String getLoggerName() {
        return this._loggerName;
    }

    public LogLevel getLevel() {
        return this._level;
    }

    private void logLevelAfterSet() {
        if (this._filter != null) {
            this._filter.setLevel(Level.toLevel((String)this.getLevel().name()));
            QpidLoggerTurboFilter.filterChangedOnRootContext(this._filter);
        }
    }

    public Filter<ILoggingEvent> asFilter() {
        return this._filter;
    }

    @StateTransition(currentState={State.ACTIVE, State.ERRORED, State.UNINITIALIZED}, desiredState=State.DELETED)
    private ListenableFuture<Void> doDelete() {
        return this.doAfterAlways(this.closeAsync(), new Runnable(){

            @Override
            public void run() {
                AbstractNameAndLevelLogInclusionRule.this.deleted();
                QpidLoggerTurboFilter.filterRemovedFromRootContext(AbstractNameAndLevelLogInclusionRule.this._filter);
                AbstractNameAndLevelLogInclusionRule.this.setState(State.DELETED);
            }
        });
    }

    @StateTransition(currentState={State.ERRORED, State.UNINITIALIZED}, desiredState=State.ACTIVE)
    private ListenableFuture<Void> doActivate() {
        this.setState(State.ACTIVE);
        QpidLoggerTurboFilter.filterAddedToRootContext(this._filter);
        return Futures.immediateFuture(null);
    }
}

